/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.serviceusage.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.serviceusage.v1.ServiceUsageRequest;
import com.google.api.services.serviceusage.v1.ServiceUsageRequestInitializer;
import com.google.api.services.serviceusage.v1.model.BatchEnableServicesRequest;
import com.google.api.services.serviceusage.v1.model.BatchGetServicesResponse;
import com.google.api.services.serviceusage.v1.model.CancelOperationRequest;
import com.google.api.services.serviceusage.v1.model.DisableServiceRequest;
import com.google.api.services.serviceusage.v1.model.Empty;
import com.google.api.services.serviceusage.v1.model.EnableServiceRequest;
import com.google.api.services.serviceusage.v1.model.GoogleApiServiceusageV1Service;
import com.google.api.services.serviceusage.v1.model.ListOperationsResponse;
import com.google.api.services.serviceusage.v1.model.ListPublicServicesResponse;
import com.google.api.services.serviceusage.v1.model.ListServicesResponse;
import com.google.api.services.serviceusage.v1.model.Operation;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class ServiceUsage
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://serviceusage.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://serviceusage.googleapis.com/";

    public ServiceUsage(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    ServiceUsage(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Operations operations() {
        return new Operations();
    }

    public PublicServices publicServices() {
        return new PublicServices();
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0-SNAPSHOT of the Service Usage API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://serviceusage.googleapis.com/", ServiceUsage.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ServiceUsage.DEFAULT_BATCH_PATH);
        }

        public ServiceUsage build() {
            return new ServiceUsage(this);
        }

        @CanIgnoreReturnValue
        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        @CanIgnoreReturnValue
        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        @CanIgnoreReturnValue
        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        @CanIgnoreReturnValue
        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        @CanIgnoreReturnValue
        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        @CanIgnoreReturnValue
        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        @CanIgnoreReturnValue
        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        @CanIgnoreReturnValue
        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        @CanIgnoreReturnValue
        public Builder setServiceUsageRequestInitializer(ServiceUsageRequestInitializer serviceusageRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)serviceusageRequestInitializer);
        }

        @CanIgnoreReturnValue
        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Operations {
        public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
            Cancel result = new Cancel(name, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List(this);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Cancel
        extends ServiceUsageRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String name, CancelOperationRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            @CanIgnoreReturnValue
            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            @CanIgnoreReturnValue
            public Cancel setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ServiceUsageRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(ServiceUsage.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            @CanIgnoreReturnValue
            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            @CanIgnoreReturnValue
            public Delete setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Get
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(ServiceUsage.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            @CanIgnoreReturnValue
            public Get setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class List
        extends ServiceUsageRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/operations";
            @Key
            private String name;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Operations this$1) {
                super(this$1.ServiceUsage.this, "GET", REST_PATH, null, ListOperationsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            @CanIgnoreReturnValue
            public List setName(String name) {
                this.name = name;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            @CanIgnoreReturnValue
            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            @CanIgnoreReturnValue
            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            @CanIgnoreReturnValue
            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class PublicServices {
        public List list() throws IOException {
            List result = new List(this);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ServiceUsageRequest<ListPublicServicesResponse> {
            private static final String REST_PATH = "v1/publicServices";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(PublicServices this$1) {
                super(this$1.ServiceUsage.this, "GET", REST_PATH, null, ListPublicServicesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            @CanIgnoreReturnValue
            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            @CanIgnoreReturnValue
            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Services {
        public BatchEnable batchEnable(String parent, BatchEnableServicesRequest content) throws IOException {
            BatchEnable result = new BatchEnable(parent, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public BatchGet batchGet(String parent) throws IOException {
            BatchGet result = new BatchGet(parent);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Disable disable(String name, DisableServiceRequest content) throws IOException {
            Disable result = new Disable(name, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Enable enable(String name, EnableServiceRequest content) throws IOException {
            Enable result = new Enable(name, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class BatchEnable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+parent}/services:batchEnable";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected BatchEnable(String parent, BatchEnableServicesRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            @CanIgnoreReturnValue
            public BatchEnable set$Xgafv(String $Xgafv) {
                return (BatchEnable)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public BatchEnable setAccessToken(String accessToken) {
                return (BatchEnable)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public BatchEnable setAlt(String alt) {
                return (BatchEnable)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public BatchEnable setCallback(String callback) {
                return (BatchEnable)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public BatchEnable setFields(String fields) {
                return (BatchEnable)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public BatchEnable setKey(String key) {
                return (BatchEnable)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public BatchEnable setOauthToken(String oauthToken) {
                return (BatchEnable)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public BatchEnable setPrettyPrint(Boolean prettyPrint) {
                return (BatchEnable)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public BatchEnable setQuotaUser(String quotaUser) {
                return (BatchEnable)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public BatchEnable setUploadType(String uploadType) {
                return (BatchEnable)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public BatchEnable setUploadProtocol(String uploadProtocol) {
                return (BatchEnable)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            @CanIgnoreReturnValue
            public BatchEnable setParent(String parent) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public BatchEnable set(String parameterName, Object value) {
                return (BatchEnable)super.set(parameterName, value);
            }
        }

        public class BatchGet
        extends ServiceUsageRequest<BatchGetServicesResponse> {
            private static final String REST_PATH = "v1/{+parent}/services:batchGet";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private java.util.List<String> names;

            protected BatchGet(String parent) {
                super(ServiceUsage.this, "GET", REST_PATH, null, BatchGetServicesResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public BatchGet set$Xgafv(String $Xgafv) {
                return (BatchGet)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public BatchGet setAccessToken(String accessToken) {
                return (BatchGet)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public BatchGet setAlt(String alt) {
                return (BatchGet)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public BatchGet setCallback(String callback) {
                return (BatchGet)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public BatchGet setFields(String fields) {
                return (BatchGet)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public BatchGet setKey(String key) {
                return (BatchGet)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public BatchGet setOauthToken(String oauthToken) {
                return (BatchGet)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public BatchGet setPrettyPrint(Boolean prettyPrint) {
                return (BatchGet)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public BatchGet setQuotaUser(String quotaUser) {
                return (BatchGet)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public BatchGet setUploadType(String uploadType) {
                return (BatchGet)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public BatchGet setUploadProtocol(String uploadProtocol) {
                return (BatchGet)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            @CanIgnoreReturnValue
            public BatchGet setParent(String parent) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public java.util.List<String> getNames() {
                return this.names;
            }

            @CanIgnoreReturnValue
            public BatchGet setNames(java.util.List<String> names) {
                this.names = names;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public BatchGet set(String parameterName, Object value) {
                return (BatchGet)super.set(parameterName, value);
            }
        }

        public class Disable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}:disable";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Disable(String name, DisableServiceRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            @CanIgnoreReturnValue
            public Disable set$Xgafv(String $Xgafv) {
                return (Disable)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public Disable setAccessToken(String accessToken) {
                return (Disable)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public Disable setAlt(String alt) {
                return (Disable)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public Disable setCallback(String callback) {
                return (Disable)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public Disable setFields(String fields) {
                return (Disable)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public Disable setKey(String key) {
                return (Disable)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public Disable setOauthToken(String oauthToken) {
                return (Disable)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public Disable setPrettyPrint(Boolean prettyPrint) {
                return (Disable)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public Disable setQuotaUser(String quotaUser) {
                return (Disable)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public Disable setUploadType(String uploadType) {
                return (Disable)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public Disable setUploadProtocol(String uploadProtocol) {
                return (Disable)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            @CanIgnoreReturnValue
            public Disable setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public Disable set(String parameterName, Object value) {
                return (Disable)super.set(parameterName, value);
            }
        }

        public class Enable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}:enable";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Enable(String name, EnableServiceRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            @CanIgnoreReturnValue
            public Enable set$Xgafv(String $Xgafv) {
                return (Enable)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public Enable setAccessToken(String accessToken) {
                return (Enable)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public Enable setAlt(String alt) {
                return (Enable)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public Enable setCallback(String callback) {
                return (Enable)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public Enable setFields(String fields) {
                return (Enable)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public Enable setKey(String key) {
                return (Enable)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public Enable setOauthToken(String oauthToken) {
                return (Enable)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public Enable setPrettyPrint(Boolean prettyPrint) {
                return (Enable)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public Enable setQuotaUser(String quotaUser) {
                return (Enable)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public Enable setUploadType(String uploadType) {
                return (Enable)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public Enable setUploadProtocol(String uploadProtocol) {
                return (Enable)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            @CanIgnoreReturnValue
            public Enable setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public Enable set(String parameterName, Object value) {
                return (Enable)super.set(parameterName, value);
            }
        }

        public class Get
        extends ServiceUsageRequest<GoogleApiServiceusageV1Service> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(ServiceUsage.this, "GET", REST_PATH, null, GoogleApiServiceusageV1Service.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            @CanIgnoreReturnValue
            public Get setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class List
        extends ServiceUsageRequest<ListServicesResponse> {
            private static final String REST_PATH = "v1/{+parent}/services";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String filter;

            protected List(String parent) {
                super(ServiceUsage.this, "GET", REST_PATH, null, ListServicesResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            @CanIgnoreReturnValue
            public List setParent(String parent) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            @CanIgnoreReturnValue
            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            @CanIgnoreReturnValue
            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            @CanIgnoreReturnValue
            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }
}

