/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.game.AdbPath;
import com.android.tools.game.CommonService;
import com.android.tools.game.CommonWindowWrapper;
import com.android.tools.game.FakeToolWindow;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.device.explorer.DeviceExplorerController;
import com.android.tools.idea.device.explorer.DeviceExplorerModel;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFileManager;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerControllerImpl;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerModel;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerView;
import com.android.tools.idea.device.explorer.files.ui.DeviceFileExplorerViewImpl;
import com.android.tools.idea.device.explorer.monitor.DeviceMonitorControllerImpl;
import com.android.tools.idea.device.explorer.monitor.DeviceMonitorModel;
import com.android.tools.idea.device.explorer.monitor.DeviceService;
import com.android.tools.idea.device.explorer.monitor.adbimpl.AdbDeviceService;
import com.android.tools.idea.device.explorer.monitor.processes.DeviceProcessService;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorView;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorViewImpl;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerView;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerViewImpl;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import icons.StudioIcons;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/game/DeviceFileExplorerServiceImpl;", "Lcom/android/tools/game/CommonService;", "<init>", "()V", "createWindow", "Lcom/android/tools/game/CommonWindowWrapper;", "windowId", "", "project", "Lcom/intellij/openapi/project/Project;", "initializeServices", "", "android.game-tools.main"})
public final class DeviceFileExplorerServiceImpl
implements CommonService {
    @Override
    @NotNull
    public CommonWindowWrapper createWindow(@NotNull String windowId, @NotNull Project project) {
        JFrame jFrame;
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.initializeServices(project);
        Ref.ObjectRef frame = new Ref.ObjectRef();
        ApplicationManager.getApplication().invokeAndWait(() -> DeviceFileExplorerServiceImpl.createWindow$lambda$0(project, frame));
        if (frame.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"frame");
            jFrame = null;
        } else {
            jFrame = (JFrame)frame.element;
        }
        return new CommonWindowWrapper(windowId, jFrame);
    }

    private final void initializeServices(Project project) {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        List list = AndroidSdks.getInstance().getAllAndroidSdks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllAndroidSdks(...)");
        List sdks = list;
        if (sdks.isEmpty()) {
            StatusRuntimeException statusRuntimeException = Status.INTERNAL.withDescription("Failed to find valid a valid Android SDK").asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"asRuntimeException(...)");
            throw (Throwable)statusRuntimeException;
        }
        WriteAction.runAndWait(() -> DeviceFileExplorerServiceImpl.initializeServices$lambda$0(projectRootManager, sdks));
        Future future = ApplicationManager.getApplication().executeOnPooledThread(DeviceFileExplorerServiceImpl::initializeServices$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
        Future result = future;
        result.get();
        File adbFile = AdbPath.INSTANCE.get();
        AdbService.getInstance().getDebugBridge(adbFile).get();
    }

    private static final void createWindow$lambda$0(Project $project, Ref.ObjectRef $frame) {
        JFrame jFrame;
        String toolWindowID = "Device Explorer";
        DeviceExplorerFileManager fileManager = (DeviceExplorerFileManager)$project.getService(DeviceExplorerFileManager.class);
        DeviceFileExplorerControllerImpl.FileOpener fileOpener2 = new DeviceFileExplorerControllerImpl.FileOpener(){

            @UiThread
            public Object openFile(Path localPath, Continuation<? super Unit> $completion) {
                RevealFileAction.openFile((File)localPath.toFile());
                return Unit.INSTANCE;
            }
        };
        DeviceFileExplorerModel filesModel = new DeviceFileExplorerModel();
        DeviceFileExplorerViewImpl filesView = new DeviceFileExplorerViewImpl($project, filesModel, toolWindowID);
        AdbDeviceService adbService = (AdbDeviceService)$project.getService(AdbDeviceService.class);
        DeviceProcessService processService = (DeviceProcessService)$project.getService(DeviceProcessService.class);
        Intrinsics.checkNotNull((Object)processService);
        DeviceMonitorModel monitorModel = new DeviceMonitorModel($project, processService);
        DeviceMonitorViewImpl monitorView = new DeviceMonitorViewImpl($project, monitorModel, null, 4, null);
        Object[] objectArray = new Object[2];
        DeviceFileExplorerView deviceFileExplorerView = (DeviceFileExplorerView)filesView;
        Intrinsics.checkNotNull((Object)fileManager);
        objectArray[0] = new DeviceFileExplorerControllerImpl($project, filesModel, deviceFileExplorerView, fileManager, fileOpener2);
        DeviceMonitorView deviceMonitorView = (DeviceMonitorView)monitorView;
        Intrinsics.checkNotNull((Object)adbService);
        objectArray[1] = new DeviceMonitorControllerImpl($project, monitorModel, deviceMonitorView, (DeviceService)adbService);
        List tabControllers = CollectionsKt.listOf((Object[])objectArray);
        DeviceExplorerModel model = new DeviceExplorerModel($project);
        DeviceExplorerViewImpl view = new DeviceExplorerViewImpl($project, model, toolWindowID);
        DeviceExplorerController controller = new DeviceExplorerController($project, model, (DeviceExplorerView)view, tabControllers);
        controller.setup();
        Icon icon = StudioIcons.Shell.ToolWindows.DEVICE_EXPLORER;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DEVICE_EXPLORER");
        $frame.element = new FakeToolWindow($project, "Android Device Explorer", icon, view.getComponent());
        if ($frame.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"frame");
            jFrame = null;
        } else {
            jFrame = (JFrame)$frame.element;
        }
        AndroidNotification.setFallbackNotificationDestination((Project)$project, (JFrame)jFrame);
    }

    private static final void initializeServices$lambda$0(ProjectRootManager $projectRootManager, List $sdks) {
        $projectRootManager.setProjectSdk((Sdk)$sdks.get(0));
    }

    private static final void initializeServices$lambda$1() {
        ActionManager.getInstance();
    }
}

