/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0002H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\u001f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0002H\u0002\u00a2\u0006\u0002\u0010\u0007\u001a9\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b*\b\u0012\u0004\u0012\u0002H\n0\t2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"findTopMostOverriddenDescriptors", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/List;", "findOriginalTopMostOverriddenDescriptors", "", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/Set;", "selectMostSpecificInEachOverridableGroup", "", "H", "", "descriptorByHandle", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "descriptors"})
@SourceDebugExtension(value={"SMAP\noverridingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 overridingUtils.kt\norg/jetbrains/kotlin/resolve/OverridingUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1634#2,3:85\n855#2,2:88\n*S KotlinDebug\n*F\n+ 1 overridingUtils.kt\norg/jetbrains/kotlin/resolve/OverridingUtilsKt\n*L\n40#1:85,3\n72#1:88,2\n*E\n"})
public final class OverridingUtilsKt {
    @NotNull
    public static final <D extends CallableDescriptor> List<D> findTopMostOverriddenDescriptors(@NotNull D $this$findTopMostOverriddenDescriptors) {
        Intrinsics.checkNotNullParameter($this$findTopMostOverriddenDescriptors, (String)"<this>");
        ArrayList arrayList = new ArrayList();
        Object object = DFS.dfs((Collection)CollectionsKt.listOf($this$findTopMostOverriddenDescriptors), OverridingUtilsKt::findTopMostOverriddenDescriptors$lambda$0, (DFS.NodeHandler)((DFS.NodeHandler)new DFS.CollectingNodeHandler<CallableDescriptor, CallableDescriptor, ArrayList<D>>(arrayList){

            public void afterChildren(CallableDescriptor current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                if (current.getOverriddenDescriptors().isEmpty()) {
                    ((ArrayList)this.result).add(current);
                }
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dfs(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <D extends CallableDescriptor> Set<D> findOriginalTopMostOverriddenDescriptors(@NotNull D $this$findOriginalTopMostOverriddenDescriptors) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter($this$findOriginalTopMostOverriddenDescriptors, (String)"<this>");
        Iterable iterable = OverridingUtilsKt.findTopMostOverriddenDescriptors($this$findOriginalTopMostOverriddenDescriptors);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            CallableDescriptor callableDescriptor = (CallableDescriptor)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            CallableDescriptor callableDescriptor2 = it.getOriginal();
            Intrinsics.checkNotNull((Object)callableDescriptor2, (String)"null cannot be cast to non-null type D of org.jetbrains.kotlin.resolve.OverridingUtilsKt.findOriginalTopMostOverriddenDescriptors");
            collection.add(callableDescriptor2);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <H> Collection<H> selectMostSpecificInEachOverridableGroup(@NotNull Collection<? extends H> $this$selectMostSpecificInEachOverridableGroup, @NotNull Function1<? super H, ? extends CallableDescriptor> descriptorByHandle) {
        Intrinsics.checkNotNullParameter($this$selectMostSpecificInEachOverridableGroup, (String)"<this>");
        Intrinsics.checkNotNullParameter(descriptorByHandle, (String)"descriptorByHandle");
        if ($this$selectMostSpecificInEachOverridableGroup.size() <= 1) {
            return $this$selectMostSpecificInEachOverridableGroup;
        }
        LinkedList<? extends H> queue = new LinkedList<H>($this$selectMostSpecificInEachOverridableGroup);
        SmartSet result = SmartSet.Companion.create();
        while (!((Collection)queue).isEmpty()) {
            void $this$filterNotTo$iv;
            Collection<H> overridableGroup;
            Object nextHandle = CollectionsKt.first((List)queue);
            SmartSet conflictedHandles = SmartSet.Companion.create();
            Intrinsics.checkNotNullExpressionValue(OverridingUtil.extractMembersOverridableInBothWays(nextHandle, (Collection)queue, descriptorByHandle, arg_0 -> OverridingUtilsKt.selectMostSpecificInEachOverridableGroup$lambda$2(conflictedHandles, arg_0)), (String)"extractMembersOverridableInBothWays(...)");
            if (overridableGroup.size() == 1 && conflictedHandles.isEmpty()) {
                Object object = CollectionsKt.single((Iterable)overridableGroup);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
                result.add(object);
                continue;
            }
            H mostSpecific = OverridingUtil.selectMostSpecificMember(overridableGroup, descriptorByHandle);
            CallableDescriptor mostSpecificDescriptor = (CallableDescriptor)descriptorByHandle.invoke(mostSpecific);
            Iterable iterable = overridableGroup;
            Collection destination$iv = (Collection)conflictedHandles;
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (OverridingUtil.isMoreSpecific(mostSpecificDescriptor, (CallableDescriptor)descriptorByHandle.invoke(it))) continue;
                destination$iv.add(element$iv);
            }
            if (!((Collection)conflictedHandles).isEmpty()) {
                result.addAll((Collection)conflictedHandles);
            }
            result.add(mostSpecific);
        }
        return (Collection)result;
    }

    private static final Iterable findTopMostOverriddenDescriptors$lambda$0(CallableDescriptor current) {
        return current.getOverriddenDescriptors();
    }

    private static final Unit selectMostSpecificInEachOverridableGroup$lambda$2(SmartSet $conflictedHandles, Object it) {
        Intrinsics.checkNotNull((Object)it);
        $conflictedHandles.add(it);
        return Unit.INSTANCE;
    }
}

