/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class EditClangTidyOptionsAction
extends DumbAwareAction {
    private final File mySourceFile;
    private final Project myProject;
    private final File myClangTidyFile;

    public EditClangTidyOptionsAction(@NotNull File sourceFile, @NotNull Project project, File clangTidyFile) {
        if (sourceFile == null) {
            EditClangTidyOptionsAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            EditClangTidyOptionsAction.$$$reportNull$$$0(1);
        }
        super(ClangdBundle.message("clang.tidy.view.file.options.action", sourceFile.getName()));
        this.mySourceFile = sourceFile;
        this.myProject = project;
        this.myClangTidyFile = clangTidyFile;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            EditClangTidyOptionsAction.$$$reportNull$$$0(2);
        }
        if (this.myClangTidyFile != null) {
            e.getPresentation().setText(ClangdBundle.message("clang.tidy.view.file.options.action", this.getFileName()));
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            EditClangTidyOptionsAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditClangTidyOptionsAction.$$$reportNull$$$0(4);
        }
        if (this.myClangTidyFile == null) {
            return;
        }
        VirtualFile file = VfsUtil.findFile((Path)Path.of(this.myClangTidyFile.getPath(), new String[0]), (boolean)true);
        if (file != null) {
            FileEditorManager.getInstance((Project)this.myProject).openFile(file, true);
        }
    }

    @NotNull
    private String getFileName() {
        String string = StringUtil.escapeMnemonics((String)this.mySourceFile.getName());
        if (string == null) {
            EditClangTidyOptionsAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/EditClangTidyOptionsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/EditClangTidyOptionsAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

