/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.CoroutineScopeKt;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyCheckOptionsProviderKt;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyCheckOptionsScopeHolder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\fH\u0007J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyCheckOptionsProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getAvailableOptions", "", "Lcom/jetbrains/cidr/lang/inspections/ClangTidyCheckOption;", "getAvailableOptionsAsync", "Ljava/util/concurrent/CompletableFuture;", "loadOptionsFromYaml", "outputText", "", "createOptionFromKeyValuePair", "key", "value", "getProcessOutput", "clangTidyPath", "Ljava/io/File;", "intellij.cidr.clangd"})
@SourceDebugExtension(value={"SMAP\nClangTidyCheckOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangTidyCheckOptionsProvider.kt\ncom/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyCheckOptionsProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n30#2,2:125\n1617#3,9:127\n1869#3:136\n1870#3:138\n1626#3:139\n1617#3,9:140\n1869#3:149\n1870#3:151\n1626#3:152\n1#4:137\n1#4:150\n*S KotlinDebug\n*F\n+ 1 ClangTidyCheckOptionsProvider.kt\ncom/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyCheckOptionsProvider\n*L\n51#1:125,2\n83#1:127,9\n83#1:136\n83#1:138\n83#1:139\n84#1:140,9\n84#1:149\n84#1:151\n84#1:152\n83#1:137\n84#1:150\n*E\n"})
public final class ClangTidyCheckOptionsProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable parentDisposable;

    public ClangTidyCheckOptionsProvider(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.parentDisposable = parentDisposable;
    }

    @TestOnly
    @NotNull
    public final List<ClangTidyCheckOption> getAvailableOptions() {
        try {
            CompletableFuture<List<ClangTidyCheckOption>> future = this.getAvailableOptionsAsync();
            List<ClangTidyCheckOption> list = future.get();
            Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
            return list;
        }
        catch (Exception e) {
            ClangTidyCheckOptionsProviderKt.access$getLOG$p().warn("Failed to get Clang-Tidy checks options", (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final CompletableFuture<List<ClangTidyCheckOption>> getAvailableOptionsAsync() {
        File file = CommonClangTidyUtil.getClangTidyPath();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getClangTidyPath(...)");
        File clangTidyPath = file;
        if (!clangTidyPath.exists()) {
            CompletableFuture<List<ClangTidyCheckOption>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ClangTidyCheckOptionsScopeHolder> serviceClass$iv = ClangTidyCheckOptionsScopeHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CoroutineScope scope = ((ClangTidyCheckOptionsScopeHolder)object).getCoroutineScope();
        Deferred deferred2 = BuildersKt.async$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ClangTidyCheckOption>>, Object>(this, clangTidyPath, null){
            int label;
            final /* synthetic */ ClangTidyCheckOptionsProvider this$0;
            final /* synthetic */ File $clangTidyPath;
            {
                this.this$0 = $receiver;
                this.$clangTidyPath = $clangTidyPath;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        List list;
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            String output = ClangTidyCheckOptionsProvider.access$getProcessOutput(this.this$0, this.$clangTidyPath);
                            list = ClangTidyCheckOptionsProvider.access$loadOptionsFromYaml(this.this$0, output);
                        }
                        catch (Exception e) {
                            ClangTidyCheckOptionsProviderKt.access$getLOG$p().warn("Failed to get Clang-Tidy options", (Throwable)e);
                            throw e;
                        }
                        return list;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends ClangTidyCheckOption>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        CoroutineScopeKt.cancelOnDispose((Job)((Job)deferred2), (Disposable)this.parentDisposable);
        return FutureKt.asCompletableFuture((Deferred)deferred2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClangTidyCheckOption> loadOptionsFromYaml(String outputText) {
        CharSequence charSequence = outputText;
        if (charSequence == null || charSequence.length() == 0) {
            return CollectionsKt.emptyList();
        }
        try {
            List list;
            Yaml yaml = new Yaml();
            Object object = yaml.load(outputText);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"load(...)");
            Map yamlData = (Map)object;
            if (!yamlData.containsKey("CheckOptions")) {
                ClangTidyCheckOptionsProviderKt.access$getLOG$p().warn("The output doesn't contain CheckOptions property");
                return CollectionsKt.emptyList();
            }
            Object checkOptions = yamlData.get("CheckOptions");
            Object v = checkOptions;
            if (v instanceof Map) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = ((Map)checkOptions).entrySet();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ClangTidyCheckOption it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl2 = false;
                    if (this.createOptionFromKeyValuePair(it.getKey(), it.getValue()) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else if (v instanceof List) {
                Iterable $this$mapNotNull$iv = (Iterable)checkOptions;
                boolean $i$f$mapNotNull = false;
                Iterable $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ClangTidyCheckOption it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Object it = element$iv$iv;
                    boolean bl4 = false;
                    if ((it instanceof Map ? this.createOptionFromKeyValuePair(((Map)it).get("key"), ((Map)it).get("value")) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                ClangTidyCheckOptionsProviderKt.access$getLOG$p().warn("Unknown type for CheckOptions property");
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        catch (Exception e) {
            ClangTidyCheckOptionsProviderKt.access$getLOG$p().warn("Can't deserialize Clang-Tidy checks options output", (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    private final ClangTidyCheckOption createOptionFromKeyValuePair(Object key, Object value) {
        if (!(key instanceof String) || !(value instanceof String)) {
            Object object;
            Class<?> keyClass;
            Class<?> clazz = key;
            if (clazz == null || (clazz = clazz.getClass()) == null || (clazz = clazz.getSimpleName()) == null) {
                clazz = keyClass = "<null>";
            }
            if ((object = value) == null || (object = object.getClass()) == null || (object = ((Class)object).getSimpleName()) == null) {
                object = "<null>";
            }
            Object valueClass = object;
            ClangTidyCheckOptionsProviderKt.access$getLOG$p().warn("Unknown type for check option property. Actual key type: " + (String)((Object)keyClass) + ", value type: " + (String)valueClass);
            return null;
        }
        return new ClangTidyCheckOption((String)((Object)key), (String)((Object)value));
    }

    private final String getProcessOutput(File clangTidyPath) throws ExecutionException {
        String string;
        boolean notEmptyStderr;
        String[] stringArray = new String[]{clangTidyPath.getPath(), "-checks=*", "--dump-config"};
        CapturingProcessHandler processHandler = new CapturingProcessHandler(new GeneralCommandLine(stringArray));
        ProcessOutput processOutput2 = processHandler.runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcess(...)");
        ProcessOutput output = processOutput2;
        String string2 = output.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
        boolean bl = notEmptyStderr = ((CharSequence)string2).length() > 0;
        if (output.getExitCode() != 0 || notEmptyStderr) {
            ClangTidyCheckOptionsProviderKt.access$getLOG$p().warn("Failed to get Clang-Tidy checks options: process exited with " + output.getExitCode() + " code" + (notEmptyStderr ? " with not empty stderr" : ""));
            string = null;
        } else {
            string = output.getStdout();
        }
        return string;
    }

    public static final /* synthetic */ String access$getProcessOutput(ClangTidyCheckOptionsProvider $this, File clangTidyPath) {
        return $this.getProcessOutput(clangTidyPath);
    }

    public static final /* synthetic */ List access$loadOptionsFromYaml(ClangTidyCheckOptionsProvider $this, String outputText) {
        return $this.loadOptionsFromYaml(outputText);
    }
}

