/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesStateUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ClangScanEvent;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanPathEvent
extends ClangScanEvent {
    private final VFileEvent myEvent;

    public ScanPathEvent(@NotNull VFileEvent event, @NotNull Project project) {
        if (event == null) {
            ScanPathEvent.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ScanPathEvent.$$$reportNull$$$0(1);
        }
        super(project);
        this.myEvent = event;
    }

    @Override
    public void doScan() {
        VirtualFile file = this.myEvent.getFile();
        if (file == null) {
            return;
        }
        boolean hasChangesInCppModulesState = false;
        Pair changedFolder = null;
        if (this.myEvent instanceof VFileDeleteEvent) {
            if (file.isDirectory()) {
                changedFolder = new Pair((Object)file.getUrl(), (Object)"");
            }
            hasChangesInCppModulesState = this.processFileOrDirectoryRemove(file.getPath(), file.isDirectory());
        } else if (this.myEvent instanceof VFileMoveEvent) {
            String oldPath = ((VFileMoveEvent)this.myEvent).getOldPath();
            hasChangesInCppModulesState = this.processFileOrDirectoryMove(oldPath, file);
        } else {
            VFileEvent oldPath = this.myEvent;
            if (oldPath instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)oldPath;
                if (propertyChangeEvent.isRename() && propertyChangeEvent.getFile().isDirectory()) {
                    oldUrl = VirtualFileManager.constructUrl((String)file.getFileSystem().getProtocol(), (String)propertyChangeEvent.getOldPath());
                    changedFolder = new Pair(oldUrl, (Object)file.getUrl());
                }
                if (!propertyChangeEvent.getOldPath().equals(file.getPath()) && propertyChangeEvent.getPropertyName().equals("name")) {
                    hasChangesInCppModulesState = this.processFileOrDirectoryMove(propertyChangeEvent.getOldPath(), file);
                }
            } else if (this.myEvent instanceof VFileCreateEvent) {
                if (file.isDirectory()) {
                    changedFolder = new Pair((Object)"", (Object)file.getUrl());
                }
                hasChangesInCppModulesState = this.processFileOrDirectoryAdd(file);
            } else {
                oldUrl = this.myEvent;
                if (oldUrl instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)oldUrl;
                    VirtualFile createdFile = copyEvent.findCreatedFile();
                    if (createdFile == null) {
                        return;
                    }
                    hasChangesInCppModulesState = this.processFileOrDirectoryAdd(createdFile);
                }
            }
        }
        if (hasChangesInCppModulesState) {
            CppModulesStateUtil.updateModuleMap(this.myModulesState, this.myProject);
        }
        if (changedFolder != null && Registry.is((String)"clion.search.header.paths")) {
            this.updateFolder((Pair<String, String>)changedFolder);
        }
    }

    private void updateFolder(@NotNull Pair<String, String> folder) {
        if (folder == null) {
            ScanPathEvent.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        @Nullable ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(this.myProject);
        if (provider2 == null) {
            return;
        }
        @Nullable ClangLanguageService service = provider2.getIfStarted();
        if (service == null) {
            return;
        }
        service.notifyFolderChanged((String)folder.first, (String)folder.second);
    }

    private boolean processFileOrDirectoryRemove(@NotNull String oldPath, boolean isDirectory) {
        if (oldPath == null) {
            ScanPathEvent.$$$reportNull$$$0(3);
        }
        this.tryDeleteClangTidyFiles(oldPath, isDirectory);
        return this.tryDeleteCppModules(oldPath, isDirectory);
    }

    private boolean processFileOrDirectoryAdd(@NotNull VirtualFile file) {
        if (file == null) {
            ScanPathEvent.$$$reportNull$$$0(4);
        }
        if (!file.isValid()) {
            return false;
        }
        if (!file.isDirectory()) {
            this.tryAddClangTidyFile(file);
            return this.tryAddCppModule(file);
        }
        final Ref hasChangesRef = Ref.create((Object)false);
        Boolean isInProject = (Boolean)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)this.myProject).isInProject(file));
        if (!isInProject.booleanValue()) {
            return false;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                ScanPathEvent.this.tryAddClangTidyFile(file);
                hasChangesRef.set((Object)((Boolean)hasChangesRef.get() | ScanPathEvent.this.tryAddCppModule(file)));
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(1);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/scan/events/ScanPathEvent$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/scan/events/ScanPathEvent$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        return (Boolean)hasChangesRef.get();
    }

    private boolean processFileOrDirectoryMove(@NotNull String oldPath, @NotNull VirtualFile file) {
        if (oldPath == null) {
            ScanPathEvent.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ScanPathEvent.$$$reportNull$$$0(6);
        }
        this.processFileOrDirectoryRemove(oldPath, file.isDirectory());
        return this.processFileOrDirectoryAdd(file);
    }

    private boolean tryDeleteCppModules(@NotNull String oldPath, boolean isDirectory) {
        if (oldPath == null) {
            ScanPathEvent.$$$reportNull$$$0(7);
        }
        if (!CppModulesStateUtil.areCpp20ModulesEnabled()) {
            return false;
        }
        if (this.myModulesState.hasCppModule(oldPath)) {
            this.myModulesState.removeCppModuleByPath(oldPath);
            return true;
        }
        if (isDirectory && this.myModulesState.dirContainsCppModule(oldPath)) {
            this.myModulesState.removeCppModulesInDir(oldPath);
            return true;
        }
        return false;
    }

    private void tryDeleteClangTidyFiles(@NotNull String oldPath, boolean isDirectory) {
        if (oldPath == null) {
            ScanPathEvent.$$$reportNull$$$0(8);
        }
        File file = new File(oldPath);
        if (!isDirectory && CommonClangTidyUtil.isClangTidyFile(file)) {
            this.myClangTidyFilesState.removeClangTidyFile(file);
            return;
        }
        for (File clangTidyFile : this.myClangTidyFilesState.getClangTidyFiles()) {
            if (!FileUtil.isAncestor((File)file, (File)clangTidyFile, (boolean)true)) continue;
            this.myClangTidyFilesState.removeClangTidyFile(clangTidyFile);
        }
    }

    private boolean tryAddCppModule(@NotNull VirtualFile file) {
        if (file == null) {
            ScanPathEvent.$$$reportNull$$$0(9);
        }
        if (!CppModulesStateUtil.areCpp20ModulesEnabled()) {
            return false;
        }
        if (!CppModulesStateUtil.isCpp20ModuleFile(file.getPath()) || this.myModulesState.hasCppModule(file.getPath())) {
            return false;
        }
        CppModulesStateUtil.tryAddModuleWithoutCompileCommand(this.myModulesState, file);
        return true;
    }

    private void tryAddClangTidyFile(@NotNull VirtualFile file) {
        if (file == null) {
            ScanPathEvent.$$$reportNull$$$0(10);
        }
        if (CommonClangTidyUtil.isClangTidyFile(file)) {
            this.myClangTidyFilesState.addClangTidyFile(new File(file.getPath()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/scan/events/ScanPathEvent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processFileOrDirectoryRemove";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processFileOrDirectoryAdd";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processFileOrDirectoryMove";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tryDeleteCppModules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "tryDeleteClangTidyFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "tryAddCppModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "tryAddClangTidyFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

