/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesStateUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangScanLog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangTraverseUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ClangScanEvent;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class ScanFileSystemEvent
extends ClangScanEvent {
    public ScanFileSystemEvent(@NotNull Project project) {
        if (project == null) {
            ScanFileSystemEvent.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    public void doScan() {
        String basePath = this.myProject.getBasePath();
        if (StringUtil.isEmpty((String)basePath)) {
            return;
        }
        this.myClangTidyFilesState.clearClangTidyFiles();
        this.traverseFiles(new File(basePath));
        if (CppModulesStateUtil.areCpp20ModulesEnabled()) {
            CppModulesStateUtil.updateModuleMap(this.myModulesState, this.myProject);
        }
        CommonClangTidyUtil.dumpClangTidyFiles(this.myClangTidyFilesState, ClangScanLog.LOG);
    }

    private void traverseFiles(@NotNull File baseDir) {
        if (baseDir == null) {
            ScanFileSystemEvent.$$$reportNull$$$0(1);
        }
        Processor processor = file -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            this.processPossibleModuleFile((File)file);
            this.processPossibleClangTidyFile((File)file);
            return true;
        };
        ClangTraverseUtil.traverseFiles(baseDir, true, true, (Processor<? super File>)processor);
    }

    private void processPossibleModuleFile(@NotNull File file) {
        if (file == null) {
            ScanFileSystemEvent.$$$reportNull$$$0(2);
        }
        if (CppModulesStateUtil.areCpp20ModulesEnabled() && CppModulesStateUtil.isCpp20ModuleFile(file.getName()) && !this.myModulesState.hasCppModule(file.getPath())) {
            CppModulesStateUtil.tryAddModuleWithoutCompileCommand(this.myModulesState, file);
        }
    }

    private void processPossibleClangTidyFile(@NotNull File file) {
        if (file == null) {
            ScanFileSystemEvent.$$$reportNull$$$0(3);
        }
        if (CommonClangTidyUtil.isClangTidyFile(file)) {
            this.myClangTidyFilesState.addClangTidyFile(file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/scan/events/ScanFileSystemEvent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processPossibleModuleFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processPossibleClangTidyFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

