/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.util.Processor;
import java.io.File;
import java.nio.file.Files;
import org.jetbrains.annotations.NotNull;

public final class ClangTraverseUtil {
    private ClangTraverseUtil() {
    }

    public static void traverseFiles(@NotNull File baseDirectory, boolean traverseChildDirectories, boolean traverseParentDirectories, @NotNull Processor<? super File> processor) {
        if (baseDirectory == null) {
            ClangTraverseUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            ClangTraverseUtil.$$$reportNull$$$0(1);
        }
        File currentDirectory = baseDirectory;
        if (traverseChildDirectories) {
            ClangTraverseUtil.visitFilesIgnoringSymlinks(currentDirectory, true, processor);
            currentDirectory = currentDirectory.getParentFile();
        }
        if (traverseParentDirectories) {
            while (currentDirectory != null && ClangTraverseUtil.visitFilesIgnoringSymlinks(currentDirectory, false, processor)) {
                currentDirectory = currentDirectory.getParentFile();
            }
        }
    }

    public static boolean visitFilesIgnoringSymlinks(@NotNull File root, boolean recursive, @NotNull Processor<? super File> processor) {
        if (root == null) {
            ClangTraverseUtil.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            ClangTraverseUtil.$$$reportNull$$$0(3);
        }
        if (!processor.process((Object)root)) {
            return false;
        }
        File[] children = root.listFiles();
        if (children != null) {
            for (File child : children) {
                if (!(child.isFile() ? !processor.process((Object)child) : child.isDirectory() && recursive && !Files.isSymbolicLink(child.toPath()) && !ClangTraverseUtil.visitFilesIgnoringSymlinks(child, true, processor))) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTraverseUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFilesIgnoringSymlinks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

