/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangTidyFilesStateImpl
implements ClangTidyFilesState {
    private final Map<Integer, File> clangTidyFilesMap = new HashMap<Integer, File>();

    @Override
    @NotNull
    public synchronized List<File> getClangTidyFiles() {
        List<File> list = List.copyOf(this.clangTidyFilesMap.values());
        if (list == null) {
            ClangTidyFilesStateImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @Nullable
    public synchronized File findNearestClangTidyFile(@NotNull File file) {
        File directory;
        if (file == null) {
            ClangTidyFilesStateImpl.$$$reportNull$$$0(1);
        }
        File file2 = directory = file.isDirectory() ? file : file.getParentFile();
        while (directory != null) {
            File clangTidyFile = this.clangTidyFilesMap.get(ClangTidyFilesStateImpl.getHashCode(directory));
            if (clangTidyFile != null) {
                return clangTidyFile;
            }
            directory = directory.getParentFile();
        }
        return null;
    }

    @Override
    public synchronized void setClangTidyFiles(@NotNull List<File> clangTidyFiles) {
        if (clangTidyFiles == null) {
            ClangTidyFilesStateImpl.$$$reportNull$$$0(2);
        }
        this.clearClangTidyFiles();
        for (File clangTidyFile : clangTidyFiles) {
            this.processClangTidyFile(clangTidyFile);
        }
    }

    @Override
    public synchronized void clearClangTidyFiles() {
        this.clangTidyFilesMap.clear();
    }

    @Override
    public synchronized void addClangTidyFile(@NotNull File clangTidyFile) {
        if (clangTidyFile == null) {
            ClangTidyFilesStateImpl.$$$reportNull$$$0(3);
        }
        this.processClangTidyFile(clangTidyFile);
    }

    @Override
    public synchronized void removeClangTidyFile(@NotNull File clangTidyFile) {
        File parentDirectory;
        if (clangTidyFile == null) {
            ClangTidyFilesStateImpl.$$$reportNull$$$0(4);
        }
        if ((parentDirectory = clangTidyFile.getParentFile()) != null) {
            this.clangTidyFilesMap.remove(ClangTidyFilesStateImpl.getHashCode(parentDirectory));
        }
    }

    @Override
    public synchronized boolean hasClangTidyFilesInPath(@NotNull File file) {
        if (file == null) {
            ClangTidyFilesStateImpl.$$$reportNull$$$0(5);
        }
        return this.findNearestClangTidyFile(file) != null;
    }

    private void processClangTidyFile(@NotNull File clangTidyFile) {
        File parentDirectory;
        if (clangTidyFile == null) {
            ClangTidyFilesStateImpl.$$$reportNull$$$0(6);
        }
        if ((parentDirectory = clangTidyFile.getParentFile()) != null) {
            this.clangTidyFilesMap.put(ClangTidyFilesStateImpl.getHashCode(parentDirectory), clangTidyFile);
        }
    }

    private static int getHashCode(@NotNull File file) {
        if (file == null) {
            ClangTidyFilesStateImpl.$$$reportNull$$$0(7);
        }
        return FileUtil.fileHashCode((File)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangTidyFilesStateImpl";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyFiles";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangTidyFilesStateImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findNearestClangTidyFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setClangTidyFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addClangTidyFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeClangTidyFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasClangTidyFilesInPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processClangTidyFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHashCode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

