/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.AbstractTelemetryEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.NewModuleCompiledEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ParseFinishedEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ParseStartedEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class ClangGeneralTelemetry {
    @NotNull
    private final ClangUrlConverter myConverter;
    private final Map<String, ParseStats> myParsedFiles;
    private final Map<String, Integer> myCompiledModules;
    private final AtomicInteger myParseStartedCounter;
    private final AtomicInteger myParseFinishedCounter;

    public ClangGeneralTelemetry(@NotNull ClangUrlConverter converter) {
        if (converter == null) {
            ClangGeneralTelemetry.$$$reportNull$$$0(0);
        }
        this.myParsedFiles = new HashMap<String, ParseStats>();
        this.myCompiledModules = new HashMap<String, Integer>();
        this.myParseStartedCounter = new AtomicInteger();
        this.myParseFinishedCounter = new AtomicInteger();
        this.myConverter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handle(Object rawEvent) {
        String eventName = AbstractTelemetryEvent.getEventName(rawEvent);
        if (eventName == null) {
            return false;
        }
        switch (eventName) {
            case "ParseStarted": {
                this.myParseStartedCounter.incrementAndGet();
                ParseStartedEvent parseStartedEvent = ParseStartedEvent.tryInstantiate(rawEvent);
                assert (parseStartedEvent != null);
                Map<String, ParseStats> map = this.myParsedFiles;
                synchronized (map) {
                    ParseStats stats = this.getStatsNoSync(parseStartedEvent.targetFile);
                    ++stats.parseStartedCounter;
                }
                return true;
            }
            case "ParseFinished": {
                this.myParseFinishedCounter.incrementAndGet();
                ParseFinishedEvent parseFinishedEvent = ParseFinishedEvent.tryInstantiate(rawEvent);
                assert (parseFinishedEvent != null);
                Map<String, ParseStats> map = this.myParsedFiles;
                synchronized (map) {
                    ParseStats stats = this.getStatsNoSync(parseFinishedEvent.targetFile);
                    ++stats.parseFinishedCounter;
                }
                return true;
            }
            case "NewModuleCompiled": {
                NewModuleCompiledEvent newModuleCompiledEvent = NewModuleCompiledEvent.tryInstantiate(rawEvent);
                assert (newModuleCompiledEvent != null);
                Map<String, Integer> map = this.myCompiledModules;
                synchronized (map) {
                    this.myCompiledModules.compute(newModuleCompiledEvent.moduleName, (k, v) -> v == null ? 1 : v + 1);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReparseSent(@NotNull ClangReparseNotification notification) {
        if (notification == null) {
            ClangGeneralTelemetry.$$$reportNull$$$0(1);
        }
        Map<String, ParseStats> map = this.myParsedFiles;
        synchronized (map) {
            ParseStats stats = this.getStatsNoSync(this.myConverter.fromUrl(notification.getUrl()));
            ++stats.parseRequestSentCounter;
        }
    }

    public int getParseStartedCounter() {
        return this.myParseStartedCounter.get();
    }

    public int getParseFinishedCounter() {
        return this.myParseFinishedCounter.get();
    }

    public int getNumberOfParsedFiles() {
        return this.myParsedFiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachParsedFile(@NotNull BiConsumer<String, ParseStats> consumer) {
        if (consumer == null) {
            ClangGeneralTelemetry.$$$reportNull$$$0(2);
        }
        Map<String, ParseStats> map = this.myParsedFiles;
        synchronized (map) {
            this.myParsedFiles.forEach(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachCompiledModule(@NotNull BiConsumer<String, Integer> consumer) {
        if (consumer == null) {
            ClangGeneralTelemetry.$$$reportNull$$$0(3);
        }
        Map<String, Integer> map = this.myCompiledModules;
        synchronized (map) {
            this.myCompiledModules.forEach(consumer);
        }
    }

    @NotNull
    private ParseStats getStatsNoSync(@NotNull String targetFile) {
        if (targetFile == null) {
            ClangGeneralTelemetry.$$$reportNull$$$0(4);
        }
        ParseStats parseStats = this.myParsedFiles.computeIfAbsent(targetFile, k -> new ParseStats());
        if (parseStats == null) {
            ClangGeneralTelemetry.$$$reportNull$$$0(5);
        }
        return parseStats;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/telemetry/ClangGeneralTelemetry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/telemetry/ClangGeneralTelemetry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatsNoSync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "notifyReparseSent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forEachParsedFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forEachCompiledModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStatsNoSync";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static final class ParseStats {
        public int parseRequestSentCounter;
        public int parseStartedCounter;
        public int parseFinishedCounter;
    }
}

