/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DFARawTuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangCustomRequestsManager;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerCustomTasks;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerCustomTasksImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerCustomTasksKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.CustomRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionRequestParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionRunBuildDfaParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionRunClangTidyParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionRunClazyParams;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\u0014\u001a\u001c\u0012\u0004\u0012\u00020\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00180\u00170\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dJL\u0010\u001e\u001a\"\u0012\u0004\u0012\u00020\u0016\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001d\u0018\u00010\u001f0\u00170\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dJ<\u0010&\u001a\"\u0012\u0004\u0012\u00020\u0016\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u001d\u0018\u00010\u001f0\u00170\u00152\u0006\u0010!\u001a\u00020(2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dJ\u0006\u0010)\u001a\u00020*JH\u0010+\u001a,\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\n0\u001d0,2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J^\u0010-\u001a2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\r\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001d0\u001f0\n0\u001d0,2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u0010.\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002JN\u0010/\u001a2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\r\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u001d0\u001f0\n0\u001d0,2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u00100\u001a\u00020(H\u0002J4\u00101\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H20\n\u0012\u0004\u0012\u0002030,0\u001d\"\u0004\b\u0000\u001022\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dH\u0002J\b\u00104\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R.\u0010\b\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n0\tj\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\tj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0010\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\r0\tj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\r`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0012\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\r0\tj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\r`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerCustomTasksBuilder;", "", "indexer", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;)V", "getIndexer", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "allRequests", "Ljava/util/ArrayList;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/CustomRequest;", "Lkotlin/collections/ArrayList;", "allDfaParams", "Ljava/util/function/Function;", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionRunBuildDfaParams;", "allClangTidyParams", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionRunClangTidyParams;", "allClazyParams", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionRunClazyParams;", "addDfaInput", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/util/concurrent/CompletableFuture;", "Ljava/util/stream/Stream;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/annotator/DFARawTuple;", "dfaConfigParams", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangDFAConfigParams;", "files", "", "addClangTidy", "Ljava/util/function/Supplier;", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyDiagnostic;", "config", "", "disableCLionChecks", "", "preferClangTidyFiles", "addClazy", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangDiagnostic;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/CLionClazyConfigParams;", "create", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerCustomTasks;", "createDfaInputParams", "Lcom/intellij/openapi/util/Pair;", "createClangTidyParams", "clangTidyConfig", "createClazyParams", "clazyConfig", "createRequests", "T", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionRequestParams;", "toString", "intellij.cidr.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdIndexerCustomTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdIndexerCustomTasks.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerCustomTasksBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1869#2,2:245\n1869#2,2:247\n1869#2,2:249\n1563#2:251\n1634#2,3:252\n1563#2:255\n1634#2,3:256\n1563#2:259\n1634#2,3:260\n1563#2:263\n1634#2,3:264\n1563#2:267\n1634#2,3:268\n1563#2:271\n1634#2,3:272\n1563#2:275\n1634#2,3:276\n*S KotlinDebug\n*F\n+ 1 ClangdIndexerCustomTasks.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerCustomTasksBuilder\n*L\n46#1:245,2\n58#1:247,2\n70#1:249,2\n93#1:251\n93#1:252,3\n105#1:255\n105#1:256,3\n116#1:259\n116#1:260,3\n126#1:263\n126#1:264,3\n92#1:267\n92#1:268,3\n104#1:271\n104#1:272,3\n115#1:275\n115#1:276,3\n*E\n"})
public final class ClangdIndexerCustomTasksBuilder {
    @NotNull
    private final ClangdIndexerService indexer;
    @NotNull
    private final ArrayList<CustomRequest<? extends Object>> allRequests;
    @NotNull
    private final ArrayList<Function<Integer, ClionRunBuildDfaParams>> allDfaParams;
    @NotNull
    private final ArrayList<Function<Integer, ClionRunClangTidyParams>> allClangTidyParams;
    @NotNull
    private final ArrayList<Function<Integer, ClionRunClazyParams>> allClazyParams;

    public ClangdIndexerCustomTasksBuilder(@NotNull ClangdIndexerService indexer) {
        Intrinsics.checkNotNullParameter((Object)indexer, (String)"indexer");
        this.indexer = indexer;
        this.allRequests = new ArrayList();
        this.allDfaParams = new ArrayList();
        this.allClangTidyParams = new ArrayList();
        this.allClazyParams = new ArrayList();
    }

    @NotNull
    public final ClangdIndexerService getIndexer() {
        return this.indexer;
    }

    @NotNull
    public final Map<VirtualFile, CompletableFuture<Stream<DFARawTuple>>> addDfaInput(@NotNull ClionClangDFAConfigParams dfaConfigParams, @NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter((Object)dfaConfigParams, (String)"dfaConfigParams");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Pair<Function<Integer, ClionRunBuildDfaParams>, List<CustomRequest<Stream<DFARawTuple>>>> paramsAndRequests = this.createDfaInputParams(files, dfaConfigParams);
        this.allDfaParams.add((Function<Integer, ClionRunBuildDfaParams>)paramsAndRequests.first);
        this.allRequests.addAll((Collection)paramsAndRequests.second);
        Map result = new LinkedHashMap();
        Iterable iterable = ContainerUtil.zip((Iterable)files, (Iterable)((Iterable)paramsAndRequests.second));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"zip(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            result.put(it.first, ((CustomRequest)it.second).getResult());
        }
        return result;
    }

    @NotNull
    public final Map<VirtualFile, CompletableFuture<Supplier<List<ClangTidyDiagnostic>>>> addClangTidy(@NotNull String config, boolean disableCLionChecks, boolean preferClangTidyFiles, @NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Pair<Function<Integer, ClionRunClangTidyParams>, List<CustomRequest<Supplier<List<ClangTidyDiagnostic>>>>> paramsAndRequests = this.createClangTidyParams(files, config, disableCLionChecks, preferClangTidyFiles);
        this.allClangTidyParams.add((Function<Integer, ClionRunClangTidyParams>)paramsAndRequests.first);
        this.allRequests.addAll((Collection)paramsAndRequests.second);
        Map result = new LinkedHashMap();
        Iterable iterable = ContainerUtil.zip((Iterable)files, (Iterable)((Iterable)paramsAndRequests.second));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"zip(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            result.put(it.first, ((CustomRequest)it.second).getResult());
        }
        return result;
    }

    @NotNull
    public final Map<VirtualFile, CompletableFuture<Supplier<List<ClangDiagnostic>>>> addClazy(@NotNull CLionClazyConfigParams config, @NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Pair<Function<Integer, ClionRunClazyParams>, List<CustomRequest<Supplier<List<ClangDiagnostic>>>>> paramsAndRequests = this.createClazyParams(files, config);
        this.allClazyParams.add((Function<Integer, ClionRunClazyParams>)paramsAndRequests.first);
        this.allRequests.addAll((Collection)paramsAndRequests.second);
        Map result = new LinkedHashMap();
        Iterable iterable = ContainerUtil.zip((Iterable)files, (Iterable)((Iterable)paramsAndRequests.second));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"zip(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            result.put(it.first, ((CustomRequest)it.second).getResult());
        }
        return result;
    }

    @NotNull
    public final ClangdIndexerCustomTasks create() {
        return new ClangdIndexerCustomTasksImpl(this.indexer, (List<? extends CustomRequest<? extends Object>>)this.allRequests, ClangdIndexerCustomTasksKt.access$optimizeDfa(this.allDfaParams), ClangdIndexerCustomTasksKt.access$optimizeClangTidy(this.allClangTidyParams), ClangdIndexerCustomTasksKt.access$optimizeClazy(this.allClazyParams));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Function<Integer, ClionRunBuildDfaParams>, List<CustomRequest<Stream<DFARawTuple>>>> createDfaInputParams(List<? extends VirtualFile> files, ClionClangDFAConfigParams dfaConfigParams) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ThreadingAssertions.assertReadAccess();
        List requests = this.createRequests(files);
        Iterable iterable = requests;
        Function<Integer, ClionRunBuildDfaParams> function = arg_0 -> ClangdIndexerCustomTasksBuilder.createDfaInputParams$lambda$4(requests, dfaConfigParams, arg_0);
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CustomRequest)it.first);
        }
        Pair pair = Pair.create(function, (Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Function<Integer, ClionRunClangTidyParams>, List<CustomRequest<Supplier<List<ClangTidyDiagnostic>>>>> createClangTidyParams(List<? extends VirtualFile> files, String clangTidyConfig, boolean disableCLionChecks, boolean preferClangTidyFiles) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ThreadingAssertions.assertReadAccess();
        List requests = this.createRequests(files);
        Iterable iterable = requests;
        Function<Integer, ClionRunClangTidyParams> function = arg_0 -> ClangdIndexerCustomTasksBuilder.createClangTidyParams$lambda$7(requests, clangTidyConfig, disableCLionChecks, preferClangTidyFiles, arg_0);
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CustomRequest)it.first);
        }
        Pair pair = Pair.create(function, (Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Function<Integer, ClionRunClazyParams>, List<CustomRequest<Supplier<List<ClangDiagnostic>>>>> createClazyParams(List<? extends VirtualFile> files, CLionClazyConfigParams clazyConfig) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ThreadingAssertions.assertReadAccess();
        List requests = this.createRequests(files);
        Iterable iterable = requests;
        Function<Integer, ClionRunClazyParams> function = arg_0 -> ClangdIndexerCustomTasksBuilder.createClazyParams$lambda$10(requests, clazyConfig, arg_0);
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CustomRequest)it.first);
        }
        Pair pair = Pair.create(function, (Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<Pair<CustomRequest<T>, ClionRequestParams>> createRequests(List<? extends VirtualFile> files) {
        void $this$mapTo$iv$iv;
        ThreadingAssertions.assertReadAccess();
        Project project = this.indexer.getContext().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ClangIdeFacade clangIdeFacade = this.indexer.getContext().getIdeFacade();
        Intrinsics.checkNotNullExpressionValue((Object)clangIdeFacade, (String)"getIdeFacade(...)");
        ClangIdeFacade ideFacade = clangIdeFacade;
        ClangUrlConverter clangUrlConverter = this.indexer.getUrlConverter();
        Intrinsics.checkNotNullExpressionValue((Object)clangUrlConverter, (String)"getUrlConverter(...)");
        ClangUrlConverter converter = clangUrlConverter;
        ClangCustomRequestsManager clangCustomRequestsManager = this.indexer.getContext().getCustomRequests();
        Intrinsics.checkNotNullExpressionValue((Object)clangCustomRequestsManager, (String)"getCustomRequests(...)");
        ClangCustomRequestsManager customRequests = clangCustomRequestsManager;
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String targetUri;
            void f;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CustomRequest req = customRequests.newRequest();
            Intrinsics.checkNotNullExpressionValue((Object)converter.toUri((VirtualFile)f), (String)"toUri(...)");
            String entryUri = targetUri;
            if (!ClangdBridge.isSourceFile(project2, (VirtualFile)f)) {
                ClangdCompilationCommand command = null;
                try {
                    CompletableFuture<ClangdCompilationCommand> completableFuture = ideFacade.getCompilationCommandAsync(converter, project2, (VirtualFile)f, "", Cpp20ModulesContext.DISABLED);
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getCompilationCommandAsync(...)");
                    command = (ClangdCompilationCommand)CidrConcurrentUtilsKt.waitCancelAware((Future)completableFuture, (String)"compilation command");
                }
                catch (ExecutionException ex) {
                    ClangUtils.LOG.error((Throwable)ex);
                    command = null;
                }
                if (command != null) {
                    String string = command.ccParams.getEntryUri();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEntryUri(...)");
                    entryUri = string;
                }
            }
            collection.add(Pair.create(req, (Object)new ClionRequestParams(req.getId(), targetUri, entryUri)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return this.create().toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final ClionRunBuildDfaParams createDfaInputParams$lambda$4(List $requests, ClionClangDFAConfigParams $dfaConfigParams, Integer id) {
        Collection<ClionRequestParams> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNull((Object)id);
        Iterable iterable = $requests;
        int n = id;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ClionRequestParams)it.second);
        }
        collection = (List)destination$iv$iv;
        ClionClangDFAConfigParams clionClangDFAConfigParams = $dfaConfigParams;
        List list = collection;
        int n2 = n;
        return new ClionRunBuildDfaParams(n2, list, clionClangDFAConfigParams);
    }

    /*
     * WARNING - void declaration
     */
    private static final ClionRunClangTidyParams createClangTidyParams$lambda$7(List $requests, String $clangTidyConfig, boolean $disableCLionChecks, boolean $preferClangTidyFiles, Integer id) {
        Collection<ClionRequestParams> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNull((Object)id);
        Iterable iterable = $requests;
        int n = id;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ClionRequestParams)it.second);
        }
        collection = (List)destination$iv$iv;
        boolean bl = $preferClangTidyFiles;
        boolean bl2 = $disableCLionChecks;
        String string = $clangTidyConfig;
        List list = collection;
        int n2 = n;
        return new ClionRunClangTidyParams(n2, list, string, bl2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final ClionRunClazyParams createClazyParams$lambda$10(List $requests, CLionClazyConfigParams $clazyConfig, Integer id) {
        Collection<ClionRequestParams> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNull((Object)id);
        Iterable iterable = $requests;
        int n = id;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ClionRequestParams)it.second);
        }
        collection = (List)destination$iv$iv;
        CLionClazyConfigParams cLionClazyConfigParams = $clazyConfig;
        List list = collection;
        int n2 = n;
        return new ClionRunClazyParams(n2, list, cLionClazyConfigParams);
    }
}

