/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixItHint;
import java.util.List;
import java.util.Objects;
import org.eclipse.lsp4j.CodeAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangDiagnostic {
    @Nullable
    private final String myCode;
    @Nullable
    private final String mySource;
    @NotNull
    private final String myMessage;
    @Nullable
    private final List<String> myNotes;
    @NotNull
    private final List<? extends CodeAction> myClangdFixits;
    @NotNull
    private final List<? extends ClionFixItHint> myClionFixits;
    @NotNull
    private final HighlightSeverity mySeverity;
    private final int myStartLine;
    private final int myStartColumn;
    private final int myEndLine;
    private final int myEndColumn;

    public ClangDiagnostic(@Nullable String code, @Nullable String source, @NotNull String message, @Nullable List<String> notes, @NotNull List<? extends CodeAction> clangdFixits, @NotNull List<? extends ClionFixItHint> clionFixits, @NotNull HighlightSeverity severity, int startLine, int startColumn, int endLine, int endColumn) {
        if (message == null) {
            ClangDiagnostic.$$$reportNull$$$0(0);
        }
        if (clangdFixits == null) {
            ClangDiagnostic.$$$reportNull$$$0(1);
        }
        if (clionFixits == null) {
            ClangDiagnostic.$$$reportNull$$$0(2);
        }
        if (severity == null) {
            ClangDiagnostic.$$$reportNull$$$0(3);
        }
        this.myCode = code;
        this.mySource = source;
        this.myMessage = message;
        this.myNotes = notes;
        this.myClangdFixits = clangdFixits;
        this.myClionFixits = clionFixits;
        this.mySeverity = severity;
        this.myStartLine = startLine;
        this.myStartColumn = startColumn;
        this.myEndLine = endLine;
        this.myEndColumn = endColumn;
    }

    @Nullable
    public String getCode() {
        return this.myCode;
    }

    @Nullable
    public String getSource() {
        return this.mySource;
    }

    @NotNull
    @NlsSafe
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            ClangDiagnostic.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public List<String> getNotes() {
        return this.myNotes;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            ClangDiagnostic.$$$reportNull$$$0(5);
        }
        return highlightSeverity;
    }

    @NotNull
    public List<? extends ClionFixItHint> getClionFixits() {
        List<? extends ClionFixItHint> list = this.myClionFixits;
        if (list == null) {
            ClangDiagnostic.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<? extends CodeAction> getClangdFixits() {
        List<? extends CodeAction> list = this.myClangdFixits;
        if (list == null) {
            ClangDiagnostic.$$$reportNull$$$0(7);
        }
        return list;
    }

    public int getStartLine() {
        return this.myStartLine;
    }

    public int getStartColumn() {
        return this.myStartColumn;
    }

    public int getEndLine() {
        return this.myEndLine;
    }

    public int getEndColumn() {
        return this.myEndColumn;
    }

    public String toString() {
        return "ClangDiagnostic{myCode='" + this.myCode + "', mySource='" + this.mySource + "', myMessage='" + this.myMessage + "', myStartLine=" + this.myStartLine + ", myStartColumn=" + this.myStartColumn + ", myEndLine=" + this.myEndLine + ", myEndColumn=" + this.myEndColumn + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClangDiagnostic that = (ClangDiagnostic)o;
        return this.myStartLine == that.myStartLine && this.myStartColumn == that.myStartColumn && this.myEndLine == that.myEndLine && this.myEndColumn == that.myEndColumn && Objects.equals(this.myCode, that.myCode) && Objects.equals(this.mySource, that.mySource) && this.myMessage.equals(that.myMessage) && this.mySeverity.equals((Object)that.mySeverity);
    }

    public int hashCode() {
        return Objects.hash(this.myCode, this.mySource, this.myMessage, this.mySeverity, this.myStartLine, this.myStartColumn, this.myEndLine, this.myEndColumn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangdFixits";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clionFixits";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangDiagnostic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangDiagnostic";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClionFixits";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangdFixits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

