/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.run;

public class InstantAppRunException
extends Exception {
    private final ErrorType myErrorType;

    InstantAppRunException(ErrorType errorType) {
        super(InstantAppRunException.createMessageForError(errorType));
        this.myErrorType = errorType;
    }

    InstantAppRunException(ErrorType errorType, Throwable cause) {
        super(InstantAppRunException.createMessageForError(errorType) + " Caused by: " + cause.getMessage(), cause);
        this.myErrorType = errorType;
    }

    InstantAppRunException(ErrorType errorType, String message) {
        super(InstantAppRunException.createMessageForError(errorType) + " " + message);
        this.myErrorType = errorType;
    }

    InstantAppRunException(ErrorType errorType, String message, Throwable cause) {
        super(InstantAppRunException.createMessageForError(errorType) + " " + message + " Caused by: " + cause.getMessage(), cause);
        this.myErrorType = errorType;
    }

    private static String createMessageForError(ErrorType errorType) {
        switch (errorType.ordinal()) {
            case 0: {
                return "Reading bundle timed out.";
            }
            case 1: {
                return "Failure when trying to read bundle.";
            }
            case 2: {
                return "There is no Google account on the target device. Please log in to a Google account and try again.";
            }
            case 3: {
                return "Shell adb command has timed out.";
            }
            case 4: {
                return "ADB has failed.";
            }
            case 5: {
                return "Installing APK failed.";
            }
            case 6: {
                return "Cancelled by the user.";
            }
            case 7: {
                return "Error while deploying Instant App.";
            }
        }
        return null;
    }

    public ErrorType getErrorType() {
        return this.myErrorType;
    }

    public static enum ErrorType {
        READ_IAPK_TIMEOUT,
        READ_IAPK_FAILED,
        NO_GOOGLE_ACCOUNT,
        SHELL_TIMEOUT,
        ADB_FAILURE,
        INSTALL_FAILED,
        CANCELLED,
        UNKNOWN;

    }
}

