/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.provision;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.instantapp.provision.ProvisionException;
import com.android.instantapp.provision.ProvisionListener;
import com.android.instantapp.provision.ProvisionRunner;
import com.google.common.collect.Lists;
import java.util.List;

public class UnprovisionRunner {
    private static final List<String> INSTANT_APP_PACKAGES = Lists.newArrayList((Object[])new String[]{"com.google.android.instantapps.supervisor", "com.google.android.instantapps.devman"});
    private final ProvisionListener myListener;
    private long myShellTimeout = 500L;

    public UnprovisionRunner() {
        this(new ProvisionListener.NullListener());
    }

    public UnprovisionRunner(ProvisionListener listener) {
        this.myListener = listener;
    }

    public void runUnprovision(IDevice device) throws ProvisionException {
        this.myListener.setProgress(0.0);
        this.myListener.printMessage("Starting unprovisioning.");
        int i2 = 0;
        for (String pkgName : INSTANT_APP_PACKAGES) {
            if (this.myListener.isCancelled()) continue;
            this.myListener.printMessage("Uninstalling package " + pkgName);
            this.myListener.logMessage("Uninstalling package " + pkgName + " of device " + device, null);
            this.removePackage(device, pkgName);
            this.myListener.setProgress(1.0 * (double)(++i2) / (double)INSTANT_APP_PACKAGES.size());
        }
        this.myListener.setProgress(1.0);
    }

    private void removePackage(IDevice device, String pkgName) throws ProvisionException {
        try {
            String result;
            if (!UnprovisionRunner.isEmpty(ProvisionRunner.executeShellCommand(device, "pm path " + pkgName, false, this.myShellTimeout)) && (result = device.uninstallPackage(pkgName)) != null) {
                throw new ProvisionException(ProvisionException.ErrorType.UNKNOWN, result);
            }
        }
        catch (InstallException e) {
            throw new ProvisionException(ProvisionException.ErrorType.UNINSTALL_FAILED, "Package " + pkgName, e);
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

