/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.usage;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceId;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0015\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >2\u00020\u0001:\u0001>B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020\u0017J\"\u0010#\u001a\u0004\u0018\u00010\u000b2\b\u0010%\u001a\u0004\u0018\u00010\u00152\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0015J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0015J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010)\u001a\u00020\u0015J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010+\u001a\u00020\u0015J\u000e\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bJ\u0018\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000b000/J\u000e\u00101\u001a\u0002022\u0006\u0010$\u001a\u00020\u0015J\u000e\u00103\u001a\u0002022\u0006\u0010$\u001a\u00020\u0015J\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0006\u00105\u001a\u00020\u0015J\u0006\u00106\u001a\u00020\u0015J\u0006\u00107\u001a\u00020\u0015J\u0006\u00108\u001a\u00020\u0015J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0:2\u0006\u0010;\u001a\u00020\u0015H\u0002J\u000e\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000b0\u00140\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0007\"\u0004\b\"\u0010\u0005\u00a8\u0006?"}, d2={"Lcom/android/ide/common/resources/usage/ResourceStore;", "", "supportMultipackages", "", "<init>", "(Z)V", "getSupportMultipackages", "()Z", "resourceById", "", "Lcom/android/ide/common/resources/usage/ResourceId;", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "resources", "", "getResources", "()Ljava/util/List;", "_resources", "", "typeToName", "Lcom/android/resources/ResourceType;", "Lcom/google/common/collect/LinkedListMultimap;", "", "valueToResource", "", "keepResources", "", "keepAttributes", "getKeepAttributes", "_keepAttributes", "discardAttributes", "getDiscardAttributes", "_discardAttributes", "safeMode", "getSafeMode", "setSafeMode", "getResource", "value", "packageName", "type", "name", "getResourcesFromUrl", "possibleUrlReference", "getResourcesFromWebUrl", "webUrl", "addResource", "resource", "getResourceMaps", "", "Lcom/google/common/collect/ListMultimap;", "recordKeepToolAttribute", "", "recordDiscardToolAttribute", "processToolsAttributes", "dumpConfig", "dumpKeepResources", "dumpReferences", "dumpResourceModel", "getResourcesForKeepOrDiscardPattern", "Lkotlin/sequences/Sequence;", "pattern", "merge", "other", "Companion", "android.sdktools.sdk-common"})
@SourceDebugExtension(value={"SMAP\nResourceStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceStore.kt\ncom/android/ide/common/resources/usage/ResourceStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,633:1\n1374#2:634\n1460#2,5:635\n1869#2,2:640\n1869#2,2:642\n1563#2:644\n1634#2,3:645\n1869#2,2:648\n1869#2,2:650\n1869#2:652\n1869#2,2:653\n1870#2:655\n1869#2:656\n1869#2,2:657\n1870#2:659\n1#3:660\n*S KotlinDebug\n*F\n+ 1 ResourceStore.kt\ncom/android/ide/common/resources/usage/ResourceStore\n*L\n159#1:634\n159#1:635,5\n219#1:640,2\n233#1:642,2\n277#1:644\n277#1:645,3\n320#1:648,2\n323#1:650,2\n328#1:652\n332#1:653,2\n328#1:655\n339#1:656\n342#1:657,2\n339#1:659\n*E\n"})
public final class ResourceStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportMultipackages;
    @NotNull
    private final Map<ResourceId, ResourceUsageModel.Resource> resourceById;
    @NotNull
    private final List<ResourceUsageModel.Resource> _resources;
    @NotNull
    private final Map<ResourceType, LinkedListMultimap<String, ResourceUsageModel.Resource>> typeToName;
    @NotNull
    private final Map<Integer, ResourceUsageModel.Resource> valueToResource;
    @NotNull
    private final Set<ResourceId> keepResources;
    @NotNull
    private final List<String> _keepAttributes;
    @NotNull
    private final List<String> _discardAttributes;
    private boolean safeMode;
    private static final int TYPICAL_RESOURCE_COUNT = 200;

    public ResourceStore(boolean supportMultipackages) {
        this.supportMultipackages = supportMultipackages;
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMapWithExpectedSize((int)200);
        Intrinsics.checkNotNullExpressionValue((Object)linkedHashMap, (String)"newLinkedHashMapWithExpectedSize(...)");
        this.resourceById = linkedHashMap;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)200);
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayListWithCapacity(...)");
        this._resources = arrayList;
        EnumMap enumMap = Maps.newEnumMap(ResourceType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enumMap, (String)"newEnumMap(...)");
        this.typeToName = enumMap;
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)200);
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(...)");
        this.valueToResource = hashMap;
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        this.keepResources = hashSet;
        ArrayList arrayList2 = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList2, (String)"newArrayList(...)");
        this._keepAttributes = arrayList2;
        ArrayList arrayList3 = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList3, (String)"newArrayList(...)");
        this._discardAttributes = arrayList3;
        this.safeMode = true;
    }

    public /* synthetic */ ResourceStore(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getSupportMultipackages() {
        return this.supportMultipackages;
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResources() {
        List<ResourceUsageModel.Resource> list = Collections.unmodifiableList(this._resources);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    @NotNull
    public final List<String> getKeepAttributes() {
        List<String> list = Collections.unmodifiableList(this._keepAttributes);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    @NotNull
    public final List<String> getDiscardAttributes() {
        List<String> list = Collections.unmodifiableList(this._discardAttributes);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    public final boolean getSafeMode() {
        return this.safeMode;
    }

    public final void setSafeMode(boolean bl) {
        this.safeMode = bl;
    }

    @Nullable
    public final ResourceUsageModel.Resource getResource(int value) {
        return this.valueToResource.get(value);
    }

    @Nullable
    public final ResourceUsageModel.Resource getResource(@Nullable String packageName, @NotNull ResourceType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Preconditions.checkArgument((this.supportMultipackages || packageName == null ? 1 : 0) != 0, (String)"In a single package mode packageName must be null.", (Object[])new Object[0]);
        return this.resourceById.get(new ResourceId(type, name, packageName));
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResources(@NotNull ResourceType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LinkedListMultimap<String, ResourceUsageModel.Resource> linkedListMultimap = this.typeToName.get(type);
        if (linkedListMultimap == null) {
            return CollectionsKt.emptyList();
        }
        LinkedListMultimap<String, ResourceUsageModel.Resource> resourcesByName = linkedListMultimap;
        List list = resourcesByName.get((Object)ResourcesUtil.resourceNameToFieldName(name));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
        return CollectionsKt.toList((Iterable)list);
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResourcesFromUrl(@NotNull String possibleUrlReference) {
        Intrinsics.checkNotNullParameter((Object)possibleUrlReference, (String)"possibleUrlReference");
        ResourceUrl url = ResourceUrl.parse((String)possibleUrlReference);
        if (url == null || url.isFramework()) {
            return CollectionsKt.emptyList();
        }
        ResourceType resourceType = url.type;
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
        String string = url.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return this.getResources(resourceType, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceUsageModel.Resource> getResourcesFromWebUrl(@NotNull String webUrl) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)webUrl, (String)"webUrl");
        String afterAndroidRes = StringsKt.substringAfter$default((String)webUrl, (String)"android_res/", null, (int)2, null);
        String[] stringArray = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)afterAndroidRes, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        if (parts.size() < 2) {
            return CollectionsKt.emptyList();
        }
        String type = (String)parts.get(0);
        String namePart = (String)parts.get(1);
        ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)type);
        if (resourceFolderType == null) {
            return CollectionsKt.emptyList();
        }
        ResourceFolderType folderType = resourceFolderType;
        String name = StringsKt.substringBefore$default((String)namePart, (char)'.', null, (int)2, null);
        List list = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRelatedResourceTypes(...)");
        Iterable iterable = list;
        boolean $i$f$flatMap = false;
        void var10_10 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ResourceType it = (ResourceType)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = this.getResources(it, name);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ResourceUsageModel.Resource addResource(@NotNull ResourceUsageModel.Resource resource) {
        ResourceUsageModel.Resource resource2;
        Pair pair;
        Map<Object, ResourceUsageModel.Resource> map;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        if (!this.supportMultipackages) {
            resource.packageName = null;
        }
        ResourceType resourceType = resource.type;
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
        String string = resource.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        ResourceId id = new ResourceId(resourceType, string, resource.packageName);
        ResourceUsageModel.Resource stored = this.resourceById.get(id);
        if (stored == null) {
            map = this.resourceById;
            pair = TuplesKt.to((Object)id, (Object)resource);
            map.put((ResourceId)pair.getFirst(), (ResourceUsageModel.Resource)pair.getSecond());
            ((Collection)this._resources).add(resource);
            this.typeToName.computeIfAbsent(resource.type, arg_0 -> ResourceStore.addResource$lambda$1(ResourceStore::addResource$lambda$0, arg_0)).put((Object)resource.name, (Object)resource);
            if (resource.value != -1) {
                map = this.valueToResource;
                pair = TuplesKt.to((Object)resource.value, (Object)resource);
                map.put(pair.getFirst(), (ResourceUsageModel.Resource)pair.getSecond());
            }
            resource2 = resource;
        } else {
            Preconditions.checkState((resource.value == -1 || stored.value == resource.value ? 1 : 0) != 0, (String)"Resource value must be the same between addResource calls.", (Object[])new Object[0]);
            if (resource.value != -1 && stored.value == -1) {
                stored.value = resource.value;
                map = this.valueToResource;
                pair = TuplesKt.to((Object)stored.value, (Object)stored);
                map.put((ResourceId)pair.getFirst(), (ResourceUsageModel.Resource)pair.getSecond());
            }
            resource2 = stored;
        }
        ResourceUsageModel.Resource updated = resource2;
        return updated;
    }

    @NotNull
    public final Collection<ListMultimap<String, ResourceUsageModel.Resource>> getResourceMaps() {
        return this.typeToName.values();
    }

    public final void recordKeepToolAttribute(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Iterable iterable = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"split(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ((Collection)this._keepAttributes).add(it);
        }
    }

    public final void recordDiscardToolAttribute(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Iterable iterable = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"split(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ((Collection)this._discardAttributes).add(it);
        }
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> processToolsAttributes() {
        return CollectionsKt.minus((Iterable)SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this._keepAttributes), arg_0 -> ResourceStore.processToolsAttributes$lambda$0(this, arg_0)), arg_0 -> ResourceStore.processToolsAttributes$lambda$1(this, arg_0))), (Sequence)SequencesKt.onEach((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this._discardAttributes), arg_0 -> ResourceStore.processToolsAttributes$lambda$2(this, arg_0)), ResourceStore::processToolsAttributes$lambda$3));
    }

    @NotNull
    public final String dumpConfig() {
        Function1[] function1Array = new Function1[]{ResourceStore::dumpConfig$lambda$0, ResourceStore::dumpConfig$lambda$1};
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)this._resources), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)), arg_0 -> ResourceStore.dumpConfig$lambda$2(this, arg_0)), (CharSequence)"\n", (CharSequence)"", (CharSequence)"\n", (int)0, null, null, (int)56, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dumpKeepResources() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.keepResources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceId resourceId = (ResourceId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String dumpReferences() {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this._resources), ResourceStore::dumpReferences$lambda$0), ResourceStore::dumpReferences$lambda$1)), (CharSequence)"\n", (CharSequence)"Resource Reference Graph:\n", (CharSequence)"", (int)0, null, null, (int)56, null);
    }

    @NotNull
    public final String dumpResourceModel() {
        Function1[] function1Array = new Function1[]{ResourceStore::dumpResourceModel$lambda$0, ResourceStore::dumpResourceModel$lambda$1};
        return SequencesKt.joinToString$default((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)this._resources), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)), ResourceStore::dumpResourceModel$lambda$2), (CharSequence)"\n", (CharSequence)"", (CharSequence)"\n", (int)0, null, null, (int)56, null);
    }

    private final Sequence<ResourceUsageModel.Resource> getResourcesForKeepOrDiscardPattern(String pattern) {
        Sequence sequence;
        ResourceUrl url = ResourceUrl.parse((String)pattern);
        if (url == null || url.isFramework()) {
            return SequencesKt.emptySequence();
        }
        LinkedListMultimap<String, ResourceUsageModel.Resource> linkedListMultimap = this.typeToName.get(url.type);
        if (linkedListMultimap == null) {
            return SequencesKt.emptySequence();
        }
        LinkedListMultimap<String, ResourceUsageModel.Resource> resources = linkedListMultimap;
        String string = url.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"*", (boolean)false, (int)2, null)) {
            String string2 = url.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"?", (boolean)false, (int)2, null)) {
                List list = resources.get((Object)url.name);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
                return CollectionsKt.asSequence((Iterable)list);
            }
        }
        try {
            String string3 = url.name;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
            String string4 = SdkUtils.globToRegexp((String)ResourcesUtil.resourceNameToFieldName(string3));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"globToRegexp(...)");
            String string5 = string4;
            Regex regexp = new Regex(string5);
            List list = resources.entries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entries(...)");
            sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> ResourceStore.getResourcesForKeepOrDiscardPattern$lambda$0(regexp, arg_0)), ResourceStore::getResourcesForKeepOrDiscardPattern$lambda$1);
        }
        catch (PatternSyntaxException e) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    public final void merge(@NotNull ResourceStore other) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        ResourceUsageModel.Resource existing;
        ResourceUsageModel.Resource r;
        String it;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Iterable $this$forEach$iv2 = other._discardAttributes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (String)element$iv;
            boolean bl = false;
            if (this._discardAttributes.contains(it)) continue;
            this._discardAttributes.add(it);
        }
        $this$forEach$iv2 = other._keepAttributes;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (String)element$iv;
            boolean bl = false;
            if (this._keepAttributes.contains(it)) continue;
            this._keepAttributes.add(it);
        }
        $this$forEach$iv2 = other._resources;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            r = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            String string = r.packageName;
            ResourceType resourceType = r.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
            String string2 = r.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            ResourceUsageModel.Resource resource = this.getResource(string, resourceType, string2);
            if (resource == null) {
                resource = this.addResource(new ResourceUsageModel.Resource(r.packageName, r.type, r.name, r.value));
            }
            existing = resource;
            existing.mFlags |= r.mFlags;
            List<Path> list = r.declarations;
            if (list == null) continue;
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Path location = (Path)element$iv2;
                boolean bl2 = false;
                List<Path> locations = existing.declarations;
                if (locations != null && locations.contains(location)) continue;
                existing.addLocation(location);
            }
        }
        $this$forEach$iv2 = other._resources;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            r = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            String string = r.packageName;
            ResourceType resourceType = r.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
            String string3 = r.name;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
            existing = this.getResource(string, resourceType, string3);
            if (existing == null) continue;
            List<ResourceUsageModel.Resource> list = r.references;
            if (list == null) continue;
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                ResourceUsageModel.Resource referenced = (ResourceUsageModel.Resource)element$iv2;
                boolean bl3 = false;
                String string4 = referenced.packageName;
                ResourceType resourceType2 = referenced.type;
                Intrinsics.checkNotNullExpressionValue((Object)resourceType2, (String)"type");
                String string5 = referenced.name;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name");
                ResourceUsageModel.Resource ref = this.getResource(string4, resourceType2, string5);
                if (ref == null) continue;
                existing.addReference(ref);
            }
        }
    }

    private static final LinkedListMultimap addResource$lambda$0(ResourceType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LinkedListMultimap.create();
    }

    private static final LinkedListMultimap addResource$lambda$1(Function1 $tmp0, Object p0) {
        return (LinkedListMultimap)$tmp0.invoke(p0);
    }

    private static final Sequence processToolsAttributes$lambda$0(ResourceStore this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getResourcesForKeepOrDiscardPattern(it);
    }

    private static final Unit processToolsAttributes$lambda$1(ResourceStore this$0, ResourceUsageModel.Resource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReachable(true);
        Collection collection = this$0.keepResources;
        ResourceType resourceType = it.type;
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
        String string = it.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        collection.add(new ResourceId(resourceType, string, it.packageName));
        return Unit.INSTANCE;
    }

    private static final Sequence processToolsAttributes$lambda$2(ResourceStore this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getResourcesForKeepOrDiscardPattern(it);
    }

    private static final Unit processToolsAttributes$lambda$3(ResourceUsageModel.Resource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReachable(false);
        return Unit.INSTANCE;
    }

    private static final Comparable dumpConfig$lambda$0(ResourceUsageModel.Resource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)it.type;
    }

    private static final Comparable dumpConfig$lambda$1(ResourceUsageModel.Resource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.name);
    }

    private static final String dumpConfig$lambda$2(ResourceStore this$0, ResourceUsageModel.Resource r) {
        String string;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        ResourceType resourceType = r.type;
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
        String string2 = r.name;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        ResourceId id = new ResourceId(resourceType, string2, r.packageName);
        Object[] objectArray = new String[2];
        String string3 = string = "remove";
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = r.isReachable();
        objectArray2[n] = !bl2 ? string : null;
        String it = string = "no_obfuscate";
        n = 1;
        objectArray2 = objectArray;
        boolean bl3 = false;
        bl2 = this$0.keepResources.contains(id);
        objectArray2[n] = bl2 ? string : null;
        String actions = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        return r.type + '/' + r.name + '#' + actions;
    }

    private static final boolean dumpReferences$lambda$0(ResourceUsageModel.Resource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.references != null;
    }

    private static final String dumpReferences$lambda$1(ResourceUsageModel.Resource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + " => " + it.references;
    }

    private static final Comparable dumpResourceModel$lambda$0(ResourceUsageModel.Resource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)it.type;
    }

    private static final Comparable dumpResourceModel$lambda$1(ResourceUsageModel.Resource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.name);
    }

    private static final Sequence dumpResourceModel$lambda$2(ResourceUsageModel.Resource r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Sequence sequence = r.references;
        if (sequence == null || (sequence = CollectionsKt.asSequence((Iterable)((Iterable)sequence))) == null) {
            sequence = SequencesKt.emptySequence();
        }
        Sequence references = sequence;
        Object[] objectArray = new String[]{r.getUrl() + " : reachable=" + r.isReachable()};
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Sequence)SequencesKt.map((Sequence)references, ResourceStore::dumpResourceModel$lambda$2$0));
    }

    private static final String dumpResourceModel$lambda$2$0(ResourceUsageModel.Resource it) {
        return "    " + it.getUrl();
    }

    private static final boolean getResourcesForKeepOrDiscardPattern$lambda$0(Regex $regexp, Map.Entry it) {
        Object k = it.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
        return $regexp.matches((CharSequence)k);
    }

    private static final ResourceUsageModel.Resource getResourcesForKeepOrDiscardPattern$lambda$1(Map.Entry it) {
        return (ResourceUsageModel.Resource)it.getValue();
    }

    public ResourceStore() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ$\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/ide/common/resources/usage/ResourceStore$Companion;", "", "<init>", "()V", "TYPICAL_RESOURCE_COUNT", "", "serialize", "", "store", "Lcom/android/ide/common/resources/usage/ResourceStore;", "includeValues", "", "serializeInto", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "deserialize", "s", "android.sdktools.sdk-common"})
    @SourceDebugExtension(value={"SMAP\nResourceStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceStore.kt\ncom/android/ide/common/resources/usage/ResourceStore$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,633:1\n1137#2,2:634\n216#3,2:636\n*S KotlinDebug\n*F\n+ 1 ResourceStore.kt\ncom/android/ide/common/resources/usage/ResourceStore$Companion\n*L\n513#1:634,2\n616#1:636,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String serialize(@NotNull ResourceStore store, boolean includeValues) {
            Intrinsics.checkNotNullParameter((Object)store, (String)"store");
            StringBuilder sb = new StringBuilder(2000);
            this.serializeInto(sb, store, includeValues);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public static /* synthetic */ String serialize$default(Companion companion, ResourceStore resourceStore, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.serialize(resourceStore, bl);
        }

        public final void serializeInto(@NotNull StringBuilder sb, @NotNull ResourceStore store, boolean includeValues) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Intrinsics.checkNotNullParameter((Object)store, (String)"store");
            if (store.getSupportMultipackages()) {
                sb.append("P;");
            }
            Map storeTypeToName = store.typeToName;
            HashBiMap hashBiMap = HashBiMap.create((int)storeTypeToName.size());
            Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
            BiMap referenceMap = (BiMap)hashBiMap;
            int nextId = 0;
            for (ResourceType type : storeTypeToName.keySet()) {
                LinkedListMultimap list;
                if ((LinkedListMultimap)storeTypeToName.get(type) == null) continue;
                for (ResourceUsageModel.Resource resource : list.values()) {
                    ((Map)referenceMap).put(resource, nextId++);
                }
            }
            if (referenceMap.isEmpty()) {
                return;
            }
            ResourceType prev = null;
            boolean first = true;
            for (ResourceUsageModel.Resource resource : referenceMap.keySet()) {
                boolean includeValue;
                ResourceType type = resource.type;
                if (type != prev) {
                    prev = type;
                    if (!first) {
                        sb.append(']');
                        sb.append(',');
                        first = true;
                    }
                    sb.append(type.getName());
                    sb.append('[');
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(resource.name);
                sb.append('(');
                sb.append(resource.flagString());
                boolean bl = includeValue = includeValues && resource.value != -1;
                if (store.getSupportMultipackages()) {
                    if (resource.packageName != null) {
                        sb.append(',');
                        sb.append(resource.packageName);
                    } else if (includeValue) {
                        sb.append(',');
                    }
                }
                if (includeValue) {
                    sb.append(',');
                    sb.append(Integer.toHexString(resource.value));
                }
                sb.append(')');
            }
            sb.append(']');
            sb.append(';');
            first = true;
            for (ResourceUsageModel.Resource resource : referenceMap.keySet()) {
                List<ResourceUsageModel.Resource> references = resource.references;
                if (references == null || !(!((Collection)references).isEmpty())) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                Intrinsics.checkNotNull((Object)resource);
                sb.append(com.android.ide.common.resources.usage.ResourceStore$Companion.serializeInto$id(resource, (BiMap<ResourceUsageModel.Resource, Integer>)referenceMap));
                for (ResourceUsageModel.Resource reference : references) {
                    sb.append('^');
                    Intrinsics.checkNotNull((Object)reference);
                    sb.append(com.android.ide.common.resources.usage.ResourceStore$Companion.serializeInto$id(reference, (BiMap<ResourceUsageModel.Resource, Integer>)referenceMap));
                }
            }
            sb.append(';');
            List $this$serializeInto_u24lambda_u240 = store._keepAttributes;
            boolean bl = false;
            if (!((Collection)$this$serializeInto_u24lambda_u240).isEmpty()) {
                CollectionsKt.joinTo$default((Iterable)$this$serializeInto_u24lambda_u240, (Appendable)sb, (CharSequence)",", null, null, (int)0, null, null, (int)124, null);
            }
            sb.append(';');
            List $this$serializeInto_u24lambda_u241 = store._discardAttributes;
            boolean bl2 = false;
            if (!((Collection)$this$serializeInto_u24lambda_u241).isEmpty()) {
                CollectionsKt.joinTo$default((Iterable)$this$serializeInto_u24lambda_u241, (Appendable)sb, (CharSequence)",", null, null, (int)0, null, null, (int)124, null);
            }
            sb.append(';');
        }

        public static /* synthetic */ void serializeInto$default(Companion companion, StringBuilder stringBuilder, ResourceStore resourceStore, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            companion.serializeInto(stringBuilder, resourceStore, bl);
        }

        @NotNull
        public final ResourceStore deserialize(@NotNull String s) {
            int discardEnd;
            int keepEnd;
            char next;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (((CharSequence)s).length() == 0) {
                return new ResourceStore(false, 1, null);
            }
            int offset = 0;
            boolean supportMultiPackages = false;
            if (StringsKt.startsWith$default((String)s, (String)"P;", (boolean)false, (int)2, null)) {
                supportMultiPackages = true;
                offset += 2;
            }
            ResourceStore resourceStore = new ResourceStore(supportMultiPackages);
            HashBiMap hashBiMap = HashBiMap.create((int)(s.length() / 10));
            Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
            BiMap referenceMap = (BiMap)hashBiMap;
            int nextId = 0;
            int length = s.length();
            ResourceType type = ResourceType.SAMPLE_DATA;
            char[] cArray = new char[]{',', ')', '^', ';'};
            char[] delimiters = cArray;
            block0: while (offset < length && (next = s.charAt(offset)) != ';') {
                ResourceType fromClassName;
                Object $this$first$iv2;
                ResourceType resourceType;
                int typeEnd;
                block20: {
                    String typeString;
                    boolean bl;
                    typeEnd = StringsKt.indexOf$default((CharSequence)s, (char)'[', (int)offset, (boolean)false, (int)4, null);
                    boolean bl2 = bl = typeEnd != -1;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)s.substring(offset, typeEnd), (String)"substring(...)");
                    resourceType = ResourceType.fromClassName((String)typeString);
                    if (resourceType == null) {
                        $this$first$iv2 = ResourceType.values();
                        boolean $i$f$first = false;
                        int n = ((ResourceType[])$this$first$iv2).length;
                        for (int j = 0; j < n; ++j) {
                            ResourceType element$iv;
                            ResourceType it = element$iv = $this$first$iv2[j];
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)typeString)) continue;
                            resourceType = element$iv;
                            break block20;
                        }
                        throw new NoSuchElementException("Array contains no element matching the predicate.");
                    }
                }
                type = fromClassName = resourceType;
                offset = typeEnd + 1;
                while (offset < length) {
                    String name;
                    String flagString;
                    boolean $this$first$iv2;
                    boolean bl;
                    boolean bl4 = bl = s.charAt(offset) != ']';
                    if (_Assertions.ENABLED && !bl) {
                        $this$first$iv2 = "Assertion failed";
                        throw new AssertionError($this$first$iv2);
                    }
                    int nameEnd = StringsKt.indexOf$default((CharSequence)s, (char)'(', (int)offset, (boolean)false, (int)4, null);
                    boolean bl5 = $this$first$iv2 = nameEnd != -1;
                    if (_Assertions.ENABLED && !$this$first$iv2) {
                        String $i$f$first = "Assertion failed";
                        throw new AssertionError((Object)$i$f$first);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)s.substring(offset, nameEnd), (String)"substring(...)");
                    offset = nameEnd + 1;
                    int end = StringsKt.indexOfAny$default((CharSequence)s, (char[])delimiters, (int)offset, (boolean)false, (int)4, null);
                    Intrinsics.checkNotNullExpressionValue((Object)s.substring(offset, end), (String)"substring(...)");
                    int flags = ResourceUsageModel.Resource.stringToFlag(flagString);
                    String pkg = null;
                    if (supportMultiPackages && s.charAt(end) == ',') {
                        offset = end + 1;
                        int packageEnd = StringsKt.indexOfAny$default((CharSequence)s, (char[])delimiters, (int)offset, (boolean)false, (int)4, null);
                        if (packageEnd > offset) {
                            String string = s.substring(offset, packageEnd);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            pkg = string;
                        }
                        end = packageEnd;
                    }
                    int value = 0;
                    if (s.charAt(end) == ',') {
                        String valueString;
                        offset = end + 1;
                        int valueEnd = StringsKt.indexOf$default((CharSequence)s, (char)')', (int)offset, (boolean)false, (int)4, null);
                        Intrinsics.checkNotNullExpressionValue((Object)s.substring(offset, valueEnd), (String)"substring(...)");
                        value = Integer.parseUnsignedInt(valueString, 16);
                        offset = valueEnd + 1;
                    } else {
                        value = -1;
                        offset = end + 1;
                    }
                    ResourceUsageModel.Resource resource = new ResourceUsageModel.Resource(pkg, type, name, value);
                    resource.mFlags = flags;
                    ((Map)referenceMap).put(resource, nextId++);
                    if (s.charAt(offset++) == ',') continue;
                    if (s.charAt(offset) != ',') continue block0;
                    ++offset;
                    continue block0;
                }
            }
            if (offset < length - 1) {
                BiMap inverse = referenceMap.inverse();
                ++offset;
                while (offset < length) {
                    String idString;
                    if (s.charAt(offset) == ';') {
                        ++offset;
                        break;
                    }
                    int end = StringsKt.indexOfAny$default((CharSequence)s, (char[])delimiters, (int)offset, (boolean)false, (int)4, null);
                    Intrinsics.checkNotNullExpressionValue((Object)s.substring(offset, end), (String)"substring(...)");
                    int id = Integer.parseInt(idString, 16);
                    Object object = inverse.get((Object)id);
                    Intrinsics.checkNotNull((Object)object);
                    ResourceUsageModel.Resource resource = (ResourceUsageModel.Resource)object;
                    offset = end + 1;
                    while (offset < length) {
                        String refIdString;
                        int refEnd = StringsKt.indexOfAny$default((CharSequence)s, (char[])delimiters, (int)offset, (boolean)false, (int)4, null);
                        Intrinsics.checkNotNullExpressionValue((Object)s.substring(offset, refEnd), (String)"substring(...)");
                        int ref = Integer.parseInt(refIdString, 16);
                        Object object2 = inverse.get((Object)ref);
                        Intrinsics.checkNotNull((Object)object2);
                        ResourceUsageModel.Resource reference = (ResourceUsageModel.Resource)object2;
                        resource.addReference(reference);
                        offset = refEnd + 1;
                        if (s.charAt(offset - 1) != ',' && s.charAt(offset - 1) != ';') continue;
                    }
                    if (s.charAt(offset - 1) != ';') continue;
                }
            }
            if ((keepEnd = StringsKt.indexOf$default((CharSequence)s, (char)';', (int)offset, (boolean)false, (int)4, null)) > offset) {
                String string = s.substring(offset, keepEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String keep = string;
                resourceStore.recordKeepToolAttribute(keep);
            }
            if ((discardEnd = StringsKt.indexOf$default((CharSequence)s, (char)';', (int)(offset = keepEnd + 1), (boolean)false, (int)4, null)) > offset) {
                String string = s.substring(offset, discardEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String discard = string;
                resourceStore.recordDiscardToolAttribute(discard);
            }
            Map $this$forEach$iv = (Map)referenceMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                ResourceUsageModel.Resource resource = (ResourceUsageModel.Resource)entry.getKey();
                Intrinsics.checkNotNull((Object)resource);
                resourceStore.addResource(resource);
            }
            resourceStore.processToolsAttributes();
            return resourceStore;
        }

        private static final String serializeInto$id(ResourceUsageModel.Resource $this$serializeInto_u24id, BiMap<ResourceUsageModel.Resource, Integer> referenceMap) {
            Object object = referenceMap.get((Object)$this$serializeInto_u24id);
            Intrinsics.checkNotNull((Object)object);
            String string = Integer.toHexString(((Number)object).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

