/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeUtils {
    NodeUtils() {
    }

    static Node adoptNode(Document document, Node node) {
        Node newNode = document.adoptNode(node);
        NodeUtils.updateNamespace(newNode, document);
        return newNode;
    }

    static Node duplicateAndAdoptNode(Document document, Node node) {
        Node newNode = NodeUtils.duplicateNode(document, node);
        NodeUtils.updateNamespace(newNode, document);
        return newNode;
    }

    static Node duplicateNode(Document document, Node node) {
        Element newNode = node.getNamespaceURI() != null ? document.createElementNS(node.getNamespaceURI(), node.getNodeName()) : document.createElement(node.getNodeName());
        NamedNodeMap attributes = node.getAttributes();
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            Attr newAttr;
            Attr attr = (Attr)attributes.item(i2);
            if (attr.getNamespaceURI() != null) {
                newAttr = document.createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                newNode.getAttributes().setNamedItemNS(newAttr);
            } else {
                newAttr = document.createAttribute(attr.getName());
                newNode.getAttributes().setNamedItem(newAttr);
            }
            newAttr.setValue(attr.getValue());
        }
        NodeList children = node.getChildNodes();
        block6: for (int i3 = 0; i3 < children.getLength(); ++i3) {
            Node duplicatedChild;
            Node child = children.item(i3);
            switch (child.getNodeType()) {
                case 1: {
                    duplicatedChild = NodeUtils.duplicateNode(document, child);
                    break;
                }
                case 4: {
                    duplicatedChild = document.createCDATASection(child.getNodeValue());
                    break;
                }
                case 3: {
                    duplicatedChild = document.createTextNode(child.getNodeValue());
                    break;
                }
                default: {
                    continue block6;
                }
            }
            newNode.appendChild(duplicatedChild);
        }
        return newNode;
    }

    static void addAttribute(Document document, Node node, String namespaceUri, String attrName, String attrValue) {
        Attr attr = namespaceUri != null ? document.createAttributeNS(namespaceUri, attrName) : document.createAttribute(attrName);
        attr.setValue(attrValue);
        if (namespaceUri != null) {
            node.getAttributes().setNamedItemNS(attr);
        } else {
            node.getAttributes().setNamedItem(attr);
        }
    }

    private static void updateNamespace(Node node, Document document) {
        NodeList children;
        NodeUtils.processSingleNodeNamespace(node, document);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Node attribute = attributes.item(i2);
                if (NodeUtils.processSingleNodeNamespace(attribute, document)) continue;
                String nsUri = attribute.getNamespaceURI();
                if (nsUri != null) {
                    attributes.removeNamedItemNS(nsUri, attribute.getLocalName());
                } else {
                    attributes.removeNamedItem(attribute.getLocalName());
                }
                --i2;
                --n;
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int n = children.getLength();
            for (int i3 = 0; i3 < n; ++i3) {
                Node child = children.item(i3);
                if (child == null) continue;
                NodeUtils.updateNamespace(child, document);
            }
        }
    }

    private static boolean processSingleNodeNamespace(Node node, Document document) {
        if ("xmlns".equals(node.getLocalName())) {
            return false;
        }
        String ns = node.getNamespaceURI();
        if (ns != null) {
            if (ns.equals("http://www.w3.org/2000/xmlns/")) {
                return false;
            }
            NamedNodeMap docAttributes = NodeUtils.getDocumentNamespaceAttributes(document);
            String prefix = NodeUtils.getPrefixForNs(docAttributes, ns);
            if (prefix == null) {
                prefix = NodeUtils.getUniqueNsAttribute(docAttributes);
                Attr nsAttr = document.createAttribute(prefix);
                nsAttr.setValue(ns);
                docAttributes.setNamedItem(nsAttr);
            }
            prefix = prefix.substring(6);
            node.setPrefix(prefix);
        }
        return true;
    }

    @VisibleForTesting
    static NamedNodeMap getDocumentNamespaceAttributes(Document document) {
        NamedNodeMap attributes = document.getChildNodes().item(0).getAttributes();
        assert (attributes != null);
        return attributes;
    }

    @VisibleForTesting
    static String getPrefixForNs(NamedNodeMap attributes, String namespaceURI) {
        int n = attributes.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            Attr attribute = (Attr)attributes.item(i2);
            if (!namespaceURI.equals(attribute.getValue()) || !attribute.getName().startsWith("xmlns:")) continue;
            return attribute.getName();
        }
        return null;
    }

    private static String getUniqueNsAttribute(NamedNodeMap attributes) {
        String name;
        int i2 = 1;
        while (attributes.getNamedItem(name = String.format("xmlns:ns%d", i2++)) != null) {
        }
        return name;
    }

    static boolean compareElementNode(Node node1, Node node2, boolean strict) {
        NamedNodeMap attr2;
        if (node1.getNamespaceURI() != null || node2.getNamespaceURI() != null ? !Objects.equal((Object)node1.getLocalName(), (Object)node2.getLocalName()) || !Objects.equal((Object)node1.getNamespaceURI(), (Object)node2.getNamespaceURI()) : !node1.getNodeName().equals(node2.getNodeName())) {
            return false;
        }
        NamedNodeMap attr1 = node1.getAttributes();
        if (!NodeUtils.compareAttributes(attr1, attr2 = node2.getAttributes())) {
            return false;
        }
        if (strict) {
            return NodeUtils.compareChildren(node1.getChildNodes(), node2.getChildNodes());
        }
        return NodeUtils.compareContent(node1.getChildNodes(), node2.getChildNodes());
    }

    private static boolean compareChildren(NodeList children1, NodeList children2) {
        if (children1.getLength() != children2.getLength()) {
            return false;
        }
        int n = children1.getLength();
        block4: for (int i2 = 0; i2 < n; ++i2) {
            Node child1 = children1.item(i2);
            Node child2 = children2.item(i2);
            short nodeType = child1.getNodeType();
            if (nodeType != child2.getNodeType()) {
                return false;
            }
            switch (nodeType) {
                case 1: {
                    if (NodeUtils.compareElementNode(child1, child2, true)) continue block4;
                    return false;
                }
                case 3: 
                case 4: 
                case 8: {
                    if (child1.getNodeValue().equals(child2.getNodeValue())) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean compareContent(NodeList children1, NodeList children2) {
        List<Node> childList = NodeUtils.getElementChildren(children1);
        List<Node> childList2 = NodeUtils.getElementChildren(children2);
        if (childList.size() != childList2.size()) {
            return false;
        }
        for (Node child : childList) {
            boolean found = false;
            for (Node child2 : childList2) {
                if (!NodeUtils.compareElementNode(child, child2, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static List<Node> getElementChildren(NodeList children) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)children.getLength());
        int len = children.getLength();
        for (int i2 = 0; i2 < len; ++i2) {
            Node child = children.item(i2);
            if (child.getNodeType() != 1) continue;
            results.add(child);
        }
        return results;
    }

    @VisibleForTesting
    static boolean compareAttributes(NamedNodeMap attrMap1, NamedNodeMap attrMap2) {
        if (attrMap1.getLength() != attrMap2.getLength()) {
            return false;
        }
        int n = attrMap1.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            Attr attr1 = (Attr)attrMap1.item(i2);
            String ns1 = attr1.getNamespaceURI();
            Attr attr2 = ns1 != null ? (Attr)attrMap2.getNamedItemNS(ns1, attr1.getLocalName()) : (Attr)attrMap2.getNamedItem(attr1.getName());
            if (attr2 != null && attr2.getValue().equals(attr1.getValue())) continue;
            return false;
        }
        return true;
    }

    static String getAttribute(Node node, String attrName) {
        Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }
}

