/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client.cli;

import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.utils.CoroutineUtilsKt;
import com.google.api.client.json.gson.GsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.services.firebase.directaccess.client.DirectAccessConnectionManager;
import com.google.services.firebase.directaccess.client.DirectAccessConnectionManagerKt;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManager;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManager2Kt;
import com.google.services.firebase.directaccess.client.cli.CredentialsNotFoundException;
import com.google.services.firebase.directaccess.client.cli.InitializationFailedException;
import com.google.services.firebase.directaccess.client.cli.ShowUsageException;
import com.google.services.firebase.directaccess.client.cli.UtilsKt;
import com.google.services.firebase.directaccess.client.cli.action.ConnectionAction;
import com.google.services.firebase.directaccess.client.cli.action.DirectAccessAction;
import com.google.services.firebase.directaccess.client.cli.action.ReservationAction;
import com.google.services.firebase.directaccess.client.cli.action.Settings;
import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.ForwardingDaemon;
import com.google.services.firebase.directaccess.client.device.remote.service.adb.forwardingdaemon.StreamOpener;
import com.google.services.firebase.directaccess.client.model.DeviceSessionName;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.LogManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 o2\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001oBU\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012 \b\u0002\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010=\u001a\u00020>J\b\u0010?\u001a\u00020>H\u0002J\u0018\u0010c\u001a\n d*\u0004\u0018\u000101012\u0006\u0010e\u001a\u00020\u0006H\u0002J\u0010\u0010f\u001a\u00020>2\u0006\u0010g\u001a\u00020\u0006H\u0002J\b\u0010h\u001a\u00020>H\u0002J\u001c\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060j2\u0006\u0010k\u001a\u00020lH\u0002J\b\u0010m\u001a\u00020>H\u0002J\b\u0010n\u001a\u00020>H\u0016R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R)\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR&\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u001e\u0010#\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010 R$\u0010%\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b&\u0010\u001e\u001a\u0004\b'\u0010 \"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00100\u001a\u0002018\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b2\u0010\u001e\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001b\u0010@\u001a\u00020A8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bB\u0010CR&\u0010F\u001a\u0004\u0018\u00010G8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bH\u0010\u001e\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR8\u0010M\u001a\u0016\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020P\u0018\u00010N8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bQ\u0010\u001e\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR2\u0010V\u001a\u0010\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020O\u0018\u00010W8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bY\u0010\u001e\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u001b\u0010^\u001a\u00020_8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bb\u0010E\u001a\u0004\b`\u0010a\u00a8\u0006p"}, d2={"Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings;", "Lcom/google/services/firebase/directaccess/client/cli/action/Settings;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "args", "", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "inputStream", "Ljava/io/BufferedReader;", "outputStream", "Ljava/io/PrintStream;", "accessTokenFetcher", "Lkotlin/Function3;", "<init>", "(Ljava/util/Map;Lkotlinx/coroutines/CoroutineScope;Ljava/io/BufferedReader;Ljava/io/PrintStream;Lkotlin/jvm/functions/Function3;)V", "getArgs", "()Ljava/util/Map;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "getInputStream", "()Ljava/io/BufferedReader;", "getOutputStream", "()Ljava/io/PrintStream;", "getAccessTokenFetcher", "()Lkotlin/jvm/functions/Function3;", "value", "endPoint", "getEndPoint$annotations", "()V", "getEndPoint", "()Ljava/lang/String;", "project", "getProject", "reservationName", "getReservationName", "accessToken", "getAccessToken$annotations", "getAccessToken", "setAccessToken", "(Ljava/lang/String;)V", "verbose", "", "getVerbose", "()Z", "setVerbose", "(Z)V", "channel", "Lio/grpc/ManagedChannel;", "getChannel$annotations", "getChannel", "()Lio/grpc/ManagedChannel;", "setChannel", "(Lio/grpc/ManagedChannel;)V", "action", "Lcom/google/services/firebase/directaccess/client/cli/action/DirectAccessAction;", "getAction", "()Lcom/google/services/firebase/directaccess/client/cli/action/DirectAccessAction;", "setAction", "(Lcom/google/services/firebase/directaccess/client/cli/action/DirectAccessAction;)V", "initializeSettings", "", "parseArgs", "reservationManager", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager;", "getReservationManager", "()Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager;", "reservationManager$delegate", "Lkotlin/Lazy;", "adbSession", "Lcom/android/adblib/AdbSession;", "getAdbSession$annotations", "getAdbSession", "()Lcom/android/adblib/AdbSession;", "setAdbSession", "(Lcom/android/adblib/AdbSession;)V", "forwardingDaemonFactory", "Lkotlin/Function2;", "Lcom/google/services/firebase/directaccess/client/device/remote/service/adb/forwardingdaemon/StreamOpener;", "Lcom/google/services/firebase/directaccess/client/device/remote/service/adb/forwardingdaemon/ForwardingDaemon;", "getForwardingDaemonFactory$annotations", "getForwardingDaemonFactory", "()Lkotlin/jvm/functions/Function2;", "setForwardingDaemonFactory", "(Lkotlin/jvm/functions/Function2;)V", "streamOpenerFactory", "Lkotlin/Function1;", "Lcom/google/services/firebase/directaccess/client/model/DeviceSessionName;", "getStreamOpenerFactory$annotations", "getStreamOpenerFactory", "()Lkotlin/jvm/functions/Function1;", "setStreamOpenerFactory", "(Lkotlin/jvm/functions/Function1;)V", "connectionManager", "Lcom/google/services/firebase/directaccess/client/DirectAccessConnectionManager;", "getConnectionManager", "()Lcom/google/services/firebase/directaccess/client/DirectAccessConnectionManager;", "connectionManager$delegate", "createChannel", "kotlin.jvm.PlatformType", "channelEndpoint", "createAuthInfoFromServiceAccountKey", "serviceKeyPathString", "createAuthInfoFromDefaultCredentials", "readCredentialsFromFile", "", "path", "Ljava/nio/file/Path;", "checkProjectAndAccessToken", "close", "Companion", "directaccess-client"})
public final class DirectAccessCliSettings
implements Settings,
AutoCloseable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Map<String, String> args;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final BufferedReader inputStream;
    @NotNull
    private final PrintStream outputStream;
    @NotNull
    private final Function3<String, String, String, String> accessTokenFetcher;
    @NotNull
    private String endPoint;
    @NotNull
    private String project;
    @NotNull
    private String reservationName;
    @NotNull
    private String accessToken;
    private boolean verbose;
    public ManagedChannel channel;
    public DirectAccessAction action;
    @NotNull
    private final Lazy reservationManager$delegate;
    @Nullable
    private AdbSession adbSession;
    @Nullable
    private Function2<? super StreamOpener, ? super CoroutineScope, ? extends ForwardingDaemon> forwardingDaemonFactory;
    @Nullable
    private Function1<? super DeviceSessionName, ? extends StreamOpener> streamOpenerFactory;
    @NotNull
    private final Lazy connectionManager$delegate;
    @NotNull
    private static final Map<String, Function1<DirectAccessCliSettings, DirectAccessAction>> ARG_TO_ACTION;

    public DirectAccessCliSettings(@NotNull Map<String, String> args, @NotNull CoroutineScope scope, @NotNull BufferedReader inputStream, @NotNull PrintStream outputStream, @NotNull Function3<? super String, ? super String, ? super String, String> accessTokenFetcher) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter(accessTokenFetcher, (String)"accessTokenFetcher");
        this.args = args;
        this.scope = scope;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.accessTokenFetcher = accessTokenFetcher;
        this.endPoint = "devicestreaming.googleapis.com";
        this.project = "";
        this.reservationName = "";
        this.accessToken = "";
        this.reservationManager$delegate = LazyKt.lazy(() -> DirectAccessCliSettings.reservationManager_delegate$lambda$0(this));
        this.connectionManager$delegate = LazyKt.lazy(() -> DirectAccessCliSettings.connectionManager_delegate$lambda$0(this));
    }

    public /* synthetic */ DirectAccessCliSettings(Map map2, CoroutineScope coroutineScope, BufferedReader bufferedReader, PrintStream printStream, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function3 = DirectAccessCliSettings::_init_$lambda$0;
        }
        this(map2, coroutineScope, bufferedReader, printStream, (Function3<? super String, ? super String, ? super String, String>)function3);
    }

    @Override
    @NotNull
    public Map<String, String> getArgs() {
        return this.args;
    }

    @Override
    @NotNull
    public CoroutineScope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public BufferedReader getInputStream() {
        return this.inputStream;
    }

    @Override
    @NotNull
    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    @NotNull
    public final Function3<String, String, String, String> getAccessTokenFetcher() {
        return this.accessTokenFetcher;
    }

    @NotNull
    public final String getEndPoint() {
        return this.endPoint;
    }

    @VisibleForTesting
    public static /* synthetic */ void getEndPoint$annotations() {
    }

    @NotNull
    public final String getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getReservationName() {
        return this.reservationName;
    }

    @NotNull
    public final String getAccessToken() {
        return this.accessToken;
    }

    public final void setAccessToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.accessToken = string;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAccessToken$annotations() {
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @NotNull
    public final ManagedChannel getChannel() {
        ManagedChannel managedChannel = this.channel;
        if (managedChannel != null) {
            return managedChannel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
        return null;
    }

    public final void setChannel(@NotNull ManagedChannel managedChannel) {
        Intrinsics.checkNotNullParameter((Object)managedChannel, (String)"<set-?>");
        this.channel = managedChannel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getChannel$annotations() {
    }

    @NotNull
    public final DirectAccessAction getAction() {
        DirectAccessAction directAccessAction = this.action;
        if (directAccessAction != null) {
            return directAccessAction;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"action");
        return null;
    }

    public final void setAction(@NotNull DirectAccessAction directAccessAction) {
        Intrinsics.checkNotNullParameter((Object)directAccessAction, (String)"<set-?>");
        this.action = directAccessAction;
    }

    public final void initializeSettings() {
        this.parseArgs();
        ManagedChannel managedChannel = this.createChannel(this.endPoint);
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"createChannel(...)");
        this.setChannel(managedChannel);
        if (!this.verbose) {
            LogManager.getLogManager().reset();
        }
        if (((CharSequence)this.accessToken).length() == 0 || ((CharSequence)this.project).length() == 0) {
            this.createAuthInfoFromDefaultCredentials();
        }
        Function1<DirectAccessCliSettings, DirectAccessAction> actionMapValue = UtilsKt.firstArgToAction(this.getArgs(), ARG_TO_ACTION);
        this.setAction((DirectAccessAction)actionMapValue.invoke((Object)this));
    }

    private final void parseArgs() {
        if (this.getArgs().isEmpty()) {
            throw new ShowUsageException(null, 1, null);
        }
        UtilsKt.retainAll(this.getArgs(), (Function1<? super Map.Entry<String, String>, Boolean>)((Function1)arg_0 -> DirectAccessCliSettings.parseArgs$lambda$0(this, arg_0)));
    }

    @Override
    @NotNull
    public DirectAccessReservationManager getReservationManager() {
        Lazy lazy = this.reservationManager$delegate;
        return (DirectAccessReservationManager)lazy.getValue();
    }

    @Nullable
    public final AdbSession getAdbSession() {
        return this.adbSession;
    }

    public final void setAdbSession(@Nullable AdbSession adbSession) {
        this.adbSession = adbSession;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAdbSession$annotations() {
    }

    @Nullable
    public final Function2<StreamOpener, CoroutineScope, ForwardingDaemon> getForwardingDaemonFactory() {
        return this.forwardingDaemonFactory;
    }

    public final void setForwardingDaemonFactory(@Nullable Function2<? super StreamOpener, ? super CoroutineScope, ? extends ForwardingDaemon> function2) {
        this.forwardingDaemonFactory = function2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getForwardingDaemonFactory$annotations() {
    }

    @Nullable
    public final Function1<DeviceSessionName, StreamOpener> getStreamOpenerFactory() {
        return this.streamOpenerFactory;
    }

    public final void setStreamOpenerFactory(@Nullable Function1<? super DeviceSessionName, ? extends StreamOpener> function1) {
        this.streamOpenerFactory = function1;
    }

    @VisibleForTesting
    public static /* synthetic */ void getStreamOpenerFactory$annotations() {
    }

    @Override
    @NotNull
    public DirectAccessConnectionManager getConnectionManager() {
        Lazy lazy = this.connectionManager$delegate;
        return (DirectAccessConnectionManager)lazy.getValue();
    }

    private final ManagedChannel createChannel(String channelEndpoint) {
        return NettyChannelBuilder.forTarget((String)("dns:///" + channelEndpoint)).withOption(ChannelOption.TCP_NODELAY, (Object)true).build();
    }

    private final void createAuthInfoFromServiceAccountKey(String serviceKeyPathString) {
        Path path = Paths.get(serviceKeyPathString, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path serviceKeyPath = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(serviceKeyPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new CredentialsNotFoundException(serviceKeyPathString + " does not exist", null, 2, null);
        }
        throw new UnsupportedOperationException("Reading from service key path is not supported");
    }

    private final void createAuthInfoFromDefaultCredentials() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        if (StringsKt.startsWith((String)string, (String)"Windows", (boolean)true)) {
            throw new UnsupportedOperationException("Using default credentials is not supported on Windows. Please provide --project and --access-token.");
        }
        Path defaultCredentialPath = UtilsKt.getApplicationDefaultCredentialsPath();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(defaultCredentialPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new CredentialsNotFoundException("Application default credentials not found at " + defaultCredentialPath, null, 2, null);
        }
        Map<String, String> jsonCreds = this.readCredentialsFromFile(defaultCredentialPath);
        String string2 = jsonCreds.get("client_id");
        if (string2 == null) {
            throw new CredentialsNotFoundException("client_id missing in default credentials", null, 2, null);
        }
        String clientId = string2;
        String string3 = jsonCreds.get("client_secret");
        if (string3 == null) {
            throw new CredentialsNotFoundException("client_secret missing in default credentials", null, 2, null);
        }
        String clientSecret = string3;
        String string4 = jsonCreds.get("refresh_token");
        if (string4 == null) {
            throw new CredentialsNotFoundException("refresh_token missing in default credentials", null, 2, null);
        }
        String refreshToken = string4;
        if (((CharSequence)this.accessToken).length() == 0) {
            this.accessToken = (String)this.accessTokenFetcher.invoke((Object)clientId, (Object)clientSecret, (Object)refreshToken);
        }
        if (((CharSequence)this.project).length() == 0) {
            String string5 = jsonCreds.get("quota_project_id");
            if (string5 == null) {
                throw new CredentialsNotFoundException("quota_project_id missing in default credentials", null, 2, null);
            }
            this.project = string5;
        }
    }

    private final Map<String, String> readCredentialsFromFile(Path path) {
        Object object;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new CredentialsNotFoundException(path + " does not exist", null, 2, null);
        }
        try {
            object = PathsKt.readText$default((Path)path, null, (int)1, null);
        }
        catch (Exception e) {
            throw new CredentialsNotFoundException("Error while reading credentials from " + path, null, 2, null);
        }
        String stringCreds = object;
        try {
            object = GsonFactory.getDefaultInstance().fromString(stringCreds, ((Map)new LinkedHashMap()).getClass());
            Intrinsics.checkNotNull((Object)object);
            object = (Map)object;
        }
        catch (Exception e) {
            throw new CredentialsNotFoundException("Error while parsing credentials", null, 2, null);
        }
        return object;
    }

    private final void checkProjectAndAccessToken() {
        if (((CharSequence)this.project).length() == 0) {
            throw new InitializationFailedException("Failed to initialize. Project ID not provided");
        }
        if (((CharSequence)this.accessToken).length() == 0) {
            throw new InitializationFailedException("Failed to initialize. Access token not provided or could not be retrieved");
        }
    }

    @Override
    public void close() {
        block0: {
            AdbSession adbSession = this.adbSession;
            if (adbSession == null) break block0;
            adbSession.close();
        }
    }

    private static final String _init_$lambda$0(String clientId, String clientSecret, String refreshToken) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        return UtilsKt.fetchAccessTokenForClient(clientId, clientSecret, refreshToken);
    }

    private static final boolean parseArgs$lambda$0(DirectAccessCliSettings this$0, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return switch ((String)entry.getKey()) {
            case "--service-account-key-file" -> {
                this$0.createAuthInfoFromServiceAccountKey((String)entry.getValue());
                yield true;
            }
            case "--endpoint" -> {
                this$0.endPoint = (String)entry.getValue();
                yield true;
            }
            case "--project" -> {
                this$0.project = (String)entry.getValue();
                yield true;
            }
            case "--access-token" -> {
                this$0.accessToken = (String)entry.getValue();
                yield true;
            }
            case "--verbose" -> {
                this$0.verbose = true;
                yield true;
            }
            case "--reservation-name" -> {
                this$0.reservationName = (String)entry.getValue();
                yield true;
            }
            default -> false;
        };
    }

    private static final DirectAccessReservationManager reservationManager_delegate$lambda$0(DirectAccessCliSettings this$0) {
        this$0.checkProjectAndAccessToken();
        return DirectAccessReservationManager2Kt.DirectAccessReservationManager(this$0.project, CoroutineUtilsKt.createChildScope$default((CoroutineScope)this$0.getScope(), (boolean)true, null, (int)2, null), true, (Channel)this$0.getChannel(), (Function0<String>)((Function0)() -> DirectAccessCliSettings.reservationManager_delegate$lambda$0$0(this$0)));
    }

    private static final String reservationManager_delegate$lambda$0$0(DirectAccessCliSettings this$0) {
        return this$0.accessToken;
    }

    private static final DirectAccessConnectionManager connectionManager_delegate$lambda$0(DirectAccessCliSettings this$0) {
        Object object;
        block5: {
            block4: {
                AdbSession adbSession = this$0.adbSession;
                if (adbSession == null) {
                    adbSession = AdbSession.Companion.create$default((AdbSession.Companion)AdbSession.Companion, (AdbSessionHost)new AdbSessionHost(), null, null, (int)6, null);
                }
                if ((object = (this$0.adbSession = adbSession)) == null) break block4;
                AdbSession it = object;
                boolean bl = false;
                DirectAccessConnectionManager directAccessConnectionManager = DirectAccessConnectionManagerKt.DirectAccessConnectionManager(CoroutineUtilsKt.createChildScope$default((CoroutineScope)this$0.getScope(), (boolean)true, null, (int)2, null), it, true, (Function0<String>)((Function0)() -> DirectAccessCliSettings.connectionManager_delegate$lambda$0$0$0(this$0)), (Channel)this$0.getChannel(), this$0.getReservationManager(), this$0.forwardingDaemonFactory, this$0.streamOpenerFactory);
                object = directAccessConnectionManager;
                if (directAccessConnectionManager != null) break block5;
            }
            throw new InitializationFailedException("Failed to initialize ADB");
        }
        return object;
    }

    private static final String connectionManager_delegate$lambda$0$0$0(DirectAccessCliSettings this$0) {
        return this$0.accessToken;
    }

    static {
        Map map2;
        Companion = new Companion(null);
        Map it = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        ReservationAction.Companion.register(it);
        ConnectionAction.Companion.register(it);
        ARG_TO_ACTION = map2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings$Companion;", "", "<init>", "()V", "ARG_TO_ACTION", "", "", "Lkotlin/Function1;", "Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings;", "Lcom/google/services/firebase/directaccess/client/cli/action/DirectAccessAction;", "Lcom/google/services/firebase/directaccess/client/cli/ActionMapValue;", "directaccess-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

