/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client;

import com.google.cloud.devicestreaming.v1.DeviceSession;
import com.google.devtools.testing.v1.AndroidDevice;
import com.google.devtools.testing.v1.CancelDeviceSessionRequest;
import com.google.devtools.testing.v1.CreateDeviceSessionRequest;
import com.google.devtools.testing.v1.DeviceSession;
import com.google.devtools.testing.v1.DirectAccessServiceGrpc;
import com.google.devtools.testing.v1.GetDeviceSessionRequest;
import com.google.devtools.testing.v1.ListDeviceSessionsRequest;
import com.google.devtools.testing.v1.ListDeviceSessionsResponse;
import com.google.devtools.testing.v1.UpdateDeviceSessionRequest;
import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManager;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManager2Kt;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManagerImpl;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManagerKt;
import com.google.services.firebase.directaccess.client.ReservationUtilKt;
import com.google.services.firebase.directaccess.client.TokenCallCredentials;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.MetadataUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dH\u0016J\u001a\u0010\u001e\u001a\n \u0010*\u0004\u0018\u00010\u001f0\u001f2\b\b\u0002\u0010 \u001a\u00020\u0003H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'H\u0016J(\u0010(\u001a\n \u0010*\u0004\u0018\u00010)0)2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J \u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u0016012\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0010\u00102\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J8\u00103\u001a\u00020\"2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010#\u001a\u00020\u00032\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001806H\u0082@\u00a2\u0006\u0002\u00107J\u001a\u00108\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00032\b\b\u0002\u00109\u001a\u00020\u0016H\u0002J\b\u0010:\u001a\u00020;H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManagerImpl;", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager;", "cloudProjectId", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "channel", "Lio/grpc/Channel;", "oAuthTokenFetcher", "Lkotlin/Function0;", "callCreds", "Lio/grpc/CallCredentials;", "<init>", "(Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;Lio/grpc/Channel;Lkotlin/jvm/functions/Function0;Lio/grpc/CallCredentials;)V", "directAccessStub", "Lcom/google/devtools/testing/v1/DirectAccessServiceGrpc$DirectAccessServiceBlockingStub;", "kotlin.jvm.PlatformType", "getDirectAccessStub", "()Lcom/google/devtools/testing/v1/DirectAccessServiceGrpc$DirectAccessServiceBlockingStub;", "reservationFlowMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/google/cloud/devicestreaming/v1/DeviceSession;", "gracePeriodReservationsMap", "", "createReservation", "model", "apiLevel", "listReservations", "", "createListSessionRequest", "Lcom/google/devtools/testing/v1/ListDeviceSessionsRequest;", "nextPageToken", "setGracePeriod", "", "reservationName", "cancelReservationImmediately", "cancelReservation", "withGracePeriod", "", "createUpdateDeviceSessionRequest", "Lcom/google/devtools/testing/v1/UpdateDeviceSessionRequest;", "reservation", "duration", "Ljava/time/Duration;", "type", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager$ReservationExtendType;", "extendReservation", "fetchReservationFlow", "Lkotlinx/coroutines/flow/StateFlow;", "maybeRestoreExpireTimeOnReconnect", "updateReservationUntilClosed", "stateFlow", "nextIterationDelay", "Lkotlin/Function1;", "(Lkotlinx/coroutines/flow/MutableStateFlow;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchReservation", "previousReservation", "metadataInterceptor", "Lio/grpc/ClientInterceptor;", "directaccess-client"})
@SourceDebugExtension(value={"SMAP\nDirectAccessReservationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectAccessReservationManager.kt\ncom/google/services/firebase/directaccess/client/DirectAccessReservationManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,313:1\n1563#2:314\n1634#2,3:315\n1#3:318\n230#4,5:319\n198#4,5:324\n*S KotlinDebug\n*F\n+ 1 DirectAccessReservationManager.kt\ncom/google/services/firebase/directaccess/client/DirectAccessReservationManagerImpl\n*L\n119#1:314\n119#1:315,3\n218#1:319,5\n274#1:324,5\n*E\n"})
public final class DirectAccessReservationManagerImpl
implements DirectAccessReservationManager {
    @NotNull
    private final String cloudProjectId;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CallCredentials callCreds;
    private final DirectAccessServiceGrpc.DirectAccessServiceBlockingStub directAccessStub;
    @NotNull
    private final ConcurrentHashMap<String, MutableStateFlow<DeviceSession>> reservationFlowMap;
    @NotNull
    private final ConcurrentHashMap<String, Long> gracePeriodReservationsMap;

    public DirectAccessReservationManagerImpl(@NotNull String cloudProjectId, @NotNull CoroutineScope scope, @NotNull Channel channel, @NotNull Function0<String> oAuthTokenFetcher, @NotNull CallCredentials callCreds) {
        Intrinsics.checkNotNullParameter((Object)cloudProjectId, (String)"cloudProjectId");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(oAuthTokenFetcher, (String)"oAuthTokenFetcher");
        Intrinsics.checkNotNullParameter((Object)callCreds, (String)"callCreds");
        this.cloudProjectId = cloudProjectId;
        this.scope = scope;
        this.callCreds = callCreds;
        this.directAccessStub = DirectAccessServiceGrpc.newBlockingStub((Channel)channel);
        this.reservationFlowMap = new ConcurrentHashMap();
        this.gracePeriodReservationsMap = new ConcurrentHashMap();
    }

    public /* synthetic */ DirectAccessReservationManagerImpl(String string, CoroutineScope coroutineScope, Channel channel, Function0 function0, CallCredentials callCredentials, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            callCredentials = new TokenCallCredentials((Function0<String>)function0);
        }
        this(string, coroutineScope, channel, (Function0<String>)function0, callCredentials);
    }

    private final DirectAccessServiceGrpc.DirectAccessServiceBlockingStub getDirectAccessStub() {
        ClientInterceptor[] clientInterceptorArray = new ClientInterceptor[]{this.metadataInterceptor()};
        return (DirectAccessServiceGrpc.DirectAccessServiceBlockingStub)((DirectAccessServiceGrpc.DirectAccessServiceBlockingStub)this.directAccessStub.withCallCredentials(this.callCreds)).withInterceptors(clientInterceptorArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DeviceSession createReservation(@NotNull String model, @NotNull String apiLevel) {
        void $this$createReservation_u24lambda_u240_u240_u240;
        void $this$createReservation_u24lambda_u240_u240;
        AndroidDevice.Builder builder;
        DeviceSession.Builder builder2;
        CreateDeviceSessionRequest.Builder builder3;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
        CreateDeviceSessionRequest.Builder $this$createReservation_u24lambda_u240 = builder3 = CreateDeviceSessionRequest.newBuilder();
        boolean bl = false;
        $this$createReservation_u24lambda_u240.setParent("projects/" + this.cloudProjectId);
        DeviceSession.Builder builder4 = builder2 = com.google.devtools.testing.v1.DeviceSession.newBuilder();
        CreateDeviceSessionRequest.Builder builder5 = $this$createReservation_u24lambda_u240;
        boolean bl2 = false;
        AndroidDevice.Builder builder6 = builder = AndroidDevice.newBuilder();
        void var13_12 = $this$createReservation_u24lambda_u240_u240;
        boolean bl3 = false;
        $this$createReservation_u24lambda_u240_u240_u240.setAndroidModelId(model);
        $this$createReservation_u24lambda_u240_u240_u240.setAndroidVersionId(apiLevel);
        var13_12.setAndroidDevice(builder.build());
        builder5.setDeviceSession(builder2.build());
        CreateDeviceSessionRequest createDeviceSessionRequest = builder3.build();
        com.google.devtools.testing.v1.DeviceSession deviceSession = this.getDirectAccessStub().createDeviceSession(createDeviceSessionRequest);
        Intrinsics.checkNotNullExpressionValue((Object)deviceSession, (String)"createDeviceSession(...)");
        return ReservationUtilKt.update(deviceSession);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DeviceSession> listReservations() {
        void $this$mapTo$iv$iv;
        List reservationsList = new ArrayList();
        String nextPageToken = "";
        do {
            ListDeviceSessionsResponse listReservationResponse = this.getDirectAccessStub().listDeviceSessions(this.createListSessionRequest(nextPageToken));
            List list = listReservationResponse.getDeviceSessionsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDeviceSessionsList(...)");
            reservationsList.addAll(list);
            Intrinsics.checkNotNullExpressionValue((Object)listReservationResponse.getNextPageToken(), (String)"getNextPageToken(...)");
        } while (!StringsKt.isBlank((CharSequence)nextPageToken));
        Iterable $this$map$iv = reservationsList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.google.devtools.testing.v1.DeviceSession deviceSession = (com.google.devtools.testing.v1.DeviceSession)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ReservationUtilKt.update((com.google.devtools.testing.v1.DeviceSession)it));
        }
        return (List)destination$iv$iv;
    }

    private final ListDeviceSessionsRequest createListSessionRequest(String nextPageToken) {
        ListDeviceSessionsRequest.Builder builder;
        ListDeviceSessionsRequest.Builder $this$createListSessionRequest_u24lambda_u240 = builder = ListDeviceSessionsRequest.newBuilder();
        boolean bl = false;
        $this$createListSessionRequest_u24lambda_u240.setParent("projects/" + this.cloudProjectId);
        $this$createListSessionRequest_u24lambda_u240.setPageToken(nextPageToken);
        $this$createListSessionRequest_u24lambda_u240.setPageSize(500);
        return builder.build();
    }

    static /* synthetic */ ListDeviceSessionsRequest createListSessionRequest$default(DirectAccessReservationManagerImpl directAccessReservationManagerImpl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return directAccessReservationManagerImpl.createListSessionRequest(string);
    }

    private final void setGracePeriod(String reservationName2) {
        if (!DirectAccessReservationManager2Kt.getExpiryLessThanGracePeriod(this.fetchReservationFlow(reservationName2))) {
            ((Map)this.gracePeriodReservationsMap).put(reservationName2, ((DeviceSession)this.fetchReservationFlow(reservationName2).getValue()).getExpireTime().getSeconds());
            this.extendReservation(reservationName2, DirectAccessReservationManager2Kt.getGRACE_PERIOD_DURATION(), DirectAccessReservationManager.ReservationExtendType.TTL);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cancelReservationImmediately(String reservationName2) {
        void $this$cancelReservationImmediately_u24lambda_u240;
        CancelDeviceSessionRequest.Builder builder;
        CancelDeviceSessionRequest.Builder builder2 = builder = CancelDeviceSessionRequest.newBuilder();
        DirectAccessServiceGrpc.DirectAccessServiceBlockingStub directAccessServiceBlockingStub = this.getDirectAccessStub();
        boolean bl = false;
        $this$cancelReservationImmediately_u24lambda_u240.setName(reservationName2);
        directAccessServiceBlockingStub.cancelDeviceSession(builder.build());
        this.gracePeriodReservationsMap.remove(reservationName2);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, reservationName2, null){
            int label;
            final /* synthetic */ DirectAccessReservationManagerImpl this$0;
            final /* synthetic */ String $reservationName;
            {
                this.this$0 = $receiver;
                this.$reservationName = $reservationName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MutableStateFlow mutableStateFlow = (MutableStateFlow)DirectAccessReservationManagerImpl.access$getReservationFlowMap$p(this.this$0).remove(this.$reservationName);
                        if (mutableStateFlow == null) break;
                        MutableStateFlow mutableStateFlow2 = mutableStateFlow;
                        DirectAccessReservationManagerImpl directAccessReservationManagerImpl = this.this$0;
                        String string = this.$reservationName;
                        MutableStateFlow it = mutableStateFlow2;
                        boolean bl = false;
                        this.label = 1;
                        Object object3 = DirectAccessReservationManagerImpl.access$updateReservationUntilClosed(directAccessReservationManagerImpl, it, string, cancelReservationImmediately.2::invokeSuspend$lambda$0$0, (Continuation)this);
                        if (object3 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        boolean bl = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final long invokeSuspend$lambda$0$0(DeviceSession it) {
                return TimeUnit.SECONDS.toMillis(1L);
            }
        }), (int)3, null);
    }

    @Override
    public void cancelReservation(@NotNull String reservationName2, boolean withGracePeriod) {
        Intrinsics.checkNotNullParameter((Object)reservationName2, (String)"reservationName");
        if (withGracePeriod && ((DeviceSession)this.fetchReservationFlow(reservationName2).getValue()).getState() == DeviceSession.SessionState.ACTIVE) {
            this.setGracePeriod(reservationName2);
        } else {
            this.cancelReservationImmediately(reservationName2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final UpdateDeviceSessionRequest createUpdateDeviceSessionRequest(DeviceSession reservation, Duration duration, DirectAccessReservationManager.ReservationExtendType type) {
        void $this$createUpdateDeviceSessionRequest_u24lambda_u240_u241;
        DeviceSession.Builder $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240;
        DeviceSession.Builder builder;
        UpdateDeviceSessionRequest.Builder builder2;
        UpdateDeviceSessionRequest.Builder $this$createUpdateDeviceSessionRequest_u24lambda_u240 = builder2 = UpdateDeviceSessionRequest.newBuilder();
        boolean bl = false;
        DeviceSession.Builder builder3 = builder = $this$createUpdateDeviceSessionRequest_u24lambda_u240.getDeviceSessionBuilder();
        UpdateDeviceSessionRequest.Builder builder4 = $this$createUpdateDeviceSessionRequest_u24lambda_u240;
        boolean bl2 = false;
        $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240.setName(reservation.getName());
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                void $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240_u240;
                Timestamp.Builder builder5;
                Timestamp.Builder builder6 = builder5 = $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240.getExpireTimeBuilder();
                void var13_15 = $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240;
                boolean bl3 = false;
                $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240_u240.setSeconds(reservation.getExpireTime().getSeconds() + duration.getSeconds());
                var13_15.setExpireTime(builder5.build());
                break;
            }
            case 2: {
                void $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240_u241;
                Duration.Builder builder7;
                Duration.Builder $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240_u240 = builder7 = $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240.getTtlBuilder();
                void var13_16 = $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240;
                boolean bl4 = false;
                $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240_u241.setSeconds(duration.getSeconds());
                var13_16.setTtl(builder7.build());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        builder4.setDeviceSession(builder.build());
        $this$createUpdateDeviceSessionRequest_u24lambda_u240_u240 = builder = FieldMask.newBuilder();
        builder4 = $this$createUpdateDeviceSessionRequest_u24lambda_u240;
        boolean bl5 = false;
        $this$createUpdateDeviceSessionRequest_u24lambda_u240_u241.addPaths(switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> "expireTime";
            case 2 -> "ttl";
            default -> throw new NoWhenBranchMatchedException();
        });
        builder4.setUpdateMask(builder.build());
        return builder2.build();
    }

    @Override
    public void extendReservation(@NotNull String reservationName2, @NotNull Duration duration, @NotNull DirectAccessReservationManager.ReservationExtendType type) {
        DeviceSession nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)reservationName2, (String)"reservationName");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        StateFlow<DeviceSession> stateFlow2 = this.fetchReservationFlow(reservationName2);
        com.google.devtools.testing.v1.DeviceSession deviceSession = this.getDirectAccessStub().updateDeviceSession(this.createUpdateDeviceSessionRequest((DeviceSession)stateFlow2.getValue(), duration, type));
        Intrinsics.checkNotNullExpressionValue((Object)deviceSession, (String)"updateDeviceSession(...)");
        DeviceSession extendedReservation = ReservationUtilKt.update(deviceSession);
        Intrinsics.checkNotNull(stateFlow2, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.MutableStateFlow<com.google.cloud.devicestreaming.v1.DeviceSession>");
        MutableStateFlow $this$update$iv = (MutableStateFlow)stateFlow2;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            DeviceSession it = (DeviceSession)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = extendedReservation)));
    }

    @Override
    @NotNull
    public StateFlow<DeviceSession> fetchReservationFlow(@NotNull String reservationName2) {
        StateFlow stateFlow2;
        Intrinsics.checkNotNullParameter((Object)reservationName2, (String)"reservationName");
        MutableStateFlow<DeviceSession> mutableStateFlow = this.reservationFlowMap.get(reservationName2);
        if (mutableStateFlow != null) {
            stateFlow2 = (StateFlow)mutableStateFlow;
        } else {
            DirectAccessReservationManagerImpl $this$fetchReservationFlow_u24lambda_u240 = this;
            boolean bl = false;
            MutableStateFlow stateFlow3 = StateFlowKt.MutableStateFlow((Object)DirectAccessReservationManagerImpl.fetchReservation$default($this$fetchReservationFlow_u24lambda_u240, reservationName2, null, 2, null));
            ((Map)$this$fetchReservationFlow_u24lambda_u240.reservationFlowMap).put(reservationName2, stateFlow3);
            BuildersKt.launch$default((CoroutineScope)$this$fetchReservationFlow_u24lambda_u240.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$fetchReservationFlow_u24lambda_u240, (MutableStateFlow<DeviceSession>)stateFlow3, reservationName2, null){
                int label;
                final /* synthetic */ DirectAccessReservationManagerImpl $this_run;
                final /* synthetic */ MutableStateFlow<DeviceSession> $stateFlow;
                final /* synthetic */ String $reservationName;
                {
                    this.$this_run = $receiver;
                    this.$stateFlow = $stateFlow;
                    this.$reservationName = $reservationName;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DirectAccessReservationManagerImpl.access$updateReservationUntilClosed(this.$this_run, this.$stateFlow, this.$reservationName, fetchReservationFlow.1.1::invokeSuspend$lambda$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final long invokeSuspend$lambda$0(DeviceSession newReservation2) {
                    long maxDelayTimeMillis = DirectAccessReservationManager2Kt.isActive(newReservation2) ? TimeUnit.MINUTES.toMillis(1L) : TimeUnit.SECONDS.toMillis(2L);
                    long availableTimeMillis = TimeUnit.SECONDS.toMillis(newReservation2.getExpireTime().getSeconds()) - System.currentTimeMillis();
                    return RangesKt.coerceIn((long)availableTimeMillis, (long)TimeUnit.SECONDS.toMillis(1L), (long)maxDelayTimeMillis);
                }
            }), (int)3, null);
            BuildersKt.launch$default((CoroutineScope)$this$fetchReservationFlow_u24lambda_u240.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableStateFlow<DeviceSession>)stateFlow3, $this$fetchReservationFlow_u24lambda_u240, reservationName2, null){
                int label;
                final /* synthetic */ MutableStateFlow<DeviceSession> $stateFlow;
                final /* synthetic */ DirectAccessReservationManagerImpl $this_run;
                final /* synthetic */ String $reservationName;
                {
                    this.$stateFlow = $stateFlow;
                    this.$this_run = $receiver;
                    this.$reservationName = $reservationName;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)this.$stateFlow), (Function2)((Function2)new Function2<DeviceSession, Continuation<? super Boolean>, Object>(null){
                                int label;
                                /* synthetic */ Object L$0;

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            DeviceSession it = (DeviceSession)this.L$0;
                                            DeviceSession.SessionState sessionState = it.getState();
                                            Intrinsics.checkNotNullExpressionValue((Object)sessionState, (String)"getState(...)");
                                            return Boxing.boxBoolean((!DirectAccessReservationManager2Kt.isClosed(sessionState) ? 1 : 0) != 0);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(DeviceSession p1, Continuation<? super Boolean> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            })), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            DirectAccessReservationManagerImpl.access$getGracePeriodReservationsMap$p(this.$this_run).remove(this.$reservationName);
                            DirectAccessReservationManagerImpl.access$getReservationFlowMap$p(this.$this_run).remove(this.$reservationName);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            stateFlow2 = (StateFlow)stateFlow3;
        }
        return stateFlow2;
    }

    @Override
    public void maybeRestoreExpireTimeOnReconnect(@NotNull String reservationName2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reservationName2, (String)"reservationName");
            Long l = this.gracePeriodReservationsMap.remove(reservationName2);
            if (l == null) break block1;
            long it = ((Number)l).longValue();
            boolean bl = false;
            StateFlow<DeviceSession> reservationFlow = this.fetchReservationFlow(reservationName2);
            if (DirectAccessReservationManager2Kt.getExpiryLessThanGracePeriod(reservationFlow)) {
                Duration duration = Duration.ofSeconds(it - ((DeviceSession)reservationFlow.getValue()).getExpireTime().getSeconds());
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
                this.extendReservation(reservationName2, duration, DirectAccessReservationManager.ReservationExtendType.EXTEND);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateReservationUntilClosed(MutableStateFlow<DeviceSession> var1_1, String var2_2, Function1<? super DeviceSession, Long> var3_3, Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateReservationUntilClosed.1)) ** GOTO lbl-1000
        var13_5 = $completion;
        if ((var13_5.label & -2147483648) != 0) {
            var13_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ DirectAccessReservationManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DirectAccessReservationManagerImpl.access$updateReservationUntilClosed(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl13:
                // 2 sources

                while (true) {
                    $this$updateAndGet$iv = stateFlow;
                    $i$f$updateAndGet = false;
                    while (true) {
                        prevValue$iv = $this$updateAndGet$iv.getValue();
                        currentReservation = (DeviceSession)prevValue$iv;
                        $i$a$-updateAndGet-DirectAccessReservationManagerImpl$updateReservationUntilClosed$newReservation$1 = false;
                        $continuation.L$0 = stateFlow;
                        $continuation.L$1 = reservationName;
                        $continuation.L$2 = nextIterationDelay;
                        $continuation.L$3 = $this$updateAndGet$iv;
                        $continuation.L$4 = prevValue$iv;
                        $continuation.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DeviceSession>, Object>(this, reservationName, currentReservation, null){
                            int label;
                            final /* synthetic */ DirectAccessReservationManagerImpl this$0;
                            final /* synthetic */ String $reservationName;
                            final /* synthetic */ DeviceSession $currentReservation;
                            {
                                this.this$0 = $receiver;
                                this.$reservationName = $reservationName;
                                this.$currentReservation = $currentReservation;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        return DirectAccessReservationManagerImpl.access$fetchReservation(this.this$0, this.$reservationName, this.$currentReservation);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super DeviceSession> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation);
                        if (v0 != var14_7) continue;
                        return var14_7;
                    }
                    break;
                }
            }
            case 1: {
                $i$f$updateAndGet = false;
                $i$a$-updateAndGet-DirectAccessReservationManagerImpl$updateReservationUntilClosed$newReservation$1 = false;
                prevValue$iv = $continuation.L$4;
                $this$updateAndGet$iv = (MutableStateFlow)$continuation.L$3;
                nextIterationDelay = (Function1)$continuation.L$2;
                reservationName = (String)$continuation.L$1;
                stateFlow = (MutableStateFlow)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                if (!$this$updateAndGet$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (DeviceSession)v0))) ** continue;
                newReservation = nextValue$iv;
                v1 = newReservation.getState();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getState(...)");
                if (DirectAccessReservationManager2Kt.isClosed(v1)) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = stateFlow;
                $continuation.L$1 = reservationName;
                $continuation.L$2 = nextIterationDelay;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v2 = DelayKt.delay((long)((Number)nextIterationDelay.invoke((Object)newReservation)).longValue(), (Continuation)$continuation);
                if (v2 == var14_7) {
                    return var14_7;
                }
                ** GOTO lbl62
            }
            case 2: {
                nextIterationDelay = (Function1)$continuation.L$2;
                reservationName = (String)$continuation.L$1;
                stateFlow = (MutableStateFlow)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl62:
                // 2 sources

                ** continue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final DeviceSession fetchReservation(String reservationName2, DeviceSession previousReservation) {
        DeviceSession deviceSession;
        try {
            void $this$fetchReservation_u24lambda_u240;
            GetDeviceSessionRequest.Builder builder;
            GetDeviceSessionRequest.Builder builder2 = builder = GetDeviceSessionRequest.newBuilder();
            DirectAccessServiceGrpc.DirectAccessServiceBlockingStub directAccessServiceBlockingStub = this.getDirectAccessStub();
            boolean bl = false;
            $this$fetchReservation_u24lambda_u240.setName(reservationName2);
            com.google.devtools.testing.v1.DeviceSession deviceSession2 = directAccessServiceBlockingStub.getDeviceSession(builder.build());
            Intrinsics.checkNotNullExpressionValue((Object)deviceSession2, (String)"getDeviceSession(...)");
            deviceSession = ReservationUtilKt.update(deviceSession2);
        }
        catch (StatusRuntimeException e) {
            DeviceSession.Builder builder;
            DirectAccessReservationManagerKt.access$getLogger().log(Level.WARNING, "Failed to fetch reservation " + reservationName2, e);
            DeviceSession.Builder $this$fetchReservation_u24lambda_u241 = builder = previousReservation.toBuilder();
            boolean bl = false;
            $this$fetchReservation_u24lambda_u241.setState(DeviceSession.SessionState.SESSION_STATE_UNSPECIFIED);
            DeviceSession deviceSession3 = builder.build();
            Intrinsics.checkNotNull((Object)deviceSession3);
            deviceSession = deviceSession3;
        }
        return deviceSession;
    }

    static /* synthetic */ DeviceSession fetchReservation$default(DirectAccessReservationManagerImpl directAccessReservationManagerImpl, String string, DeviceSession deviceSession, int n, Object object) {
        if ((n & 2) != 0) {
            DeviceSession deviceSession2 = DeviceSession.newBuilder().build();
            Intrinsics.checkNotNullExpressionValue((Object)deviceSession2, (String)"build(...)");
            deviceSession = deviceSession2;
        }
        return directAccessReservationManagerImpl.fetchReservation(string, deviceSession);
    }

    private final ClientInterceptor metadataInterceptor() {
        Metadata metadata;
        Metadata $this$metadataInterceptor_u24lambda_u240 = metadata = new Metadata();
        boolean bl = false;
        $this$metadataInterceptor_u24lambda_u240.put(Metadata.Key.of((String)"X-Goog-User-Project", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.cloudProjectId);
        ClientInterceptor clientInterceptor = MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata);
        Intrinsics.checkNotNullExpressionValue((Object)clientInterceptor, (String)"newAttachHeadersInterceptor(...)");
        return clientInterceptor;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getReservationFlowMap$p(DirectAccessReservationManagerImpl $this) {
        return $this.reservationFlowMap;
    }

    public static final /* synthetic */ Object access$updateReservationUntilClosed(DirectAccessReservationManagerImpl $this, MutableStateFlow stateFlow2, String reservationName2, Function1 nextIterationDelay, Continuation $completion) {
        return $this.updateReservationUntilClosed((MutableStateFlow<DeviceSession>)stateFlow2, reservationName2, (Function1<? super DeviceSession, Long>)nextIterationDelay, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getGracePeriodReservationsMap$p(DirectAccessReservationManagerImpl $this) {
        return $this.gracePeriodReservationsMap;
    }

    public static final /* synthetic */ DeviceSession access$fetchReservation(DirectAccessReservationManagerImpl $this, String reservationName2, DeviceSession previousReservation) {
        return $this.fetchReservation(reservationName2, previousReservation);
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DirectAccessReservationManager.ReservationExtendType.values().length];
            try {
                nArray[DirectAccessReservationManager.ReservationExtendType.EXTEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DirectAccessReservationManager.ReservationExtendType.TTL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

