/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014R\u001e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/google/gct/directaccess/ui/UsageProgressBar;", "Ljavax/swing/JPanel;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "percentage", "Lkotlinx/coroutines/flow/StateFlow;", "", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/flow/StateFlow;)V", "getPercentage", "()Lkotlinx/coroutines/flow/StateFlow;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "directaccess"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nUsageProgressBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageProgressBar.kt\ncom/google/gct/directaccess/ui/UsageProgressBar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class UsageProgressBar
extends JPanel {
    @VisibleForTesting
    @NotNull
    private final StateFlow<Double> percentage;
    public static final int $stable = 8;

    public UsageProgressBar(@NotNull CoroutineScope scope, @NotNull StateFlow<Double> percentage) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(percentage, (String)"percentage");
        this.percentage = percentage;
        this.setPreferredSize(new Dimension(0, JBUIScale.scale((int)30)));
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ UsageProgressBar this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getPercentage().collect(new FlowCollector(){

                            public final Object emit(Double it, Continuation<? super Unit> $completion) {
                                this$0.repaint();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final StateFlow<Double> getPercentage() {
        return this.percentage;
    }

    @Override
    protected void paintComponent(@Nullable Graphics g) {
        int n;
        super.paintComponent(g);
        BufferedImage bufferedImage = ImageUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage buffImg = bufferedImage;
        Graphics2D g2d = buffImg.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int gap = JBUIScale.scale((int)3);
        int diameter = this.getHeight() - 2 * gap;
        int radius = diameter / 2;
        int barWidth = this.getWidth() - 2 * (gap + radius);
        g2d.setColor((Color)JBColor.WHITE);
        g2d.fillOval(gap, gap, diameter, diameter);
        g2d.fillRect(radius + gap, gap, barWidth, diameter);
        g2d.fillOval(this.getWidth() - diameter - gap, gap, diameter, diameter);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.setColor((Color)JBColor.GRAY);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        Double p = (Double)this.percentage.getValue();
        int effectiveBarWidth = this.getWidth() - 2 * gap - radius;
        Double d = p;
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            n = (int)((double)(gap + radius) + p * (double)effectiveBarWidth);
        } else {
            n = 0;
        }
        int activeBarWidth = n;
        g2d.setColor((Color)JBColor.BLUE);
        g2d.fillRect(0, 0, activeBarWidth, this.getHeight());
        g2d.setColor(this.getBackground());
        g2d.fillRect(RangesKt.coerceAtLeast((int)activeBarWidth, (int)(gap + radius)), 0, gap, this.getHeight());
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        ((Graphics2D)g).drawImage(buffImg, 0, 0, this.getWidth(), this.getHeight(), null);
    }
}

