/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000e@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/google/gct/directaccess/analytics/DirectAccessFeatureSurveys;", "", "calendar", "Lkotlin/Function0;", "Ljava/util/Calendar;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getCalendar", "()Lkotlin/jvm/functions/Function0;", "value", "", "lastDayWithConnection", "setLastDayWithConnection", "(J)V", "", "isSurveyDone", "setSurveyDone", "(Z)V", "daysWithConnection", "setDaysWithConnection", "lock", "trackConnection", "", "trackDisconnection", "getDayNumber", "triggerSurvey", "directaccess"})
@StabilityInferred(parameters=0)
public final class DirectAccessFeatureSurveys {
    @NotNull
    private final Function0<Calendar> calendar;
    private long lastDayWithConnection;
    private boolean isSurveyDone;
    private long daysWithConnection;
    @NotNull
    private final Object lock;
    public static final int $stable = 8;

    public DirectAccessFeatureSurveys(@NotNull Function0<? extends Calendar> calendar) {
        Intrinsics.checkNotNullParameter(calendar, (String)"calendar");
        this.calendar = calendar;
        this.lastDayWithConnection = PropertiesComponent.getInstance().getLong("direct.access.connection.last.day", 0L);
        this.isSurveyDone = PropertiesComponent.getInstance().getBoolean("direct.access.survey.done", false);
        this.daysWithConnection = PropertiesComponent.getInstance().getLong("direct.access.connection.days", 0L);
        this.lock = new Object();
    }

    public /* synthetic */ DirectAccessFeatureSurveys(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = DirectAccessFeatureSurveys::_init_$lambda$0;
        }
        this((Function0<? extends Calendar>)function0);
    }

    @NotNull
    public final Function0<Calendar> getCalendar() {
        return this.calendar;
    }

    private final void setLastDayWithConnection(long value) {
        this.lastDayWithConnection = value;
        PropertiesComponent.getInstance().setValue("direct.access.connection.last.day", String.valueOf(value));
    }

    private final void setSurveyDone(boolean value) {
        this.isSurveyDone = value;
        PropertiesComponent.getInstance().setValue("direct.access.survey.done", value);
    }

    private final void setDaysWithConnection(long value) {
        this.daysWithConnection = value;
        PropertiesComponent.getInstance().setValue("direct.access.connection.days", String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trackConnection() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.isSurveyDone || this.daysWithConnection >= 5L) {
                return;
            }
            long currentDayNumber = this.getDayNumber();
            if (currentDayNumber == this.lastDayWithConnection) {
                return;
            }
            this.setLastDayWithConnection(currentDayNumber);
            this.setDaysWithConnection(this.daysWithConnection + 1L);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trackDisconnection() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.isSurveyDone || this.daysWithConnection < 5L) {
                return;
            }
            this.setSurveyDone(true);
            Unit unit = Unit.INSTANCE;
        }
        this.triggerSurvey();
    }

    private final long getDayNumber() {
        Calendar currentCalendar = (Calendar)this.calendar.invoke();
        long date = currentCalendar.getTime().getTime();
        return (date + (long)currentCalendar.getTimeZone().getOffset(date)) / TimeUnit.DAYS.toMillis(1L);
    }

    private final void triggerSurvey() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Feature Survey");
        if (notificationGroup == null) {
            return;
        }
        NotificationGroup notificationGroup2 = notificationGroup;
        Notification notification = notificationGroup2.createNotification("Device Streaming feature surveys", "Would you like to take a brief survey based on your recent activity to help us improve Android Studio?", NotificationType.INFORMATION);
        notification.addAction((AnAction)new NotificationAction(){

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                BrowserUtil.browse((String)"https://forms.gle/tzvZrJ6oQ5cwM9j9A");
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> DirectAccessFeatureSurveys.triggerSurvey$lambda$0(notification));
    }

    private static final Calendar _init_$lambda$0() {
        return Calendar.getInstance();
    }

    private static final void triggerSurvey$lambda$0(Notification $notification) {
        Notifications.Bus.notify((Notification)$notification);
    }

    public DirectAccessFeatureSurveys() {
        this(null, 1, null);
    }
}

