/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util.jcommander;

import com.android.tools.smali.util.WrappedIndentingWriter;
import com.android.tools.smali.util.jcommander.ExtendedCommands;
import com.android.tools.smali.util.jcommander.ExtendedParameters;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameters;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class HelpFormatter {
    private int width = 80;

    @Nonnull
    public HelpFormatter width(int width) {
        this.width = width;
        return this;
    }

    @Nonnull
    private static ExtendedParameters getExtendedParameters(JCommander jc) {
        ExtendedParameters anno = jc.getObjects().get(0).getClass().getAnnotation(ExtendedParameters.class);
        if (anno == null) {
            throw new IllegalStateException("All commands should have an ExtendedParameters annotation");
        }
        return anno;
    }

    @Nonnull
    private static List<String> getCommandAliases(JCommander jc) {
        return Lists.newArrayList((Object[])HelpFormatter.getExtendedParameters(jc).commandAliases());
    }

    private static boolean includeParametersInUsage(@Nonnull JCommander jc) {
        return HelpFormatter.getExtendedParameters(jc).includeParametersInUsage();
    }

    @Nonnull
    private static String getPostfixDescription(@Nonnull JCommander jc) {
        return HelpFormatter.getExtendedParameters(jc).postfixDescription();
    }

    private int getParameterArity(ParameterDescription param) {
        if (param.getParameter().arity() > 0) {
            return param.getParameter().arity();
        }
        Class type = param.getParameterized().getType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            return 0;
        }
        return 1;
    }

    private List<ParameterDescription> getSortedParameters(JCommander jc) {
        ArrayList parameters = Lists.newArrayList((Iterable)jc.getParameters());
        final Pattern pattern = Pattern.compile("^-*(.*)$");
        Collections.sort(parameters, new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription o1, ParameterDescription o2) {
                Matcher matcher = pattern.matcher(o1.getParameter().names()[0]);
                if (!matcher.matches()) {
                    throw new IllegalStateException();
                }
                String s1 = matcher.group(1);
                matcher = pattern.matcher(o2.getParameter().names()[0]);
                if (!matcher.matches()) {
                    throw new IllegalStateException();
                }
                String s2 = matcher.group(1);
                return s1.compareTo(s2);
            }
        });
        return parameters;
    }

    @Nonnull
    public String format(JCommander ... jc) {
        return this.format(Arrays.asList(jc));
    }

    @Nonnull
    public String format(@Nonnull List<JCommander> commandHierarchy) {
        try {
            String postfixDescription;
            StringWriter stringWriter = new StringWriter();
            WrappedIndentingWriter writer = new WrappedIndentingWriter((Writer)stringWriter, this.width - 5, this.width);
            JCommander leafJc = (JCommander)Iterables.getLast(commandHierarchy);
            writer.write("usage:");
            writer.indent(2);
            for (JCommander jc : commandHierarchy) {
                writer.write(" ");
                writer.write(ExtendedCommands.commandName(jc));
            }
            if (HelpFormatter.includeParametersInUsage(leafJc)) {
                for (ParameterDescription param : leafJc.getParameters()) {
                    if (param.getParameter().hidden()) continue;
                    writer.write(" [");
                    writer.write(param.getParameter().getParameter().names()[0]);
                    writer.write("]");
                }
            } else if (!leafJc.getParameters().isEmpty()) {
                writer.write(" [<options>]");
            }
            if (!leafJc.getCommands().isEmpty()) {
                writer.write(" [<command [<args>]]");
            }
            if (leafJc.getMainParameter() != null) {
                String[] argumentNames = ExtendedCommands.parameterArgumentNames(leafJc.getMainParameter());
                if (argumentNames.length == 0) {
                    writer.write(" <args>");
                } else {
                    String argumentName = argumentNames[0];
                    boolean writeAngleBrackets = !argumentName.startsWith("<") && !argumentName.startsWith("[");
                    writer.write(" ");
                    if (writeAngleBrackets) {
                        writer.write("<");
                    }
                    writer.write(argumentNames[0]);
                    if (writeAngleBrackets) {
                        writer.write(">");
                    }
                }
            }
            writer.deindent(2);
            String commandDescription = ExtendedCommands.getCommandDescription(leafJc);
            if (commandDescription != null) {
                writer.write("\n");
                writer.write(commandDescription);
            }
            if (!leafJc.getParameters().isEmpty() || leafJc.getMainParameter() != null) {
                writer.write("\n\nOptions:");
                writer.indent(2);
                for (ParameterDescription param : this.getSortedParameters(leafJc)) {
                    if (param.getParameter().hidden()) continue;
                    writer.write("\n");
                    writer.indent(4);
                    if (!param.getNames().isEmpty()) {
                        writer.write(Joiner.on((char)',').join((Object[])param.getParameter().names()));
                    }
                    if (this.getParameterArity(param) > 0) {
                        String[] argumentNames = ExtendedCommands.parameterArgumentNames(param);
                        for (int i = 0; i < this.getParameterArity(param); ++i) {
                            writer.write(" ");
                            if (i < argumentNames.length) {
                                writer.write("<");
                                writer.write(argumentNames[i]);
                                writer.write(">");
                                continue;
                            }
                            writer.write("<arg>");
                        }
                    }
                    if (param.getDescription() != null && !param.getDescription().isEmpty()) {
                        writer.write(" - ");
                        writer.write(param.getDescription());
                    }
                    if (param.getDefault() != null) {
                        String defaultValue = null;
                        if (param.getParameterized().getType() == Boolean.class || param.getParameterized().getType() == Boolean.TYPE) {
                            if (((Boolean)param.getDefault()).booleanValue()) {
                                defaultValue = "True";
                            }
                        } else if (List.class.isAssignableFrom(param.getParameterized().getType())) {
                            if (!((List)param.getDefault()).isEmpty()) {
                                defaultValue = param.getDefault().toString();
                            }
                        } else {
                            defaultValue = param.getDefault().toString();
                        }
                        if (defaultValue != null) {
                            writer.write(" (default: ");
                            writer.write(defaultValue);
                            writer.write(")");
                        }
                    }
                    writer.deindent(4);
                }
                if (leafJc.getMainParameter() != null) {
                    String[] argumentNames = ExtendedCommands.parameterArgumentNames(leafJc.getMainParameter());
                    writer.write("\n");
                    writer.indent(4);
                    if (argumentNames.length > 0) {
                        writer.write("<");
                        writer.write(argumentNames[0]);
                        writer.write(">");
                    } else {
                        writer.write("<args>");
                    }
                    if (leafJc.getMainParameterDescription() != null) {
                        writer.write(" - ");
                        writer.write(leafJc.getMainParameterDescription());
                    }
                    writer.deindent(4);
                }
                writer.deindent(2);
            }
            if (!leafJc.getCommands().isEmpty()) {
                writer.write("\n\nCommands:");
                writer.indent(2);
                ArrayList entryList = Lists.newArrayList(leafJc.getCommands().entrySet());
                Collections.sort(entryList, new Comparator<Map.Entry<String, JCommander>>(){

                    @Override
                    public int compare(Map.Entry<String, JCommander> o1, Map.Entry<String, JCommander> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                for (Map.Entry entry : entryList) {
                    String commandDesc;
                    String commandName = (String)entry.getKey();
                    JCommander command = (JCommander)entry.getValue();
                    Object arg = command.getObjects().get(0);
                    Parameters parametersAnno = arg.getClass().getAnnotation(Parameters.class);
                    if (parametersAnno.hidden()) continue;
                    writer.write("\n");
                    writer.indent(4);
                    writer.write(commandName);
                    List<String> aliases = HelpFormatter.getCommandAliases(command);
                    if (!aliases.isEmpty()) {
                        writer.write("(");
                        writer.write(Joiner.on((char)',').join(aliases));
                        writer.write(")");
                    }
                    if ((commandDesc = leafJc.getCommandDescription(commandName)) != null) {
                        writer.write(" - ");
                        writer.write(commandDesc);
                    }
                    writer.deindent(4);
                }
                writer.deindent(2);
            }
            if (!(postfixDescription = HelpFormatter.getPostfixDescription(leafJc)).isEmpty()) {
                writer.write("\n\n");
                writer.write(postfixDescription);
            }
            writer.flush();
            return stringWriter.getBuffer().toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

