/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationBaseProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, TEST_OBJECT>
extends CidrContextRunConfigurationProducer<BC, TARGET, CONFIGURATION> {
    protected CidrTestRunConfigurationBaseProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        if (binder == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(0);
        }
        super(binder);
    }

    protected boolean setupConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(3);
        }
        Supplier<Boolean> supplier = () -> this.doSetupConfigurationFromContext(configuration, context, sourceElement);
        return ApplicationManager.getApplication().isUnitTestMode() ? supplier.get().booleanValue() : OCTestExecution.executeWithCachedValuesFast(supplier).booleanValue();
    }

    protected boolean doSetupConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        List<CidrTestScopeElement> objects;
        if (configuration == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(5);
        }
        if (sourceElement == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(6);
        }
        if ((objects = this.findTestObjects(context)).isEmpty()) {
            return false;
        }
        CidrTestScopeElement scope = this.determineScope(objects);
        if (scope == null) {
            return false;
        }
        CidrTestScopeElement testObj = objects.get(0);
        this.setupConfiguration(configuration, scope);
        sourceElement.set((Object)this.getElement(testObj));
        return true;
    }

    @NotNull
    protected abstract PsiElement getElement(@NotNull CidrTestScopeElement var1);

    @Nullable
    protected abstract CidrTestScopeElement determineScope(@NotNull List<CidrTestScopeElement> var1);

    @Nullable
    protected CidrTestScopeElement determineScope(@NotNull ConfigurationContext context) {
        if (context == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(7);
        }
        return this.determineScope(this.findTestObjects(context));
    }

    @Nullable
    protected abstract CidrTestScopeElement determineScope(@NotNull CidrTestScopeElement var1);

    @NotNull
    protected abstract List<CidrTestScopeElement> findTestObjects(@NotNull ConfigurationContext var1);

    public boolean isConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(8);
        }
        if (context == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(9);
        }
        Supplier<Boolean> supplier = () -> {
            CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
            if (delegate == null) {
                return false;
            }
            CidrTestScopeElement scope = this.determineScope(context);
            if (scope == null) {
                return false;
            }
            return delegate.equalTo(scope);
        };
        return ApplicationManager.getApplication().isUnitTestMode() ? supplier.get().booleanValue() : OCTestExecution.executeWithCachedValuesFast(supplier).booleanValue();
    }

    @Contract(value="null -> null")
    @Nullable
    private CidrTestRunConfigurationData getDelegate(CONFIGURATION configuration) {
        return configuration instanceof CidrTestRunConfiguration ? ((CidrTestRunConfiguration)configuration).getTestData() : null;
    }

    protected void setupConfiguration(CONFIGURATION configuration, CidrTestScopeElement scope) {
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
        if (delegate == null) {
            return;
        }
        if (scope.isPatternLike()) {
            delegate.setTestSuite(null);
            delegate.setTestName(null);
            delegate.setTestPattern(scope.getPattern());
            delegate.setTestMode(CidrTestRunConfigurationData.Mode.PATTERN);
        } else {
            delegate.setTestSuite(scope.getSuiteName());
            delegate.setTestName(scope.getTestName());
            delegate.setTestPattern(null);
            delegate.setTestMode(CidrTestRunConfigurationData.Mode.SUITE_TEST);
        }
        String configurationName = scope.getConfigurationName();
        configuration.setName(configurationName == null ? delegate.suggestedName(configuration.suggestNameForTarget()) : configurationName);
    }

    @NotNull
    public List<Location> getLocations(@NotNull ConfigurationContext context) {
        Object[] psiElements;
        Object[] paths;
        SMTRunnerTestTreeView treeView;
        if (context == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(10);
        }
        if ((treeView = (SMTRunnerTestTreeView)SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW.getData(context.getDataContext())) != null && (paths = treeView.getSelectionPaths()) != null && paths.length > 1) {
            GlobalSearchScope scope = this.getProjectSourcesScope(context.getProject());
            List list = ContainerUtil.mapNotNull((Object[])paths, path -> {
                if (treeView.isPathSelected(path.getParentPath())) {
                    return null;
                }
                SMTestProxy test = treeView.getSelectedTest(path);
                return test == null ? null : test.getLocation(context.getProject(), scope);
            });
            if (list == null) {
                CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (context.containsMultipleSelection() && (psiElements = (PsiElement[])PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.getData(context.getDataContext())) != null) {
            List list = ContainerUtil.mapNotNull((Object[])psiElements, e -> new PsiLocation(context.getProject(), e));
            if (list == null) {
                CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(12);
            }
            return list;
        }
        Location location = context.getLocation();
        if (location == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<Location> list = Collections.singletonList(location);
        if (list == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    protected CidrTestScopeElement foldScope(@NotNull List<CidrTestScopeElement> elements) {
        if (elements == null) {
            CidrTestRunConfigurationBaseProducer.$$$reportNull$$$0(15);
        }
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        Ref firstName = new Ref();
        List res = ContainerUtil.map(elements, scope -> {
            firstName.setIfNull((Object)scope.getConfigurationName());
            return scope.getPattern();
        });
        if (res.isEmpty()) {
            return null;
        }
        Object name = (String)firstName.get();
        if (res.size() > 1) {
            name = (String)name + " " + CidrExecutionBundle.message("test.and.more", res.size() - 1);
        }
        return CidrTestScopeElementImpl.createTestScopeWithPatternAndConfigurationName((String)name, StringUtil.join(new LinkedHashSet(res), (String)this.getPatternSeparatorInCommandLine()), () -> ((CidrTestScopeElement)elements.get(0)).getElement());
    }

    @NotNull
    public abstract String getPatternSeparatorInCommandLine();

    @NotNull
    public abstract GlobalSearchScope getProjectSourcesScope(@NotNull Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationBaseProducer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationBaseProducer";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSetupConfigurationFromContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "determineScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocations";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "foldScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

