/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrConsoleBuilder;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.CidrRestartActionProvider;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestListParserAndHolder;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunMode;
import com.jetbrains.cidr.execution.testing.CidrTestRunProfileStateWithPreparation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrCommandLineState
implements CidrRestartActionProvider,
CidrTestRunProfileStateWithPreparation {
    @NotNull
    private final Executor myExecutor;
    @NotNull
    protected final CONFIGURATION myConfiguration;
    @Nullable
    protected final CidrTestScope myFailedTests;
    @NotNull
    private final Supplier<CidrTestScope> myEmptyTestScopeProducer;
    @NotNull
    protected volatile CidrTestRunMode myRunMode;

    public CidrTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests, @NotNull Supplier<CidrTestScope> emptyTestScopeProducer) {
        if (configuration == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(3);
        }
        if (emptyTestScopeProducer == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(4);
        }
        super(env, launcher);
        this.myRunMode = CidrTestRunMode.RUN_TEST;
        this.myConfiguration = configuration;
        this.myExecutor = executor;
        this.myFailedTests = failedTests;
        this.myEmptyTestScopeProducer = emptyTestScopeProducer;
    }

    @NotNull
    public Executor getExecutor() {
        Executor executor = this.myExecutor;
        if (executor == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(5);
        }
        return executor;
    }

    @NotNull
    public CONFIGURATION getConfiguration() {
        CONFIGURATION CONFIGURATION = this.myConfiguration;
        if (CONFIGURATION == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(6);
        }
        return CONFIGURATION;
    }

    @NotNull
    public CidrRerunFailedTestsAction createRestartAction(@NotNull ExecutionConsole console) {
        if (console == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(7);
        }
        SMTRunnerConsoleView consoleView = CidrTestCommandLineState.getConsole(console);
        CidrRerunFailedTestsAction rerunFailedTestsAction = this.doCreateRerunFailedTestsAction(consoleView);
        rerunFailedTestsAction.init(consoleView.getProperties());
        rerunFailedTestsAction.setModelProvider(() -> ((SMTRunnerConsoleView)consoleView).getResultsViewer());
        CidrRerunFailedTestsAction cidrRerunFailedTestsAction = rerunFailedTestsAction;
        if (cidrRerunFailedTestsAction == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(8);
        }
        return cidrRerunFailedTestsAction;
    }

    @NotNull
    public CidrTestScope testScope() {
        if (this.myFailedTests != null) {
            CidrTestScope cidrTestScope = this.myFailedTests;
            if (cidrTestScope == null) {
                CidrTestCommandLineState.$$$reportNull$$$0(9);
            }
            return cidrTestScope;
        }
        CidrTestRunConfigurationData<?> delegate = this.myConfiguration.getTestData();
        String pattern = StringUtil.notNullize((String)delegate.getTestPattern());
        CidrTestScope testScope = this.createEmptyTestScope();
        CidrTestScope cidrTestScope = delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN && !pattern.isEmpty() ? testScope.configureForPreRenderedScope(pattern) : testScope.addScopeElement(this.createTestScopeElement(delegate.getTestSuite(), delegate.getTestName()));
        if (cidrTestScope == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(10);
        }
        return cidrTestScope;
    }

    @Contract(pure=true)
    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(11);
        }
        return cl;
    }

    @NotNull
    public ConsoleView createConsole(@NotNull CidrConsoleBuilder builder) {
        if (builder == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(12);
        }
        ConsoleView consoleView = builder.createConsole(this.myConfiguration.getType(), this.myConfiguration.getTestData().createTestConsoleProperties(this.getExecutor(), this.getExecutionTarget()));
        if (consoleView == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(13);
        }
        return consoleView;
    }

    protected CidrTestScope createEmptyTestScope() {
        return this.myEmptyTestScopeProducer.get();
    }

    @NotNull
    protected abstract CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView var1);

    @Override
    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        CidrTestRunConfigurationData<?> data;
        if (progress == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(14);
        }
        if ((data = this.getConfiguration().getTestData()) instanceof CidrTestListParserAndHolder) {
            this.getTestListFromRunAndParseTestInfo(progress, (CidrTestListParserAndHolder)((Object)data));
        }
        if (this.needCloseBeforeTestRunTaskResults()) {
            this.closeBeforeTestRunTaskResults(progress);
        }
    }

    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return true;
    }

    protected void closeBeforeTestRunTaskResults(@NotNull ProgressIndicator progress) {
        Content beforeTestRunContent;
        if (progress == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(15);
        }
        Content content = beforeTestRunContent = progress instanceof UserDataHolder ? (Content)CidrBeforeTestRunTaskProvider.CONTENT.get((UserDataHolder)progress) : null;
        if (beforeTestRunContent != null) {
            CidrBeforeTestRunTaskProvider.PROGRESS.set((UserDataHolder)beforeTestRunContent, null);
            ApplicationManager.getApplication().invokeAndWait(() -> Objects.requireNonNull(beforeTestRunContent.getManager()).removeContent(beforeTestRunContent, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTestListFromRunAndParseTestInfo(@NotNull ProgressIndicator progress, @NotNull CidrTestListParserAndHolder data) {
        if (progress == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(16);
        }
        if (data == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(17);
        }
        data.clean();
        Executor safeDryExecutorForTestExtractor = DefaultRunExecutor.getRunExecutorInstance();
        ProgramRunner safeDryRunnerForTestExtractor = ProgramRunner.getRunner((String)safeDryExecutorForTestExtractor.getId(), this.myConfiguration);
        if (Registry.is((String)"cidr.test.prepare.test.list") && safeDryRunnerForTestExtractor != null) {
            this.myRunMode = CidrTestRunMode.GET_TEST_LIST;
            try {
                ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.getEnvironment()).executor(safeDryExecutorForTestExtractor).runner(safeDryRunnerForTestExtractor).runnerSettings(null).build();
                ProcessHandler ph = this.getConfigurationForTestListExtraction().createLauncher(environment).startProcess((CommandLineState)this);
                if (ph != null) {
                    int timeout = Registry.intValue((String)"cidr.test.prepare.test.list.timeout");
                    ProcessOutput output = CidrRunProcessUtil.runProcess((ProcessHandler)ph, (ProgressIndicator)progress, (int)timeout);
                    if (output.isTimeout()) {
                        progress.setText2(CidrExecutionBundle.message("test.before.run.timeout", timeout));
                        Logger.getInstance(this.getClass()).warn("No test list in " + timeout + " timeout");
                    } else if (!output.isCancelled()) {
                        data.parse(output);
                    }
                }
            }
            catch (ExecutionException e) {
                progress.setText2(CidrExecutionBundle.message("warning.cannot.collect.info.about.tests.to.run", e.getLocalizedMessage()));
                Logger.getInstance(this.getClass()).warn("Warning: Cannot collect info on tests to run: " + e.getLocalizedMessage());
            }
            finally {
                this.myRunMode = CidrTestRunMode.RUN_TEST;
            }
        }
    }

    private CidrTestRunConfiguration getConfigurationForTestListExtraction() {
        if (Registry.is((String)"cidr.test.prepare.test.list.without.elevation") && this.myConfiguration instanceof CidrRunConfiguration && ((CidrRunConfiguration)this.myConfiguration).isElevated()) {
            CidrRunConfiguration configurationWithUserPrivileges = (CidrRunConfiguration)this.myConfiguration.clone();
            configurationWithUserPrivileges.setElevated(false);
            return (CidrTestRunConfiguration)configurationWithUserPrivileges;
        }
        return this.myConfiguration;
    }

    @NotNull
    protected abstract CidrTestScopeElement createTestScopeElement(@Nullable String var1, @Nullable String var2);

    @NotNull
    private static SMTRunnerConsoleView getConsole(@NotNull ExecutionConsole console) {
        if (console == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(18);
        }
        SMTRunnerConsoleView sMTRunnerConsoleView = console instanceof ConsoleViewWrapperBase ? (SMTRunnerConsoleView)((ConsoleViewWrapperBase)console).getDelegate() : (SMTRunnerConsoleView)console;
        if (sMTRunnerConsoleView == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(19);
        }
        return sMTRunnerConsoleView;
    }

    protected static void addParametersAtFirstPos(@NotNull GeneralCommandLine cl, String ... params) {
        if (cl == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(20);
        }
        ParametersList plist = cl.getParametersList();
        for (String param : params) {
            plist.addAt(0, param);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 9, 10, 13, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyTestScopeProducer";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestCommandLineState";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestCommandLineState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestartAction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "testScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRestartAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestExecutionEnvironment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "closeBeforeTestRunTaskResults";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTestListFromRunAndParseTestInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addParametersAtFirstPos";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 9, 10, 13, 19 -> new IllegalStateException(string);
        };
    }
}

