/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.outlines;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.tools.intellij.aiplugin.analytics.UsageTrackerService;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u0004\u00a8\u0006\u0010"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker;", "", "()V", "trackAutomaticGenerationToggled", "", "enabled", "", "trackOutlinesFeedback", "action", "", "trackOutlinesGenerated", "trackOutlinesGenerationCancelled", "trackOutlinesItemNavigated", "trackOutlinesPanelOpened", "Companion", "OutlinesEvent", "aiplugin.ij-platform"})
@StabilityInferred(parameters=1)
public final class OutlinesMetricsTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    public final void trackOutlinesPanelOpened() {
        OutlinesEvent metricEvent = new OutlinesEvent(OutlinesEvent.Key.OUTLINES_PANEL_OPENED, null);
        UsageTrackerService.Companion.getInstance().trackOutlinesEvent(metricEvent);
    }

    public final void trackAutomaticGenerationToggled(boolean enabled) {
        OutlinesEvent event = new OutlinesEvent(OutlinesEvent.Key.OUTLINES_AUTOMATIC_GENERATION_TOGGLED, enabled ? "enabled" : "disabled");
        UsageTrackerService.Companion.getInstance().trackOutlinesEvent(event);
    }

    public final void trackOutlinesGenerated(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        OutlinesEvent event = new OutlinesEvent(OutlinesEvent.Key.OUTLINES_GENERATED, action);
        UsageTrackerService.Companion.getInstance().trackOutlinesEvent(event);
    }

    public final void trackOutlinesGenerationCancelled() {
        OutlinesEvent event = new OutlinesEvent(OutlinesEvent.Key.OUTLINES_GENERATION_CANCELLED, null);
        UsageTrackerService.Companion.getInstance().trackOutlinesEvent(event);
    }

    public final void trackOutlinesItemNavigated() {
        OutlinesEvent event = new OutlinesEvent(OutlinesEvent.Key.OUTLINES_ITEM_NAVIGATED, null);
        UsageTrackerService.Companion.getInstance().trackOutlinesEvent(event);
    }

    public final void trackOutlinesFeedback(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        OutlinesEvent event = new OutlinesEvent(OutlinesEvent.Key.OUTLINES_FEEDBACK, action);
        UsageTrackerService.Companion.getInstance().trackOutlinesEvent(event);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker$Companion;", "", "()V", "getInstance", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker;", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nOutlinesMetricsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlinesMetricsTracker.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,69:1\n40#2,3:70\n*S KotlinDebug\n*F\n+ 1 OutlinesMetricsTracker.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker$Companion\n*L\n66#1:70,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OutlinesMetricsTracker getInstance() {
            boolean $i$f$service = false;
            Class<OutlinesMetricsTracker> serviceClass$iv = OutlinesMetricsTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (OutlinesMetricsTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker$OutlinesEvent;", "", "key", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker$OutlinesEvent$Key;", "action", "", "(Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker$OutlinesEvent$Key;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "getKey", "()Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker$OutlinesEvent$Key;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Key", "aiplugin.ij-platform"})
    @StabilityInferred(parameters=1)
    public static final class OutlinesEvent {
        @NotNull
        private final Key key;
        @Nullable
        private final String action;
        public static final int $stable;

        public OutlinesEvent(@NotNull Key key, @Nullable String action) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            this.key = key;
            this.action = action;
        }

        @NotNull
        public final Key getKey() {
            return this.key;
        }

        @Nullable
        public final String getAction() {
            return this.action;
        }

        @NotNull
        public final Key component1() {
            return this.key;
        }

        @Nullable
        public final String component2() {
            return this.action;
        }

        @NotNull
        public final OutlinesEvent copy(@NotNull Key key, @Nullable String action) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            return new OutlinesEvent(key, action);
        }

        public static /* synthetic */ OutlinesEvent copy$default(OutlinesEvent outlinesEvent, Key key, String string, int n, Object object) {
            if ((n & 1) != 0) {
                key = outlinesEvent.key;
            }
            if ((n & 2) != 0) {
                string = outlinesEvent.action;
            }
            return outlinesEvent.copy(key, string);
        }

        @NotNull
        public String toString() {
            return "OutlinesEvent(key=" + this.key + ", action=" + this.action + ")";
        }

        public int hashCode() {
            int result2 = this.key.hashCode();
            result2 = result2 * 31 + (this.action == null ? 0 : this.action.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OutlinesEvent)) {
                return false;
            }
            OutlinesEvent outlinesEvent = (OutlinesEvent)other;
            if (this.key != outlinesEvent.key) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.action, (Object)outlinesEvent.action);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker$OutlinesEvent$Key;", "", "(Ljava/lang/String;I)V", "OUTLINES_GENERATED", "OUTLINES_PANEL_OPENED", "OUTLINES_AUTOMATIC_GENERATION_TOGGLED", "OUTLINES_GENERATION_CANCELLED", "OUTLINES_ITEM_NAVIGATED", "OUTLINES_FEEDBACK", "aiplugin.ij-platform"})
        public static final class Key
        extends Enum<Key> {
            public static final /* enum */ Key OUTLINES_GENERATED = new Key();
            public static final /* enum */ Key OUTLINES_PANEL_OPENED = new Key();
            public static final /* enum */ Key OUTLINES_AUTOMATIC_GENERATION_TOGGLED = new Key();
            public static final /* enum */ Key OUTLINES_GENERATION_CANCELLED = new Key();
            public static final /* enum */ Key OUTLINES_ITEM_NAVIGATED = new Key();
            public static final /* enum */ Key OUTLINES_FEEDBACK = new Key();
            private static final /* synthetic */ Key[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Key[] values() {
                return (Key[])$VALUES.clone();
            }

            public static Key valueOf(String value) {
                return Enum.valueOf(Key.class, value);
            }

            @NotNull
            public static EnumEntries<Key> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = keyArray = new Key[]{Key.OUTLINES_GENERATED, Key.OUTLINES_PANEL_OPENED, Key.OUTLINES_AUTOMATIC_GENERATION_TOGGLED, Key.OUTLINES_GENERATION_CANCELLED, Key.OUTLINES_ITEM_NAVIGATED, Key.OUTLINES_FEEDBACK};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

