/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.outlines;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.tools.intellij.aiplugin.outlines.OutlineIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0002J,\u0010\u0011\u001a\u00020\u00122\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinePresentationRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "baseIcon", "Ljavax/swing/Icon;", "leadingWhitespace", "nonWhitespace", "calcHeightInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "getScaledIcon", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOutlinePresentationRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlinePresentationRenderer.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinePresentationRenderer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,97:1\n648#2,5:98\n*S KotlinDebug\n*F\n+ 1 OutlinePresentationRenderer.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinePresentationRenderer\n*L\n69#1:98,5\n*E\n"})
public final class OutlinePresentationRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final String text;
    @NotNull
    private final Icon baseIcon;
    @NotNull
    private final String nonWhitespace;
    @NotNull
    private final String leadingWhitespace;
    public static final int $stable = 8;
    @NotNull
    private static final JBColor BACKGROUND_COLOR;
    @NotNull
    private static final JBColor TEXT_COLOR;
    @Deprecated
    public static final int GAP_ICON_TEXT = 3;

    public OutlinePresentationRenderer(@NotNull Editor editor2, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.editor = editor2;
        this.text = text2;
        this.baseIcon = OutlineIcons.OUTLINES;
        this.nonWhitespace = ((Object)StringsKt.trimStart((CharSequence)this.text)).toString();
        this.leadingWhitespace = StringsKt.dropLast((String)this.text, (int)this.nonWhitespace.length());
    }

    private final Icon getScaledIcon() {
        int iconSize = this.editor.getLineHeight();
        if (this.baseIcon instanceof ScalableIcon) {
            float scale = (float)iconSize / (float)((ScalableIcon)this.baseIcon).getIconHeight();
            Icon icon2 = ((ScalableIcon)this.baseIcon).scale(scale);
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"scale(...)");
            return icon2;
        }
        return IconUtil.toSize((Icon)this.baseIcon, (int)iconSize, (int)iconSize);
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Font font = this.editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font font2 = font;
        FontMetrics fontMetrics = this.editor.getContentComponent().getFontMetrics(font2);
        int contentWidth = this.getScaledIcon().getIconWidth() + 3 + fontMetrics.stringWidth(this.text);
        return Math.max(this.editor.getComponent().getWidth(), contentWidth);
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.editor.getLineHeight();
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        String string;
        int line;
        block4: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            if (!inlay.isValid()) {
                return;
            }
            g.setColor((Color)BACKGROUND_COLOR);
            g.fillRect(targetRegion.x, targetRegion.y, targetRegion.width, targetRegion.height);
            g.setColor((Color)TEXT_COLOR);
            g.setFont(this.editor.getColorsScheme().getFont(EditorFontType.PLAIN));
            line = this.editor.getDocument().getLineNumber(inlay.getOffset());
            int nextLine = line + 1;
            if (nextLine < this.editor.getDocument().getLineCount()) {
                String nextLineText;
                int nextLineStartOffset = this.editor.getDocument().getLineStartOffset(nextLine);
                int nextLineEndOffset = this.editor.getDocument().getLineEndOffset(nextLine);
                String string2 = this.editor.getDocument().getText(new TextRange(nextLineStartOffset, nextLineEndOffset));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                String $this$takeWhile$iv = nextLineText = string2;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it22 = $this$takeWhile$iv.charAt(index$iv);
                    int n2 = 0;
                    if (CharsKt.isWhitespace((char)it22)) continue;
                    String it22 = $this$takeWhile$iv;
                    n2 = 0;
                    String string3 = it22.substring(n2, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block4;
                }
                string = $this$takeWhile$iv;
            } else {
                string = this.leadingWhitespace;
            }
        }
        String indentationString = string;
        int lineStartOffset = this.editor.getDocument().getLineStartOffset(line);
        LogicalPosition logicalPosition = this.editor.offsetToLogicalPosition(lineStartOffset);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int lineStartX = this.editor.logicalPositionToXY((LogicalPosition)logicalPosition2).x;
        FontMetrics fm = g.getFontMetrics();
        int indentationWidth = fm.stringWidth(indentationString);
        int startX = lineStartX + indentationWidth;
        int textY = targetRegion.y + (targetRegion.height - fm.getHeight()) / 2 + fm.getAscent();
        Icon scaledIcon = this.getScaledIcon();
        int iconY = textY - fm.getAscent();
        scaledIcon.paintIcon(null, g, startX, iconY);
        int textX = startX + scaledIcon.getIconWidth() + 3;
        g.drawString(this.nonWhitespace, textX, textY);
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"EditorPane.selectionBackground");
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        BACKGROUND_COLOR = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"EditorPane.selectionForeground");
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        TEXT_COLOR = jBColor2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinePresentationRenderer$Companion;", "", "()V", "BACKGROUND_COLOR", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getBACKGROUND_COLOR", "()Lcom/intellij/ui/JBColor;", "GAP_ICON_TEXT", "", "TEXT_COLOR", "getTEXT_COLOR", "aiplugin.ij-platform"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JBColor getBACKGROUND_COLOR() {
            return BACKGROUND_COLOR;
        }

        @NotNull
        public final JBColor getTEXT_COLOR() {
            return TEXT_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

