/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.hats;

import com.google.tools.intellij.aiplugin.analytics.UsageTrackerService;
import com.google.tools.intellij.aiplugin.hats.HatsActivationManager;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0014\u0010\b\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\u00a8\u0006\u0010"}, d2={"improvementQuestionNumber", "", "getImprovementQuestionNumber", "()I", "npsQuestionNumber", "getNpsQuestionNumber", "satisfactionQuestionNumber", "getSatisfactionQuestionNumber", "successQuestionNumber", "getSuccessQuestionNumber", "getExtraHatsMetadata", "", "", "sendHatsTrackEvent", "", "trackEvent", "aiplugin.ij-platform"})
public final class HatsMetricsKt {
    private static final int npsQuestionNumber = 1;
    private static final int satisfactionQuestionNumber = 2;
    private static final int improvementQuestionNumber = 3;
    private static final int successQuestionNumber = 4;

    public static final int getNpsQuestionNumber() {
        return npsQuestionNumber;
    }

    public static final int getSatisfactionQuestionNumber() {
        return satisfactionQuestionNumber;
    }

    public static final int getImprovementQuestionNumber() {
        return improvementQuestionNumber;
    }

    public static final int getSuccessQuestionNumber() {
        return successQuestionNumber;
    }

    public static final void sendHatsTrackEvent(@NotNull String trackEvent) {
        Intrinsics.checkNotNullParameter((Object)trackEvent, (String)"trackEvent");
        UsageTrackerService.Companion.getInstance().trackHatsEvent(trackEvent, String.valueOf(HatsActivationManager.Companion.getInstance().getHatsTriggerActionName()), HatsActivationManager.Companion.getInstance().getCurrentHatsSessionIndex());
    }

    @NotNull
    public static final Map<String, String> getExtraHatsMetadata() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"hats_session_index", (Object)HatsActivationManager.Companion.getInstance().getCurrentHatsSessionIndex()), TuplesKt.to((Object)"action", (Object)String.valueOf(HatsActivationManager.Companion.getInstance().getHatsTriggerActionName()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

