/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.feedback;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.cloud.tools.intellij.feedback.GoogleAnonymousFeedbackTask;
import com.google.cloud.tools.intellij.feedback.GoogleFeedbackErrorReporterBase;
import com.google.cloud.tools.intellij.feedback.HttpConnectionFactory;
import com.google.cloud.tools.intellij.feedback.ProxyHttpConnectionFactory;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.feedback.CrashReportService;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/google/tools/intellij/aiplugin/feedback/GoogleFeedbackErrorReporter;", "Lcom/google/cloud/tools/intellij/feedback/GoogleFeedbackErrorReporterBase;", "()V", "getFeedbackSender", "Lcom/google/cloud/tools/intellij/feedback/GoogleAnonymousFeedbackTask$FeedbackSender;", "getReportActionText", "", "notifyFailure", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "notifySuccess", "NetworkFeedbackSender", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
public final class GoogleFeedbackErrorReporter
extends GoogleFeedbackErrorReporterBase {
    public static final int $stable = 8;

    @Override
    public void notifySuccess(@Nullable Project project2) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("com.google.tools.intellij.aiplugin.feedback");
        String string = DiagnosticBundle.message((String)"error.report.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        notificationGroup.createNotification(string, "Submitted", NotificationType.INFORMATION).setImportant(false).notify(project2);
    }

    @Override
    public void notifyFailure(@Nullable Project project2, @Nullable String message) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("com.google.tools.intellij.aiplugin.feedback");
        String string = DiagnosticBundle.message((String)"error.report.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = message;
        if (string2 == null) {
            string2 = "";
        }
        notificationGroup.createNotification(string, string2, NotificationType.ERROR).setListener(NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(project2);
    }

    @Override
    @NotNull
    public GoogleAnonymousFeedbackTask.FeedbackSender getFeedbackSender() {
        return new NetworkFeedbackSender();
    }

    @Override
    @NotNull
    public String getReportActionText() {
        return SmlIjBundle.message("aiplugin.feedback.error.message", new Object[0]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\t"}, d2={"Lcom/google/tools/intellij/aiplugin/feedback/GoogleFeedbackErrorReporter$NetworkFeedbackSender;", "Lcom/google/cloud/tools/intellij/feedback/GoogleAnonymousFeedbackTask$FeedbackSender;", "()V", "sendFeedback", "", "cause", "", "errorDescription", "Companion", "aiplugin.ij-platform"})
    private static final class NetworkFeedbackSender
    implements GoogleAnonymousFeedbackTask.FeedbackSender {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final HttpConnectionFactory connectionFactory = new ProxyHttpConnectionFactory();

        @Override
        @NotNull
        public String sendFeedback(@NotNull Throwable cause, @Nullable String errorDescription) throws IOException {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            CrashReportService crashReportService = CrashReportService.Companion.getInstance();
            CharSequence charSequence = errorDescription;
            crashReportService.submitCrashReport(connectionFactory, cause, charSequence == null || charSequence.length() == 0 ? "No error description" : errorDescription);
            return String.valueOf(System.currentTimeMillis());
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/google/tools/intellij/aiplugin/feedback/GoogleFeedbackErrorReporter$NetworkFeedbackSender$Companion;", "", "()V", "connectionFactory", "Lcom/google/cloud/tools/intellij/feedback/HttpConnectionFactory;", "aiplugin.ij-platform"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

