/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.completion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ActiveOnboardingProvider;
import com.android.studio.ml.bot.UtilsKt;
import com.android.studio.ml.bot.ui.onboarding.OnboardingState;
import com.google.tools.intellij.aiplugin.completion.RecentUserActionsListener;
import com.google.tools.intellij.aiplugin.completion.SuggestionManager;
import com.google.tools.intellij.aiplugin.completion.SuggestionSession;
import com.google.tools.intellij.aiplugin.experimentation.ExperimentationFlagsService;
import com.google.tools.intellij.aiplugin.flag.FeatureFlagsService;
import com.google.tools.intellij.aiplugin.state.AiPluginSettingsProvider;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0006\u0010\u0017\u001a\u00020\u0013J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u001d\u001a\u00020\u0013J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0013J\u0006\u0010 \u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/google/tools/intellij/aiplugin/completion/SuggestionManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineDispatcher;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "isEnabledState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "recentUserActionsListeners", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/google/tools/intellij/aiplugin/completion/RecentUserActionsListener;", "sessions", "Lcom/google/tools/intellij/aiplugin/completion/SuggestionSession;", "acceptSuggestion", "", "cleanupEditor", "editor", "connectToFlags", "dismissSuggestions", "dispose", "getSession", "isEnabled", "", "isSessionActive", "redoSuggestion", "setupEditor", "undoSuggestion", "updateEnabledState", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSuggestionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuggestionManager.kt\ncom/google/tools/intellij/aiplugin/completion/SuggestionManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Merge.kt\nkotlinx/coroutines/flow/FlowKt__MergeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n30#2,2:205\n30#2,2:208\n30#2,2:214\n189#3:207\n13472#4,2:210\n1869#5,2:212\n40#6,3:216\n1#7:219\n*S KotlinDebug\n*F\n+ 1 SuggestionManager.kt\ncom/google/tools/intellij/aiplugin/completion/SuggestionManager\n*L\n87#1:205,2\n96#1:208,2\n131#1:214,2\n89#1:207\n109#1:210,2\n115#1:212,2\n132#1:216,3\n*E\n"})
public final class SuggestionManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final ConcurrentHashMap<Editor, SuggestionSession> sessions;
    @NotNull
    private final ConcurrentHashMap<Editor, RecentUserActionsListener> recentUserActionsListeners;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final AtomicBoolean isEnabledState;
    public static final int $stable = 8;

    public SuggestionManager(@NotNull Project project2, @NotNull CoroutineDispatcher dispatcher2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dispatcher2, (String)"dispatcher");
        this.project = project2;
        this.dispatcher = dispatcher2;
        this.sessions = new ConcurrentHashMap();
        this.recentUserActionsListeners = new ConcurrentHashMap();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)this.dispatcher));
        this.isEnabledState = new AtomicBoolean(false);
        this.connectToFlags();
        this.updateEnabledState();
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor2 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                this.setupEditor(editor2);
            }
        }, (Disposable)this);
    }

    public /* synthetic */ SuggestionManager(Project project2, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(project2, coroutineDispatcher);
    }

    public SuggestionManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this(project2, Dispatchers.getIO());
    }

    private final void connectToFlags() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class serviceClass$iv = ActiveOnboardingProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Flow $this$flatMapLatest$iv = (Flow)((ActiveOnboardingProvider)object).getOnboardingState();
        boolean $i$f$flatMapLatest = false;
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)FlowKt.distinctUntilChanged((Flow)FlowKt.transformLatest((Flow)$this$flatMapLatest$iv, (Function3)((Function3)new Function3<FlowCollector<? super OnboardingState.State>, OnboardingState, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $completion) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$completion);
                        FlowCollector $this$transformLatest = (FlowCollector)this.L$0;
                        Object it = this.L$1;
                        FlowCollector flowCollector = $this$transformLatest;
                        Continuation cfr_ignored_0 = (Continuation)this;
                        OnboardingState it2 = (OnboardingState)it;
                        boolean bl = false;
                        this.label = 1;
                        Object object2 = FlowKt.emitAll((FlowCollector)flowCollector, (Flow)((Flow)it2.getCurrentState()), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(FlowCollector p1, Object p2, Continuation p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }))), (Function2)((Function2)new Function2<OnboardingState.State, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SuggestionManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.updateEnabledState();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(OnboardingState.State p1, Continuation<? super Unit> p2) {
                return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
        $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        $i$f$service = false;
        serviceClass$iv = AiPluginSettingsProvider.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)((AiPluginSettingsProvider)object2).getNextEditPredictionsSettingState()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SuggestionManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.updateEnabledState();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
    }

    public final void updateEnabledState() {
        boolean shouldBeEnabled = this.isEnabled();
        if (this.isEnabledState.getAndSet(shouldBeEnabled) == shouldBeEnabled) {
            return;
        }
        if (shouldBeEnabled) {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
            Object[] $this$forEach$iv = fileEditorArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileEditor fileEditor = (FileEditor)element$iv;
                boolean bl = false;
                if (!(fileEditor instanceof TextEditor)) continue;
                Editor editor2 = ((TextEditor)fileEditor).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                this.setupEditor(editor2);
            }
        } else {
            Set set = this.sessions.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Editor editor3 = (Editor)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)editor3);
                this.cleanupEditor(editor3);
            }
        }
    }

    public final boolean isSessionActive() {
        Editor editor2 = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        if (editor2 == null) {
            return false;
        }
        Editor editor3 = editor2;
        return this.isSessionActive(editor3);
    }

    public final boolean isSessionActive(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        SuggestionSession suggestionSession = this.getSession(editor2);
        boolean hasSuggestions = suggestionSession != null ? suggestionSession.hasValidSuggestions() : false;
        return this.isEnabled() && hasSuggestions;
    }

    public final boolean isEnabled() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ActiveOnboardingProvider> serviceClass$iv = ActiveOnboardingProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        OnboardingState.State onboardingState2 = (OnboardingState.State)((Object)((OnboardingState)((ActiveOnboardingProvider)object).getOnboardingState().getValue()).getCurrentState().getValue());
        boolean $i$f$service2 = false;
        Class<ExperimentationFlagsService> serviceClass$iv2 = ExperimentationFlagsService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((ExperimentationFlagsService)object2).getValue(FeatureFlagsService.Companion.getEnableIntentAwareM1()) != false && AiPluginSettingsProvider.Companion.getInstance().getEnableNextEditPredictions() && onboardingState2 == OnboardingState.State.ONBOARDED;
    }

    public final void acceptSuggestion() {
        block1: {
            Editor editor2 = UtilsKt.getTextEditor(this.project);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            SuggestionSession suggestionSession = this.getSession(editor3);
            if (suggestionSession == null) break block1;
            suggestionSession.acceptSuggestion();
        }
    }

    public final void dismissSuggestions() {
        block1: {
            Editor editor2 = UtilsKt.getTextEditor(this.project);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            SuggestionSession suggestionSession = this.getSession(editor3);
            if (suggestionSession == null) break block1;
            suggestionSession.dismissSuggestions();
        }
    }

    public final void undoSuggestion() {
        block1: {
            Editor editor2 = UtilsKt.getTextEditor(this.project);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            SuggestionSession suggestionSession = this.getSession(editor3);
            if (suggestionSession == null) break block1;
            suggestionSession.undoSuggestion();
        }
    }

    public final void redoSuggestion() {
        block1: {
            Editor editor2 = UtilsKt.getTextEditor(this.project);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            SuggestionSession suggestionSession = this.getSession(editor3);
            if (suggestionSession == null) break block1;
            suggestionSession.redoSuggestion();
        }
    }

    @Nullable
    public final SuggestionSession getSession(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return this.sessions.get(editor2);
    }

    private final void setupEditor(Editor editor2) {
        if (!this.isEnabled() || editor2.isViewer() || editor2.getEditorKind() != EditorKind.MAIN_EDITOR || !Intrinsics.areEqual((Object)editor2.getProject(), (Object)this.project)) {
            return;
        }
        this.sessions.computeIfAbsent(editor2, arg_0 -> SuggestionManager.setupEditor$lambda$0((Function1)new Function1<Editor, SuggestionSession>(editor2, this){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ SuggestionManager this$0;
            {
                this.$editor = $editor;
                this.this$0 = $receiver;
                super(1);
            }

            public final SuggestionSession invoke(Editor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RecentUserActionsListener listener2 = new RecentUserActionsListener(this.$editor, null, 2, null);
                ((Map)SuggestionManager.access$getRecentUserActionsListeners$p(this.this$0)).put(this.$editor, listener2);
                this.$editor.getDocument().addDocumentListener((DocumentListener)listener2, (Disposable)this.this$0);
                SuggestionSession session2 = new SuggestionSession(this.$editor, listener2, SuggestionManager.access$getCoroutineScope$p(this.this$0), SuggestionManager.access$getDispatcher$p(this.this$0));
                Disposer.register((Disposable)this.this$0, (Disposable)session2);
                Editor editor2 = this.$editor;
                Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                Disposer.register((Disposable)((EditorImpl)editor2).getDisposable(), () -> setupEditor.1.invoke$lambda$0(this.this$0, this.$editor));
                return session2;
            }

            private static final void invoke$lambda$0(SuggestionManager this$0, Editor $editor) {
                SuggestionManager.access$cleanupEditor(this$0, $editor);
            }
        }, arg_0));
    }

    private final void cleanupEditor(Editor editor2) {
        block2: {
            if (!Intrinsics.areEqual((Object)editor2.getProject(), (Object)this.project) || editor2.isViewer() || !this.sessions.containsKey(editor2)) {
                return;
            }
            SuggestionSession suggestionSession = this.sessions.remove(editor2);
            if (suggestionSession != null) {
                SuggestionSession it = suggestionSession;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            RecentUserActionsListener recentUserActionsListener = this.recentUserActionsListeners.remove(editor2);
            if (recentUserActionsListener == null) break block2;
            RecentUserActionsListener listener2 = recentUserActionsListener;
            boolean bl = false;
            editor2.getDocument().removeDocumentListener((DocumentListener)listener2);
            Disposer.dispose((Disposable)listener2);
        }
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.sessions.clear();
        this.recentUserActionsListeners.clear();
    }

    private static final SuggestionSession setupEditor$lambda$0(Function1 $tmp0, Object p0) {
        return (SuggestionSession)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getRecentUserActionsListeners$p(SuggestionManager $this) {
        return $this.recentUserActionsListeners;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(SuggestionManager $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ CoroutineDispatcher access$getDispatcher$p(SuggestionManager $this) {
        return $this.dispatcher;
    }

    public static final /* synthetic */ void access$cleanupEditor(SuggestionManager $this, Editor editor2) {
        $this.cleanupEditor(editor2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/SuggestionManager$Companion;", "", "()V", "getInstance", "Lcom/google/tools/intellij/aiplugin/completion/SuggestionManager;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.ij-platform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SuggestionManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(SuggestionManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (SuggestionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

