/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.action;

import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.TerminalReference;
import com.android.studio.ml.TerminalService;
import com.android.studio.ml.bot.StudioBotFlags;
import com.android.studio.ml.bot.ui.compose.KeyedIcon;
import com.android.studio.ml.bot.ui.compose.KnownIconKt;
import com.android.studio.ml.bot.ui.compose.timeline.Attachment;
import com.android.studio.ml.bot.ui.compose.timeline.AttachmentKt;
import com.android.studio.ml.bot.ui.compose.timeline.ContextDrawerAttachment;
import com.android.studio.ml.bot.ui.compose.timeline.context.ContextDrawerPersister;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.flag.FeatureFlagsService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ui.TerminalPanel;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/google/tools/intellij/aiplugin/action/AddToContextAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "fileToContextDrawerAttachment", "Lcom/android/studio/ml/bot/ui/compose/timeline/ContextDrawerAttachment;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getSource", "Lcom/google/tools/intellij/aiplugin/action/AddToContextAction$Source;", "event", "update", "Source", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
public final class AddToContextAction
extends DumbAwareAction {
    public static final int $stable = 8;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Project project2 = e.getProject();
        presentation2.setEnabledAndVisible(false);
        if (project2 == null || !StudioBotFlags.Companion.getInstance().isContextAttachmentEnabled()) {
            return;
        }
        Source source = this.getSource(e);
        if (source == Source.FILE && FeatureFlagsService.Companion.getInstance().isChatSnippetContextEnabled()) {
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            presentation2.setEnabledAndVisible(true);
            if (editor3.getSelectionModel().hasSelection()) {
                presentation2.setText(SmlIjBundle.message("aiplugin.actions.addToContext.file.selection", new Object[0]));
            } else {
                presentation2.setText(SmlIjBundle.message("aiplugin.actions.addToContext.file", new Object[0]));
            }
        }
        if (source == Source.TERMINAL && StudioBotFlags.Companion.getInstance().isTerminalSelectionEnabled()) {
            TerminalService.TerminalInfo terminalInfo = TerminalService.Companion.getInstance(project2).getActiveTerminal();
            if (terminalInfo == null) {
                return;
            }
            TerminalService.TerminalInfo activeTerminal = terminalInfo;
            if (activeTerminal.getSelectedText() == null) {
                Object[] objectArray = new Object[]{"Gemini: ", "Current Terminal"};
                presentation2.setText(SmlIjBundle.message("aiplugin.actions.addToContext.text", objectArray));
                presentation2.setEnabledAndVisible(true);
                return;
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block8: {
            Source source;
            Project project2;
            block7: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project3 = e.getProject();
                if (project3 == null) {
                    return;
                }
                project2 = project3;
                source = this.getSource(e);
                if (source != Source.FILE) break block7;
                Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
                VirtualFile virtualFile2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile file = virtualFile2;
                if (editor2 != null && editor2.getSelectionModel().hasSelection()) {
                    int startOffset = editor2.getSelectionModel().getSelectionStart();
                    int endOffset = editor2.getSelectionModel().getSelectionEnd();
                    Document document2 = editor2.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                    Document document3 = document2;
                    String string = document3.getText(new TextRange(startOffset, endOffset));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String selection = string;
                    int startLine = document3.getLineNumber(startOffset);
                    int endLine = document3.getLineNumber(endOffset);
                    String string2 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    String string3 = project2.getBasePath();
                    if (string3 == null) {
                        string3 = "";
                    }
                    String projectRelativePath = StringsKt.removePrefix((String)string2, (CharSequence)string3);
                    PsiFile psiFile2 = (PsiFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(project2, file){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ VirtualFile $file;
                        {
                            this.$project = $project;
                            this.$file = $file;
                            super(0);
                        }

                        public final PsiFile invoke() {
                            Project project2 = this.$project;
                            VirtualFile virtualFile2 = this.$file;
                            Project it = project2;
                            boolean bl = false;
                            return PsiManager.getInstance((Project)it).findFile(virtualFile2);
                        }
                    }));
                    String string4 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                    Attachment.CodeSelection attachment2 = new Attachment.CodeSelection(string4, projectRelativePath, null, (KeyedIcon)ActionsKt.runReadAction((Function0)((Function0)new Function0<KeyedIcon>(psiFile2){
                        final /* synthetic */ PsiFile $psiFile;
                        {
                            this.$psiFile = $psiFile;
                            super(0);
                        }

                        public final KeyedIcon invoke() {
                            PsiFile psiFile2 = this.$psiFile;
                            return psiFile2 != null ? KnownIconKt.getKeyedIconOrNull((PsiFileSystemItem)psiFile2) : null;
                        }
                    })), selection, startLine, endLine);
                    ContextDrawerPersister.Companion.getInstance().addAttachments(CollectionsKt.listOf((Object)attachment2));
                } else {
                    ContextDrawerPersister.Companion.getInstance().addAttachments(CollectionsKt.listOf((Object)this.fileToContextDrawerAttachment(file, project2)));
                }
                break block8;
            }
            if (source != Source.TERMINAL) break block8;
            TerminalService.TerminalInfo terminalInfo = TerminalService.Companion.getInstance(project2).getActiveTerminal();
            if (terminalInfo != null) {
                TerminalService.TerminalInfo terminal = terminalInfo;
                boolean bl = false;
                if (terminal.getSelectedText() == null) {
                    ContextDrawerPersister.Companion.getInstance().addAttachments(CollectionsKt.listOf((Object)AttachmentKt.toContextDrawerAttachment(new TerminalReference(terminal.getId(), true))));
                }
            }
        }
    }

    private final Source getSource(AnActionEvent event) {
        VirtualFile file = (VirtualFile)event.getDataContext().getData(CommonDataKeys.VIRTUAL_FILE);
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        Component comp = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        return editor2 != null && file != null ? Source.FILE : (comp instanceof TerminalPanel || comp instanceof JBTerminalWidget || editor2 != null ? Source.TERMINAL : Source.OTHER);
    }

    @VisibleForTesting
    @NotNull
    public final ContextDrawerAttachment fileToContextDrawerAttachment(@NotNull VirtualFile file, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return AttachmentKt.toContextDrawerAttachment(file, project2, null, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/tools/intellij/aiplugin/action/AddToContextAction$Source;", "", "(Ljava/lang/String;I)V", "FILE", "TERMINAL", "OTHER", "aiplugin.ij-platform"})
    public static final class Source
    extends Enum<Source> {
        public static final /* enum */ Source FILE = new Source();
        public static final /* enum */ Source TERMINAL = new Source();
        public static final /* enum */ Source OTHER = new Source();
        private static final /* synthetic */ Source[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Source[] values() {
            return (Source[])$VALUES.clone();
        }

        public static Source valueOf(String value) {
            return Enum.valueOf(Source.class, value);
        }

        @NotNull
        public static EnumEntries<Source> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sourceArray = new Source[]{Source.FILE, Source.TERMINAL, Source.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

