/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ErrorHandler;
import com.android.studio.ml.ModelError;
import com.android.studio.ml.ProductBrandingProvider;
import com.android.studio.ml.action.ConfigureStudioBotAction;
import com.android.studio.ml.action.OpenDocumentationAction;
import com.android.studio.ml.action.SubmitFeedbackAction;
import com.android.tools.idea.studiobot.Status;
import com.android.tools.idea.studiobot.StatusRuntimeException;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.tools.intellij.aiplugin.CitationBlockingException;
import com.google.tools.intellij.aiplugin.EmptySuggestionException;
import com.google.tools.intellij.aiplugin.MissingFileChangeException;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.action.EnableApiAction;
import com.google.tools.intellij.aiplugin.action.LoginAction;
import com.google.tools.intellij.aiplugin.action.SelectGcpProjectAction;
import com.google.tools.intellij.aiplugin.flag.FeatureFlagsService;
import com.google.tools.intellij.aiplugin.network.NetworkStatusService;
import com.google.tools.intellij.aiplugin.tier.UserTierService;
import com.google.tools.intellij.aiplugin.util.GoogleJsonResponseExceptionKt;
import com.google.tools.intellij.aiplugin.util.ProjectsKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u001f\u0010\u0015\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0002J&\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/google/tools/intellij/aiplugin/AiPluginErrorHandler;", "Lcom/android/studio/ml/ErrorHandler;", "()V", "learnMoreVpcUrl", "", "reappearDelayMinutesForCompleteCode", "", "convertExceptionToModelError", "Lcom/android/studio/ml/ModelError;", "t", "", "errorSource", "Lcom/android/studio/ml/ErrorHandler$ErrorSource;", "convertKeysToActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "keys", "filterByUserTier", "actionKeyNames", "forUserDefinedProjectsOnly", "text", "getFallbackErrorMessageForSource", "Lorg/jetbrains/annotations/Nls;", "source", "errorMessage", "getModelErrorForStatus", "Lcom/android/studio/ml/ModelError$ReappearingError;", "status", "Lcom/android/tools/idea/studiobot/Status;", "reappearDelayMinutes", "error", "Lcom/google/api/client/googleapis/json/GoogleJsonResponseException;", "getReappearDelayMinutes", "userDefinedProjectUsed", "", "ErrorActionKey", "aiplugin.ij-platform"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAiPluginErrorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPluginErrorHandler.kt\ncom/google/tools/intellij/aiplugin/AiPluginErrorHandler\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n40#2,3:398\n40#2,3:418\n40#2,3:421\n1617#3,9:401\n1869#3:410\n1870#3:413\n1626#3:414\n827#3:415\n855#3,2:416\n1#4:411\n1#4:412\n*S KotlinDebug\n*F\n+ 1 AiPluginErrorHandler.kt\ncom/google/tools/intellij/aiplugin/AiPluginErrorHandler\n*L\n93#1:398,3\n359#1:418,3\n362#1:421,3\n99#1:401,9\n99#1:410\n99#1:413\n99#1:414\n347#1:415\n347#1:416,2\n99#1:412\n*E\n"})
public final class AiPluginErrorHandler
implements ErrorHandler {
    @NotNull
    private final String learnMoreVpcUrl;
    private final long reappearDelayMinutesForCompleteCode;
    public static final int $stable;

    public AiPluginErrorHandler() {
        this.learnMoreVpcUrl = "http://developers.google.com/gemini-code-assist/ui/vpc-sc";
        this.reappearDelayMinutesForCompleteCode = 1440L;
    }

    @Override
    @Nullable
    public ModelError convertExceptionToModelError(@NotNull Throwable t, @NotNull ErrorHandler.ErrorSource errorSource) {
        ModelError modelError;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)((Object)errorSource), (String)"errorSource");
        long reappearDelayMinutes = this.getReappearDelayMinutes(errorSource);
        Throwable throwable = t;
        if (throwable instanceof StatusRuntimeException) {
            v0 = AiPluginErrorHandler.getModelErrorForStatus$default(this, ((StatusRuntimeException)t).getStatus(), reappearDelayMinutes, null, 4, null);
        } else if (throwable instanceof GoogleJsonResponseException) {
            ModelError.ReappearingError reappearingError;
            ModelError.ReappearingError modelForStatus = this.getModelErrorForStatus(GoogleJsonResponseExceptionKt.status((GoogleJsonResponseException)t), reappearDelayMinutes, (GoogleJsonResponseException)t);
            String messageFromResponse = GoogleJsonResponseExceptionKt.getMessage((GoogleJsonResponseException)t);
            CharSequence charSequence = messageFromResponse;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && GoogleJsonResponseExceptionKt.shouldDisplayMessage((GoogleJsonResponseException)t)) {
                ModelError.ReappearingError reappearingError2 = modelForStatus;
                reappearingError = reappearingError2 != null ? ModelError.ReappearingError.copy$default(reappearingError2, null, messageFromResponse, null, 0L, GoogleJsonResponseExceptionKt.getHelpLinks((GoogleJsonResponseException)t), 13, null) : null;
            } else {
                reappearingError = modelForStatus;
            }
            v0 = reappearingError;
        } else {
            v0 = throwable instanceof EmptySuggestionException ? (ModelError)new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("ai.companion.code.generation.error.empty.suggestion.text", new Object[0]), CollectionsKt.emptyList(), reappearDelayMinutes, null, 16, null) : (throwable instanceof CitationBlockingException ? (ModelError)new ModelError.CitationBlockingError(SmlIjBundle.message("aiplugin.product.name", new Object[0]), SmlIjBundle.message("ai.companion.code.generation.error.citation.block.text", new Object[0])) : (throwable instanceof MissingFileChangeException ? (ModelError)new ModelError.Error(SmlIjBundle.message("aiplugin.product.name", new Object[0]), SmlIjBundle.message("ai.companion.code.generation.error.diff.block.text", new Object[0]), null, 4, null) : (modelError = ((throwable instanceof SocketTimeoutException ? true : throwable instanceof UnknownHostException) ? true : throwable instanceof SocketException) ? (ModelError)new ModelError.Network(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.network.text", new Object[0])) : (ModelError)new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), this.getFallbackErrorMessageForSource(errorSource, t.getMessage()), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null))));
        }
        if (modelError instanceof ModelError.Network) {
            boolean $i$f$service = false;
            Class<NetworkStatusService> serviceClass$iv = NetworkStatusService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((NetworkStatusService)object).setNetworkStatusToError((Exception)t);
        }
        return modelError;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnAction> convertKeysToActions(@NotNull List<String> keys) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Iterable $this$mapNotNull$iv = keys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnAction anAction;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            switch (key) {
                case "SubmitFeedback": {
                    anAction = new SubmitFeedbackAction(null, 1, null);
                    break;
                }
                case "OpenDocumentation": {
                    String documentationUrl = ProductBrandingProvider.Companion.getInstance().getDocumentationUrl();
                    anAction = ((CharSequence)documentationUrl).length() > 0 ? new OpenDocumentationAction(documentationUrl, null, 2, null) : null;
                    break;
                }
                case "OpenFaq": {
                    anAction = new OpenDocumentationAction("https://developers.google.com/gemini-code-assist/ui/faqs", null, 2, null);
                    break;
                }
                case "OpenConfiguration": {
                    ConfigureStudioBotAction configureStudioBotAction;
                    if (ProjectsKt.getCurrentProject() != null) {
                        Project it;
                        boolean bl3 = false;
                        configureStudioBotAction = new ConfigureStudioBotAction(it);
                    } else {
                        configureStudioBotAction = null;
                    }
                    anAction = configureStudioBotAction;
                    break;
                }
                case "SelectProject": {
                    anAction = (AnAction)new SelectGcpProjectAction(null, null, 3, null);
                    break;
                }
                case "LogIn": {
                    anAction = (AnAction)new LoginAction(null, null, null, 7, null);
                    break;
                }
                case "EnableApi": {
                    anAction = (AnAction)new EnableApiAction(null, null, 3, null);
                    break;
                }
                case "LearnMoreVpc": {
                    anAction = new OpenDocumentationAction(this.learnMoreVpcUrl, SmlIjBundle.message("aiplugin.error.action.learnMore.text", new Object[0]));
                    break;
                }
                case "SubmitDiffFeedback": {
                    anAction = new SubmitFeedbackAction(SmlIjBundle.message("aiplugin.feedback.dialog.description.prefix.diff.error", new Object[0]));
                    break;
                }
                default: {
                    anAction = null;
                }
            }
            if (anAction == null) continue;
            AnAction it$iv$iv = anAction;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ModelError.ReappearingError getModelErrorForStatus(Status status2, long reappearDelayMinutes, GoogleJsonResponseException error) {
        ModelError.ReappearingError reappearingError;
        switch (WhenMappings.$EnumSwitchMapping$0[status2.ordinal()]) {
            case 1: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.aborted.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 2: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.already.exists.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 3: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.client.side.rate.limit.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 4: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.data.loss.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 5: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.deadline.exceeded.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 6: {
                Object[] objectArray = new String[]{"OpenConfiguration", "SubmitFeedback"};
                ModelError.ReappearingError reappearingError2 = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.failed.precondition.text", new Object[0]), this.filterByUserTier(CollectionsKt.listOf((Object[])objectArray)), reappearDelayMinutes, null, 16, null);
                reappearingError = reappearingError2;
                return reappearingError;
            }
            case 7: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.internal.text", new Object[0]), CollectionsKt.emptyList(), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 8: {
                GoogleJsonResponseException googleJsonResponseException = error;
                if (Intrinsics.areEqual((Object)(googleJsonResponseException != null ? GoogleJsonResponseExceptionKt.getReason(googleJsonResponseException) : null), (Object)"USER_PROJECT_DENIED")) {
                    reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.permission.denied.project.not.found.or.deleted", new Object[0]), CollectionsKt.listOf((Object)"SelectProject"), reappearDelayMinutes, null, 16, null);
                    return reappearingError;
                }
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.invalid.argument.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 9: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.not.found.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 10: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.out.of.range.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 11: {
                List list;
                String string;
                GoogleJsonResponseException googleJsonResponseException = error;
                String string2 = string = googleJsonResponseException != null ? GoogleJsonResponseExceptionKt.getReason(googleJsonResponseException) : null;
                if (string != null) {
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1137835137: {
                            if (!string.equals("SUBSCRIPTION_REQUIRED")) break;
                            n = 1;
                            break;
                        }
                        case 1759816016: {
                            if (!string.equals("SECURITY_POLICY_VIOLATED")) break;
                            n = 2;
                            break;
                        }
                        case -1778149739: {
                            if (!string.equals("USER_PROJECT_DENIED")) break;
                            n = 3;
                            break;
                        }
                        case 419242214: {
                            if (!string.equals("SERVICE_DISABLED")) break;
                            n = 4;
                            break;
                        }
                        case -508779391: {
                            if (!string.equals("IAM_PERMISSION_DENIED")) break;
                            n = 3;
                            break;
                        }
                        case 419725771: {
                            if (!string.equals("sslRequired")) break;
                            n = 5;
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.permission.denied.security.policy.violated.text", new Object[0]), this.filterByUserTier(CollectionsKt.listOf((Object)"LearnMoreVpc")), reappearDelayMinutes, null, 16, null);
                            return reappearingError;
                        }
                        case 5: {
                            reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.permission.denied.ssl.required.text", new Object[0]), this.filterByUserTier(CollectionsKt.listOf((Object)"OpenConfiguration")), reappearDelayMinutes, null, 16, null);
                            return reappearingError;
                        }
                        case 4: {
                            List list2;
                            String string3 = SmlIjBundle.message("aiplugin.error.title.text", new Object[0]);
                            String string4 = this.forUserDefinedProjectsOnly(SmlIjBundle.message("aiplugin.error.permission.denied.service.disabled.text", new Object[0]));
                            if (this.userDefinedProjectUsed()) {
                                Object[] objectArray = new String[]{"EnableApi", "SelectProject", "OpenDocumentation"};
                                list2 = CollectionsKt.listOf((Object[])objectArray);
                            } else {
                                list2 = CollectionsKt.listOf((Object)"SubmitFeedback");
                            }
                            reappearingError = new ModelError.ReappearingError(string3, string4, list2, reappearDelayMinutes, null, 16, null);
                            return reappearingError;
                        }
                        case 3: {
                            List list3;
                            String string5 = SmlIjBundle.message("aiplugin.error.title.text", new Object[0]);
                            String string6 = this.forUserDefinedProjectsOnly(SmlIjBundle.message("aiplugin.error.permission.denied.user.lacking.permissions.text", new Object[0]));
                            if (this.userDefinedProjectUsed()) {
                                Object[] objectArray = new String[]{"SelectProject", "OpenDocumentation"};
                                list3 = CollectionsKt.listOf((Object[])objectArray);
                            } else {
                                list3 = CollectionsKt.listOf((Object)"SubmitFeedback");
                            }
                            reappearingError = new ModelError.ReappearingError(string5, string6, list3, reappearDelayMinutes, null, 16, null);
                            return reappearingError;
                        }
                        case 1: {
                            Object[] objectArray = new Object[]{SmlIjBundle.message("aiplugin.product.name", new Object[0])};
                            ModelError.ReappearingError reappearingError3 = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.notification.access.restricted.notification.title", objectArray), SmlIjBundle.message("aiplugin.notification.access.restricted.notification.message.fallback", new Object[0]), CollectionsKt.emptyList(), reappearDelayMinutes, null, 16, null);
                            reappearingError = reappearingError3;
                            return reappearingError;
                        }
                    }
                }
                String string7 = SmlIjBundle.message("aiplugin.error.title.text", new Object[0]);
                String string8 = this.forUserDefinedProjectsOnly(SmlIjBundle.message("aiplugin.error.permission.denied.text", new Object[0]));
                if (this.userDefinedProjectUsed()) {
                    Object[] objectArray = new String[]{"EnableApi", "SelectProject", "OpenDocumentation"};
                    list = CollectionsKt.listOf((Object[])objectArray);
                } else {
                    list = CollectionsKt.listOf((Object)"SubmitFeedback");
                }
                reappearingError = new ModelError.ReappearingError(string7, string8, list, reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 12: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), this.userDefinedProjectUsed() ? SmlIjBundle.message("aiplugin.error.resource.exhausted.text.userDefinedProject", new Object[0]) : SmlIjBundle.message("aiplugin.error.resource.exhausted.text.managedProject", new Object[0]), this.userDefinedProjectUsed() ? CollectionsKt.listOf((Object)"OpenDocumentation") : CollectionsKt.listOf((Object)"OpenFaq"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 13: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.unauthenticated.text", new Object[0]), CollectionsKt.listOf((Object)"LogIn"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 14: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.unavailable.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 15: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.unimplemented.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 16: {
                reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.unknown.text", new Object[0]), CollectionsKt.listOf((Object)"SubmitFeedback"), reappearDelayMinutes, null, 16, null);
                return reappearingError;
            }
            case 17: {
                return null;
            }
        }
        reappearingError = new ModelError.ReappearingError(SmlIjBundle.message("aiplugin.error.title.text", new Object[0]), SmlIjBundle.message("aiplugin.error.network.text", new Object[0]), CollectionsKt.emptyList(), reappearDelayMinutes, null, 16, null);
        return reappearingError;
    }

    static /* synthetic */ ModelError.ReappearingError getModelErrorForStatus$default(AiPluginErrorHandler aiPluginErrorHandler, Status status2, long l2, GoogleJsonResponseException googleJsonResponseException, int n, Object object) {
        if ((n & 4) != 0) {
            googleJsonResponseException = null;
        }
        return aiPluginErrorHandler.getModelErrorForStatus(status2, l2, googleJsonResponseException);
    }

    private final long getReappearDelayMinutes(ErrorHandler.ErrorSource errorSource) {
        return WhenMappings.$EnumSwitchMapping$1[errorSource.ordinal()] == 1 ? this.reappearDelayMinutesForCompleteCode : 0L;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<String> filterByUserTier(@NotNull List<String> actionKeyNames) {
        Intrinsics.checkNotNullParameter(actionKeyNames, (String)"actionKeyNames");
        if (!this.userDefinedProjectUsed()) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = actionKeyNames;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)"SelectProject") || Intrinsics.areEqual((Object)it, (Object)"EnableApi")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return actionKeyNames;
    }

    private final boolean userDefinedProjectUsed() {
        boolean $i$f$service = false;
        Class<FeatureFlagsService> serviceClass$iv = FeatureFlagsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (!((FeatureFlagsService)object).tierAwareOnboardingEnabled()) {
            return true;
        }
        boolean $i$f$service2 = false;
        Class<UserTierService> serviceClass$iv2 = UserTierService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        UserTierService.State currentState2 = (UserTierService.State)((UserTierService)object2).getCurrentState().getValue();
        return currentState2 instanceof UserTierService.State.Ready ? Intrinsics.areEqual((Object)((UserTierService.State.Ready)currentState2).getCurrentUserTier().getUserDefinedCloudaicompanionProject(), (Object)true) : (currentState2 instanceof UserTierService.State.OnboardingCall ? Intrinsics.areEqual((Object)((UserTierService.State.OnboardingCall)currentState2).getTierToOnboard().getUserDefinedCloudaicompanionProject(), (Object)true) : false);
    }

    private final String forUserDefinedProjectsOnly(String text2) {
        return this.userDefinedProjectUsed() ? text2 : SmlIjBundle.message("aiplugin.error.for.managed.project", new Object[0]);
    }

    private final String getFallbackErrorMessageForSource(ErrorHandler.ErrorSource source, String errorMessage) {
        String string;
        if (WhenMappings.$EnumSwitchMapping$1[source.ordinal()] == 2) {
            string = SmlIjBundle.message("aiplugin.error.onboarding.text", new Object[0]);
        } else {
            string = errorMessage;
            if (string == null) {
                string = SmlIjBundle.message("aiplugin.error.unknown.text", new Object[0]);
            }
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/google/tools/intellij/aiplugin/AiPluginErrorHandler$ErrorActionKey;", "", "(Ljava/lang/String;I)V", "EnableApi", "SubmitFeedback", "OpenConfiguration", "OpenDocumentation", "OpenFaq", "SelectProject", "LogIn", "LearnMoreVpc", "SubmitDiffFeedback", "aiplugin.ij-platform"})
    public static final class ErrorActionKey
    extends Enum<ErrorActionKey> {
        public static final /* enum */ ErrorActionKey EnableApi = new ErrorActionKey();
        public static final /* enum */ ErrorActionKey SubmitFeedback = new ErrorActionKey();
        public static final /* enum */ ErrorActionKey OpenConfiguration = new ErrorActionKey();
        public static final /* enum */ ErrorActionKey OpenDocumentation = new ErrorActionKey();
        public static final /* enum */ ErrorActionKey OpenFaq = new ErrorActionKey();
        public static final /* enum */ ErrorActionKey SelectProject = new ErrorActionKey();
        public static final /* enum */ ErrorActionKey LogIn = new ErrorActionKey();
        public static final /* enum */ ErrorActionKey LearnMoreVpc = new ErrorActionKey();
        public static final /* enum */ ErrorActionKey SubmitDiffFeedback = new ErrorActionKey();
        private static final /* synthetic */ ErrorActionKey[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ErrorActionKey[] values() {
            return (ErrorActionKey[])$VALUES.clone();
        }

        public static ErrorActionKey valueOf(String value) {
            return Enum.valueOf(ErrorActionKey.class, value);
        }

        @NotNull
        public static EnumEntries<ErrorActionKey> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = errorActionKeyArray = new ErrorActionKey[]{ErrorActionKey.EnableApi, ErrorActionKey.SubmitFeedback, ErrorActionKey.OpenConfiguration, ErrorActionKey.OpenDocumentation, ErrorActionKey.OpenFaq, ErrorActionKey.SelectProject, ErrorActionKey.LogIn, ErrorActionKey.LearnMoreVpc, ErrorActionKey.SubmitDiffFeedback};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.ABORTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ALREADY_EXISTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.CLIENT_SIDE_RATE_LIMIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.DATA_LOSS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.DEADLINE_EXCEEDED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.FAILED_PRECONDITION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.INTERNAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.INVALID_ARGUMENT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.NOT_FOUND.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.OUT_OF_RANGE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.PERMISSION_DENIED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RESOURCE_EXHAUSTED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.UNAUTHENTICATED.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.UNAVAILABLE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.UNIMPLEMENTED.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.UNKNOWN.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.CANCELLED.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ErrorHandler.ErrorSource.values().length];
            try {
                nArray[ErrorHandler.ErrorSource.CompleteCode.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorHandler.ErrorSource.Onboarding.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

