/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices.session;

import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.FoldingRegionEnforcer;
import com.android.studio.ml.suggestion.controls.HintKind;
import com.android.studio.ml.suggestion.controls.InlineAcceptHintControl;
import com.android.studio.ml.suggestion.controls.RenderedByControl;
import com.android.studio.ml.suggestion.controls.ShowHintAtOffset;
import com.android.studio.ml.suggestion.controls.TabToProceedHintControl;
import com.android.studio.ml.suggestion.session.SuggestionControlSession;
import com.google.tools.aiplugin.editor.predictionservices.SuggestionSessionInvalidator;
import com.google.tools.aiplugin.editor.predictionservices.actions.NextEditPredictionProceedAction;
import com.google.tools.aiplugin.editor.predictionservices.controls.JumpToLocationControl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0003()*B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u0019H\u0003J\b\u0010#\u001a\u00020\u0019H\u0016J\u0006\u0010$\u001a\u00020\u001dJ\b\u0010%\u001a\u00020\u0019H\u0007J\b\u0010&\u001a\u00020\u001dH\u0007J\b\u0010'\u001a\u00020\u0019H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession;", "Lcom/android/studio/ml/suggestion/session/SuggestionControlSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "controls", "", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "Ljava/util/Queue;", "listener", "Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$AdvancementListener;", "foldingEnforcer", "Lcom/android/studio/ml/suggestion/controls/FoldingRegionEnforcer;", "tabToMoveControl", "Lcom/android/studio/ml/suggestion/controls/TabToProceedHintControl;", "inlineAcceptHintControl", "Lcom/android/studio/ml/suggestion/controls/InlineAcceptHintControl;", "state", "Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$State;", "invalidator", "Lcom/google/tools/aiplugin/editor/predictionservices/SuggestionSessionInvalidator;", "autoActivationCaretListener", "Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$AutoActivationCaretListener;", "setInvalidator", "", "setInvalidator$aiplugin_editor_prediction_services", "start", "isCaretAtControl", "", "control", "activateCurrentControl", "moveCaret", "showNextControl", "updateHint", "dispose", "canHandleProceedAction", "handleProceedAction", "canHandleCancelAction", "handleCancelAction", "AutoActivationCaretListener", "AdvancementListener", "State", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nNextEditPredictionControlSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditPredictionControlSession.kt\ncom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,242:1\n1#2:243\n1761#3,3:244\n24#4:247\n24#4:248\n*S KotlinDebug\n*F\n+ 1 NextEditPredictionControlSession.kt\ncom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession\n*L\n109#1:244,3\n141#1:247\n195#1:248\n*E\n"})
public final class NextEditPredictionControlSession
implements SuggestionControlSession {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Queue<EditorSuggestionControl> controls;
    @NotNull
    private final AdvancementListener listener;
    @NotNull
    private final FoldingRegionEnforcer foldingEnforcer;
    @Nullable
    private volatile TabToProceedHintControl tabToMoveControl;
    @Nullable
    private volatile InlineAcceptHintControl inlineAcceptHintControl;
    @NotNull
    private volatile State state;
    @Nullable
    private volatile SuggestionSessionInvalidator invalidator;
    @NotNull
    private final AutoActivationCaretListener autoActivationCaretListener;

    public NextEditPredictionControlSession(@NotNull Editor editor2, @NotNull List<? extends EditorSuggestionControl> controls2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(controls2, (String)"controls");
        this.editor = editor2;
        this.controls = new ConcurrentLinkedQueue(controls2);
        this.listener = new AdvancementListener();
        Project project2 = this.editor.getProject();
        if (project2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.foldingEnforcer = new FoldingRegionEnforcer(project2, this.editor, this);
        this.state = State.Initialized;
        this.autoActivationCaretListener = new AutoActivationCaretListener();
        if (!(!((Collection)controls2).isEmpty())) {
            boolean bl = false;
            String string = "Cannot create session with no controls.";
            throw new IllegalArgumentException(string.toString());
        }
        for (EditorSuggestionControl editorSuggestionControl : controls2) {
            Disposer.register((Disposable)this, (Disposable)editorSuggestionControl);
        }
    }

    public final void setInvalidator$aiplugin_editor_prediction_services(@NotNull SuggestionSessionInvalidator invalidator) {
        Intrinsics.checkNotNullParameter((Object)invalidator, (String)"invalidator");
        this.invalidator = invalidator;
    }

    @Override
    public void start() {
        for (EditorSuggestionControl control : this.controls) {
            control.addListener(this.listener, this);
        }
        Function0 activeControlProvider = () -> NextEditPredictionControlSession.start$lambda$0(this);
        Project project2 = this.editor.getProject();
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            v1 = new JumpToLocationControl(it, this.editor, this, (Function0<? extends EditorSuggestionControl>)activeControlProvider);
        } else {
            v1 = null;
        }
        EditorSuggestionControl editorSuggestionControl = this.controls.peek();
        if (editorSuggestionControl == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        EditorSuggestionControl nextControl = editorSuggestionControl;
        boolean isCaretAtControl = this.isCaretAtControl(nextControl);
        if (!nextControl.movesCodeOnShow() && isCaretAtControl) {
            this.activateCurrentControl(false);
        } else {
            this.editor.getCaretModel().addCaretListener((CaretListener)this.autoActivationCaretListener, (Disposable)this);
            this.tabToMoveControl = new TabToProceedHintControl(this.editor, (Function0<Integer>)((Function0)new Function0<Integer>((Object)nextControl){

                public final Integer invoke() {
                    return ((EditorSuggestionControl)this.receiver).caretOffsetForMove();
                }
            }), (AnAction)new NextEditPredictionProceedAction(), this, (Function0<? extends Rectangle>)((Function0)new Function0<Rectangle>((Object)nextControl){

                public final Rectangle invoke() {
                    return ((EditorSuggestionControl)this.receiver).getVisualBoundsInEditorComponent();
                }
            }));
            if (!nextControl.movesCodeOnShow()) {
                this.showNextControl(false);
            }
            this.state = State.Started;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCaretAtControl(EditorSuggestionControl control) {
        boolean bl;
        int caretOffset2 = this.editor.getCaretModel().getOffset();
        if (this.editor.logicalPositionToOffset(control.getLogicalPosition()) == caretOffset2) return true;
        Iterable $this$any$iv = control.getRangeMarkers();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            RangeMarker it = (RangeMarker)element$iv;
            boolean bl2 = false;
            int n = it.getStartOffset();
            if (caretOffset2 <= it.getEndOffset()) {
                if (n <= caretOffset2) {
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final void activateCurrentControl(boolean moveCaret) {
        this.editor.getCaretModel().removeCaretListener((CaretListener)this.autoActivationCaretListener);
        TabToProceedHintControl controlToDispose = this.tabToMoveControl;
        this.tabToMoveControl = null;
        TabToProceedHintControl tabToProceedHintControl = controlToDispose;
        if (tabToProceedHintControl != null) {
            TabToProceedHintControl it = tabToProceedHintControl;
            boolean bl = false;
            ApplicationKt.getApplication().invokeLater(() -> NextEditPredictionControlSession.activateCurrentControl$lambda$0$0(it));
        }
        this.state = State.ControlIsActive;
        this.showNextControl(moveCaret);
    }

    private final void showNextControl(boolean moveCaret) {
        EditorSuggestionControl nextControl = this.controls.peek();
        if (nextControl == null) {
            Disposer.dispose((Disposable)this);
            return;
        }
        for (RangeMarker marker : nextControl.getRangeMarkers()) {
            this.foldingEnforcer.keepExpanded(marker, nextControl);
        }
        this.foldingEnforcer.enforce();
        if (!nextControl.show()) {
            NextEditPredictionControlSession $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NextEditPredictionControlSession.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to show control: " + nextControl);
            Disposer.dispose((Disposable)this);
            return;
        }
        if (moveCaret) {
            this.editor.getCaretModel().moveToOffset(nextControl.caretOffsetForMove());
            if (!nextControl.isVisible()) {
                this.editor.getScrollingModel().scrollTo(nextControl.getLogicalPosition(), ScrollType.CENTER);
            }
        }
        this.updateHint();
    }

    @RequiresEdt
    private final void updateHint() {
        InlineAcceptHintControl inlineAcceptHintControl = this.inlineAcceptHintControl;
        if (inlineAcceptHintControl != null) {
            InlineAcceptHintControl it = inlineAcceptHintControl;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.inlineAcceptHintControl = null;
        if (this.state != State.ControlIsActive) {
            return;
        }
        EditorSuggestionControl editorSuggestionControl = this.controls.peek();
        if (editorSuggestionControl == null) {
            return;
        }
        EditorSuggestionControl activeControl = editorSuggestionControl;
        HintKind hintKind = activeControl.getHintKind();
        if (!(hintKind instanceof RenderedByControl)) {
            if (hintKind instanceof ShowHintAtOffset) {
                this.inlineAcceptHintControl = new InlineAcceptHintControl(this.editor, this, ((ShowHintAtOffset)hintKind).getOffset());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void dispose() {
        this.state = State.Disposed;
        this.controls.clear();
    }

    public final boolean canHandleProceedAction() {
        return this.state.getCanHandleProceed();
    }

    @RequiresEdt
    public final void handleProceedAction() {
        SuggestionSessionInvalidator suggestionSessionInvalidator = this.invalidator;
        if (suggestionSessionInvalidator != null) {
            suggestionSessionInvalidator.onProceedActionInvoked();
        }
        EditorSuggestionControl editorSuggestionControl = this.controls.peek();
        if (editorSuggestionControl == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        EditorSuggestionControl nextControl = editorSuggestionControl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.activateCurrentControl(true);
                break;
            }
            case 2: {
                if (!(this.tabToMoveControl == null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (nextControl.isVisible()) {
                    nextControl.accept();
                    break;
                }
                this.editor.getScrollingModel().scrollTo(nextControl.getLogicalPosition(), ScrollType.CENTER);
                break;
            }
            default: {
                NextEditPredictionControlSession $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(NextEditPredictionControlSession.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unexpected state for proceed: " + this.state);
            }
        }
    }

    @RequiresEdt
    public final boolean canHandleCancelAction() {
        return this.state.getCanHandleCancel();
    }

    @RequiresEdt
    public final void handleCancelAction() {
        EditorSuggestionControl editorSuggestionControl = this.controls.peek();
        if (editorSuggestionControl != null) {
            editorSuggestionControl.reject();
        }
        Disposer.dispose((Disposable)this);
    }

    private static final EditorSuggestionControl start$lambda$0(NextEditPredictionControlSession this$0) {
        return this$0.state == State.ControlIsActive ? this$0.controls.peek() : null;
    }

    private static final void activateCurrentControl$lambda$0$0(TabToProceedHintControl $it) {
        Disposer.dispose((Disposable)((Disposable)$it));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$AdvancementListener;", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl$Listener;", "<init>", "(Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession;)V", "advance", "", "onAccept", "onReject", "aiplugin.editor.prediction-services"})
    @SourceDebugExtension(value={"SMAP\nNextEditPredictionControlSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditPredictionControlSession.kt\ncom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$AdvancementListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1#2:243\n*E\n"})
    private final class AdvancementListener
    implements EditorSuggestionControl.Listener {
        private final void advance() {
            EditorSuggestionControl editorSuggestionControl = (EditorSuggestionControl)NextEditPredictionControlSession.this.controls.poll();
            if (editorSuggestionControl != null) {
                Disposable p0 = editorSuggestionControl;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            NextEditPredictionControlSession.this.showNextControl(true);
        }

        @Override
        public void onAccept() {
            this.advance();
        }

        @Override
        public void onReject() {
            Disposer.dispose((Disposable)NextEditPredictionControlSession.this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$AutoActivationCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "<init>", "(Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession;)V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "aiplugin.editor.prediction-services"})
    private final class AutoActivationCaretListener
    implements CaretListener {
        public void caretPositionChanged(@NotNull CaretEvent event) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (NextEditPredictionControlSession.this.state != State.Started) {
                    return;
                }
                EditorSuggestionControl editorSuggestionControl = (EditorSuggestionControl)NextEditPredictionControlSession.this.controls.peek();
                if (editorSuggestionControl == null) break block2;
                EditorSuggestionControl editorSuggestionControl2 = editorSuggestionControl;
                NextEditPredictionControlSession nextEditPredictionControlSession = NextEditPredictionControlSession.this;
                EditorSuggestionControl currentControl = editorSuggestionControl2;
                boolean bl = false;
                if (nextEditPredictionControlSession.isCaretAtControl(currentControl)) {
                    nextEditPredictionControlSession.activateCurrentControl(false);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$State;", "", "canHandleProceed", "", "canHandleCancel", "<init>", "(Ljava/lang/String;IZZ)V", "getCanHandleProceed", "()Z", "getCanHandleCancel", "Initialized", "Started", "ControlIsActive", "Disposed", "aiplugin.editor.prediction-services"})
    private static final class State
    extends Enum<State> {
        private final boolean canHandleProceed;
        private final boolean canHandleCancel;
        public static final /* enum */ State Initialized = new State(false, true);
        public static final /* enum */ State Started = new State(true, true);
        public static final /* enum */ State ControlIsActive = new State(true, true);
        public static final /* enum */ State Disposed = new State(false, false);
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private State(boolean canHandleProceed, boolean canHandleCancel) {
            this.canHandleProceed = canHandleProceed;
            this.canHandleCancel = canHandleCancel;
        }

        public final boolean getCanHandleProceed() {
            return this.canHandleProceed;
        }

        public final boolean getCanHandleCancel() {
            return this.canHandleCancel;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Initialized, State.Started, State.ControlIsActive, State.Disposed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.Started.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.ControlIsActive.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

