/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices.debug;

import com.android.studio.ml.suggestion.session.SuggestionControlSession;
import com.android.studio.ml.suggestion.session.SuggestionControlSessionManager;
import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.Differ;
import com.google.tools.aiplugin.editor.prediction.Prediction;
import com.google.tools.aiplugin.editor.prediction.PredictionEvent;
import com.google.tools.aiplugin.editor.predictionservices.PredictionService;
import com.google.tools.aiplugin.editor.predictionservices.debug.DebugDialogUtilsKt;
import com.google.tools.aiplugin.editor.predictionservices.debug.DiffHistoryEntry;
import com.google.tools.aiplugin.editor.predictionservices.debug.FileTarget;
import com.google.tools.aiplugin.editor.predictionservices.debug.InjectedDiffHistoryManager;
import com.google.tools.aiplugin.editor.predictionservices.session.NextEditPredictionControlSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020!H\u0002J\n\u0010#\u001a\u0004\u0018\u00010!H\u0002J\b\u0010$\u001a\u00020\u001dH\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u000eH\u0002J\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020!H\u0002J\b\u0010+\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00130\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00180\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/PredictionEventsPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "apply", "Ljavax/swing/JButton;", "saveDiff", "proceed", "inject", "lastPrediction", "Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "diffHistoryManager", "Lcom/google/tools/aiplugin/editor/predictionservices/debug/InjectedDiffHistoryManager;", "diffHistoryModel", "Ljavax/swing/DefaultComboBoxModel;", "Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffHistoryEntry;", "diffHistoryComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "kotlin.jvm.PlatformType", "fileComboBoxModel", "", "fileComboBox", "injectedDiffText", "Ljavax/swing/JTextArea;", "setupEventLogUI", "", "setupInjectionUI", "setupListeners", "parsePathFromDiff", "", "diffText", "getSelectedPath", "updateFileComboBox", "updateHistoryDropdown", "applyPrediction", "prediction", "injectPrediction", "path", "text", "proceedWithEditorNepSession", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nPredictionEventsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PredictionEventsPanel.kt\ncom/google/tools/aiplugin/editor/predictionservices/debug/PredictionEventsPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,361:1\n30#2,2:362\n30#2,2:380\n11228#3:364\n11563#3,3:365\n209#4,8:368\n24#5:376\n24#5:377\n24#5:378\n24#5:379\n1#6:382\n*S KotlinDebug\n*F\n+ 1 PredictionEventsPanel.kt\ncom/google/tools/aiplugin/editor/predictionservices/debug/PredictionEventsPanel\n*L\n151#1:362,2\n95#1:380,2\n271#1:364\n271#1:365,3\n287#1:368,8\n313#1:376\n319#1:377\n326#1:378\n332#1:379\n*E\n"})
public final class PredictionEventsPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final JButton apply;
    @NotNull
    private final JButton saveDiff;
    @NotNull
    private final JButton proceed;
    @NotNull
    private final JButton inject;
    @Nullable
    private Prediction lastPrediction;
    @NotNull
    private final InjectedDiffHistoryManager diffHistoryManager;
    @NotNull
    private final DefaultComboBoxModel<DiffHistoryEntry> diffHistoryModel;
    @NotNull
    private final ComboBox<DiffHistoryEntry> diffHistoryComboBox;
    @NotNull
    private final DefaultComboBoxModel<Object> fileComboBoxModel;
    @NotNull
    private final ComboBox<Object> fileComboBox;
    @NotNull
    private final JTextArea injectedDiffText;

    public PredictionEventsPanel(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(new BorderLayout());
        this.project = project2;
        this.apply = new JButton("Apply");
        this.saveDiff = new JButton("Save Diff");
        this.proceed = new JButton("Proceed via Editor");
        this.inject = new JButton("Inject Diff");
        this.diffHistoryManager = InjectedDiffHistoryManager.Companion.getInstance(this.project);
        this.diffHistoryModel = new DefaultComboBoxModel();
        this.diffHistoryComboBox = new ComboBox((ComboBoxModel)this.diffHistoryModel);
        this.fileComboBoxModel = new DefaultComboBoxModel();
        this.fileComboBox = new ComboBox((ComboBoxModel)this.fileComboBoxModel);
        this.injectedDiffText = new JTextArea();
        this.setupEventLogUI();
        this.setupInjectionUI();
        this.setupListeners(parentDisposable);
    }

    private final void setupEventLogUI() {
        JTextArea textArea = new JTextArea();
        JBScrollPane scrollPane = new JBScrollPane((Component)textArea);
        this.add((Component)scrollPane, "Center");
        textArea.setEditable(false);
        textArea.setBorder(IdeBorderFactory.createBorder());
        DefaultComboBoxModel<PredictionEvent> events = new DefaultComboBoxModel<PredictionEvent>();
        ComboBox combo = new ComboBox((ComboBoxModel)events);
        this.add((Component)combo, "North");
        JPanel controls2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.add((Component)controls2, "West");
        JButton predictButton = new JButton("Predict");
        predictButton.addActionListener(arg_0 -> PredictionEventsPanel.setupEventLogUI$lambda$0(this, arg_0));
        controls2.add(predictButton);
        this.apply.setEnabled(false);
        controls2.add(this.apply);
        this.apply.addActionListener(arg_0 -> PredictionEventsPanel.setupEventLogUI$lambda$1(events, this, textArea, arg_0));
        this.saveDiff.setEnabled(false);
        controls2.add(this.saveDiff);
        this.saveDiff.addActionListener(arg_0 -> PredictionEventsPanel.setupEventLogUI$lambda$2(this, arg_0));
        controls2.add(this.proceed);
        this.proceed.addActionListener(arg_0 -> PredictionEventsPanel.setupEventLogUI$lambda$3(this, arg_0));
        combo.addItemListener(arg_0 -> PredictionEventsPanel.setupEventLogUI$lambda$4(this, textArea, arg_0));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<PredictionService> serviceClass$iv = PredictionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        PredictionService service = (PredictionService)object;
        BuildersKt.launch$default((CoroutineScope)service.getCs(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(service, events, null){
            int label;
            final /* synthetic */ PredictionService $service;
            final /* synthetic */ DefaultComboBoxModel<PredictionEvent> $events;
            {
                this.$service = $service;
                this.$events = $events;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$service.getPredictor().getEvents().collect(new FlowCollector(this.$events){
                            final /* synthetic */ DefaultComboBoxModel<PredictionEvent> $events;
                            {
                                this.$events = $events;
                            }

                            public final Object emit(PredictionEvent event, Continuation<? super Unit> $completion) {
                                this.$events.addElement(event);
                                this.$events.setSelectedItem(event);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void setupInjectionUI() {
        JPanel injectPanel = new JPanel(new BorderLayout());
        this.add((Component)injectPanel, "South");
        JPanel injectControls = new JPanel((LayoutManager)new VerticalFlowLayout());
        injectPanel.add((Component)injectControls, "West");
        injectControls.add(this.inject);
        this.inject.addActionListener(arg_0 -> PredictionEventsPanel.setupInjectionUI$lambda$0(this, arg_0));
        JButton clearButton = new JButton("Clear");
        injectControls.add(clearButton);
        clearButton.addActionListener(arg_0 -> PredictionEventsPanel.setupInjectionUI$lambda$1(this, arg_0));
        injectControls.add((Component)new JBLabel("Target:"));
        this.fileComboBox.setEditable(true);
        this.updateFileComboBox();
        injectControls.add((Component)this.fileComboBox);
        injectPanel.add((Component)this.diffHistoryComboBox, "North");
        this.updateHistoryDropdown();
        this.diffHistoryComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                DiffHistoryEntry diffHistoryEntry = value instanceof DiffHistoryEntry ? (DiffHistoryEntry)value : null;
                this.setText(diffHistoryEntry != null ? diffHistoryEntry.getReason() : null);
                return this;
            }
        });
        this.diffHistoryComboBox.addItemListener(arg_0 -> PredictionEventsPanel.setupInjectionUI$lambda$2(this, arg_0));
        injectPanel.add((Component)this.injectedDiffText, "Center");
        this.injectedDiffText.setBorder(IdeBorderFactory.createBorder());
        this.injectedDiffText.setRows(10);
        this.injectedDiffText.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ PredictionEventsPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void insertUpdate(DocumentEvent e) {
                this.updateTargetFromDiff();
            }

            public void removeUpdate(DocumentEvent e) {
                this.updateTargetFromDiff();
            }

            public void changedUpdate(DocumentEvent e) {
                this.updateTargetFromDiff();
            }

            private final void updateTargetFromDiff() {
                int index;
                block5: {
                    int n;
                    String string = PredictionEventsPanel.access$getInjectedDiffText$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String string2 = PredictionEventsPanel.access$parsePathFromDiff(this.this$0, string);
                    if (string2 == null) {
                        return;
                    }
                    String pathFromDiff = string2;
                    Sequence<T> $this$indexOfFirst$iv = DebugDialogUtilsKt.asSequence(PredictionEventsPanel.access$getFileComboBoxModel$p(this.this$0));
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (E item$iv : $this$indexOfFirst$iv) {
                        if (index$iv < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        E it = item$iv;
                        boolean bl = false;
                        FileTarget fileTarget = it instanceof FileTarget ? (FileTarget)it : null;
                        if (Intrinsics.areEqual((Object)(fileTarget != null && (fileTarget = fileTarget.getFile()) != null ? fileTarget.getPath() : null), (Object)pathFromDiff)) {
                            n = index$iv;
                            break block5;
                        }
                        ++index$iv;
                    }
                    n = index = -1;
                }
                if (index >= 0 && PredictionEventsPanel.access$getFileComboBox$p(this.this$0).getSelectedIndex() != index) {
                    PredictionEventsPanel.access$getFileComboBox$p(this.this$0).setSelectedIndex(index);
                }
            }
        });
    }

    private final void setupListeners(Disposable parentDisposable) {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(parentDisposable);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ PredictionEventsPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                PredictionEventsPanel.access$updateFileComboBox(this.this$0);
            }

            public void fileClosed(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                PredictionEventsPanel.access$updateFileComboBox(this.this$0);
            }

            public void selectionChanged(FileEditorManagerEvent event) {
                int index;
                block6: {
                    int n;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    VirtualFile virtualFile2 = event.getNewFile();
                    if (virtualFile2 == null) {
                        return;
                    }
                    VirtualFile newFile = virtualFile2;
                    String string = PredictionEventsPanel.access$getInjectedDiffText$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String pathFromDiff = PredictionEventsPanel.access$parsePathFromDiff(this.this$0, string);
                    if (pathFromDiff != null && !Intrinsics.areEqual((Object)pathFromDiff, (Object)newFile.getPath())) {
                        return;
                    }
                    Sequence<T> $this$indexOfFirst$iv = DebugDialogUtilsKt.asSequence(PredictionEventsPanel.access$getFileComboBoxModel$p(this.this$0));
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (E item$iv : $this$indexOfFirst$iv) {
                        if (index$iv < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        E it = item$iv;
                        boolean bl = false;
                        FileTarget fileTarget = it instanceof FileTarget ? (FileTarget)it : null;
                        if (Intrinsics.areEqual((Object)(fileTarget != null ? fileTarget.getFile() : null), (Object)newFile)) {
                            n = index$iv;
                            break block6;
                        }
                        ++index$iv;
                    }
                    n = index = -1;
                }
                if (index >= 0) {
                    PredictionEventsPanel.access$getFileComboBox$p(this.this$0).setSelectedIndex(index);
                }
            }
        });
    }

    private final String parsePathFromDiff(String diffText) {
        Regex regex = new Regex("^---\\s+(\\S+)", RegexOption.MULTILINE);
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)diffText, (int)0, (int)2, null);
        return matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
    }

    private final String getSelectedPath() {
        Object selected = this.fileComboBox.getSelectedItem();
        return selected instanceof FileTarget ? ((FileTarget)selected).getFile().getPath() : (selected instanceof String ? (String)selected : null);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateFileComboBox() {
        Object $this$mapTo$iv$iv;
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$map$iv = virtualFileArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new FileTarget(this.project, (VirtualFile)it));
        }
        List openFiles = (List)destination$iv$iv;
        Object currentSelection = this.fileComboBox.getSelectedItem();
        $this$mapTo$iv$iv = currentSelection;
        boolean isCustomText = $this$mapTo$iv$iv instanceof FileTarget ? !openFiles.contains(currentSelection) : $this$mapTo$iv$iv instanceof String;
        this.fileComboBoxModel.removeAllElements();
        this.fileComboBoxModel.addAll(openFiles);
        if (isCustomText) {
            this.fileComboBox.getEditor().setItem(currentSelection);
        } else {
            VirtualFile[] virtualFileArray2 = FileEditorManager.getInstance((Project)this.project).getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getSelectedFiles(...)");
            VirtualFile activeFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray2);
            if (activeFile != null) {
                int index;
                block8: {
                    int n;
                    Sequence $this$indexOfFirst$iv = DebugDialogUtilsKt.asSequence((ComboBoxModel)this.fileComboBoxModel);
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        if (index$iv < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Object it = item$iv;
                        boolean bl = false;
                        FileTarget fileTarget = it instanceof FileTarget ? (FileTarget)it : null;
                        if (Intrinsics.areEqual((Object)(fileTarget != null ? fileTarget.getFile() : null), (Object)activeFile)) {
                            n = index$iv;
                            break block8;
                        }
                        ++index$iv;
                    }
                    n = index = -1;
                }
                if (index >= 0) {
                    this.fileComboBox.setSelectedIndex(index);
                }
            }
        }
    }

    private final void updateHistoryDropdown() {
        this.diffHistoryModel.removeAllElements();
        this.diffHistoryModel.addAll((Collection<DiffHistoryEntry>)this.diffHistoryManager.getHistory());
        this.diffHistoryComboBox.setSelectedItem(null);
    }

    private final void applyPrediction(Prediction prediction) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> PredictionEventsPanel.applyPrediction$lambda$0(prediction));
    }

    private final void injectPrediction(String path2, String text2) {
        Diff $this$injectPrediction_u24lambda_u2402;
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(path2);
        if (virtualFile2 == null) {
            PredictionEventsPanel $this$injectPrediction_u24lambda_u2402 = this;
            boolean bl = false;
            PredictionEventsPanel $this$thisLogger$iv = $this$injectPrediction_u24lambda_u2402;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PredictionEventsPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Could not find file for path: " + path2);
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile3);
        if (document2 == null) {
            PredictionEventsPanel $this$injectPrediction_u24lambda_u241 = this;
            boolean bl = false;
            PredictionEventsPanel $this$thisLogger$iv = $this$injectPrediction_u24lambda_u241;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PredictionEventsPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Could not get document for file: " + path2);
            return;
        }
        Document document3 = document2;
        try {
            $this$injectPrediction_u24lambda_u2402 = Diff.Companion.parseDiff(text2);
        }
        catch (Exception ex) {
            PredictionEventsPanel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PredictionEventsPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to parse injected diff", (Throwable)ex);
            return;
        }
        Diff diff = $this$injectPrediction_u24lambda_u2402;
        try {
            String string = document3.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            diff.apply(string);
        }
        catch (Exception ex) {
            PredictionEventsPanel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PredictionEventsPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to apply injected diff", (Throwable)ex);
            return;
        }
        PredictionService predictionService = PredictionService.Companion.getInstance(this.project);
        BuildersKt.launch$default((CoroutineScope)predictionService.getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(predictionService, path2, document3, diff, null){
            int label;
            final /* synthetic */ PredictionService $predictionService;
            final /* synthetic */ String $path;
            final /* synthetic */ Document $document;
            final /* synthetic */ Diff $diff;
            {
                this.$predictionService = $predictionService;
                this.$path = $path;
                this.$document = $document;
                this.$diff = $diff;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MutableSharedFlow<PredictionEvent> mutableSharedFlow = this.$predictionService.getPredictor().getEvents();
                        Path path2 = Paths.get(this.$path, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                        this.label = 1;
                        Object object3 = mutableSharedFlow.emit((Object)new PredictionEvent.Success(0, new Prediction("Manually injected prediction", path2, this.$document.getModificationStamp(), this.$diff, Differ.INSTANCE.diffToEditScript(this.$diff))), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void proceedWithEditorNepSession() {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null) {
            return;
        }
        TextEditor textEditor2 = textEditor;
        Editor editor2 = textEditor2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        SuggestionControlSession suggestionControlSession = SuggestionControlSessionManager.Companion.getInstance(this.project, editor2).getCurrentSession();
        NextEditPredictionControlSession nextEditPredictionControlSession = suggestionControlSession instanceof NextEditPredictionControlSession ? (NextEditPredictionControlSession)suggestionControlSession : null;
        if (nextEditPredictionControlSession == null) {
            return;
        }
        NextEditPredictionControlSession session2 = nextEditPredictionControlSession;
        if (session2.canHandleProceedAction()) {
            session2.handleProceedAction();
        }
    }

    private static final void setupEventLogUI$lambda$0(PredictionEventsPanel this$0, ActionEvent it) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<PredictionService> serviceClass$iv = PredictionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((PredictionService)object).predict();
    }

    private static final void setupEventLogUI$lambda$1(DefaultComboBoxModel $events, PredictionEventsPanel this$0, JTextArea $textArea, ActionEvent it) {
        block2: {
            Object object = $events.getSelectedItem();
            PredictionEvent.Success success = object instanceof PredictionEvent.Success ? (PredictionEvent.Success)object : null;
            if (success == null) break block2;
            PredictionEvent.Success it2 = success;
            boolean bl = false;
            try {
                this$0.applyPrediction(it2.getPrediction());
            }
            catch (Exception e) {
                $textArea.setText(e.getMessage());
            }
        }
    }

    private static final void setupEventLogUI$lambda$2(PredictionEventsPanel this$0, ActionEvent it) {
        block0: {
            Prediction prediction = this$0.lastPrediction;
            if (prediction == null) break block0;
            Prediction it2 = prediction;
            boolean bl = false;
            DiffHistoryEntry entry = new DiffHistoryEntry(it2.getReason(), it2.getDiff().toString());
            this$0.diffHistoryManager.add(entry);
            this$0.updateHistoryDropdown();
            this$0.requestFocusInWindow();
        }
    }

    private static final void setupEventLogUI$lambda$3(PredictionEventsPanel this$0, ActionEvent it) {
        this$0.proceedWithEditorNepSession();
    }

    private static final void setupEventLogUI$lambda$4(PredictionEventsPanel this$0, JTextArea $textArea, ItemEvent e) {
        if (e.getStateChange() == 1) {
            Object object = e.getItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.tools.aiplugin.editor.prediction.PredictionEvent");
            PredictionEvent event = (PredictionEvent)object;
            this$0.apply.setEnabled(false);
            this$0.saveDiff.setEnabled(false);
            PredictionEvent predictionEvent = event;
            if (predictionEvent instanceof PredictionEvent.Success) {
                this$0.lastPrediction = ((PredictionEvent.Success)event).getPrediction();
                $textArea.setText(((PredictionEvent.Success)event).getPrediction().getDiff() + "\n" + ((PredictionEvent.Success)event).getPrediction().getEs());
                this$0.apply.setEnabled(true);
                this$0.saveDiff.setEnabled(true);
            } else if (predictionEvent instanceof PredictionEvent.Fail) {
                $textArea.setText(((PredictionEvent.Fail)event).getMessage());
            } else if (predictionEvent instanceof PredictionEvent.Initiated) {
                $textArea.setText("Predicting...");
            } else if (predictionEvent instanceof PredictionEvent.Forced) {
                $textArea.setText("Force predicting...");
            } else if (predictionEvent instanceof PredictionEvent.LlmRequest) {
                $textArea.setText(((PredictionEvent.LlmRequest)event).getPrompt());
            } else if (predictionEvent instanceof PredictionEvent.LlmResponse) {
                $textArea.setText(((PredictionEvent.LlmResponse)event).getResponse());
            } else if (predictionEvent instanceof PredictionEvent.Outdated) {
                $textArea.setText(((PredictionEvent.Outdated)event).getPrediction().getDiff().toString());
                this$0.apply.setEnabled(false);
            } else if (predictionEvent instanceof PredictionEvent.Flushed) {
                $textArea.setText("[sync event]");
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void setupInjectionUI$lambda$0(PredictionEventsPanel this$0, ActionEvent it) {
        block0: {
            String string = this$0.getSelectedPath();
            if (string == null) break block0;
            String it2 = string;
            boolean bl = false;
            String string2 = this$0.injectedDiffText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            this$0.injectPrediction(it2, string2);
        }
    }

    private static final void setupInjectionUI$lambda$1(PredictionEventsPanel this$0, ActionEvent it) {
        this$0.injectedDiffText.setText("");
        this$0.diffHistoryComboBox.setSelectedItem(null);
        this$0.requestFocusInWindow();
    }

    private static final void setupInjectionUI$lambda$2(PredictionEventsPanel this$0, ItemEvent e) {
        if (e.getStateChange() == 1) {
            Object object = e.getItem();
            DiffHistoryEntry diffHistoryEntry = object instanceof DiffHistoryEntry ? (DiffHistoryEntry)object : null;
            if (diffHistoryEntry == null) {
                return;
            }
            DiffHistoryEntry selected = diffHistoryEntry;
            this$0.injectedDiffText.setText(selected.getDiffText());
        }
    }

    private static final void applyPrediction$lambda$0(Prediction $prediction) {
        block1: {
            Document document2;
            VirtualFile vf = LocalFileSystem.getInstance().findFileByNioFile($prediction.getPath());
            if (vf == null) break block1;
            Document document3 = document2 = FileDocumentManager.getInstance().getDocument(vf);
            if (document3 != null) {
                Diff diff = $prediction.getDiff();
                String string = document2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                document3.setText((CharSequence)diff.apply(string));
            }
        }
    }

    public static final /* synthetic */ String access$parsePathFromDiff(PredictionEventsPanel $this, String diffText) {
        return $this.parsePathFromDiff(diffText);
    }

    public static final /* synthetic */ JTextArea access$getInjectedDiffText$p(PredictionEventsPanel $this) {
        return $this.injectedDiffText;
    }

    public static final /* synthetic */ DefaultComboBoxModel access$getFileComboBoxModel$p(PredictionEventsPanel $this) {
        return $this.fileComboBoxModel;
    }

    public static final /* synthetic */ ComboBox access$getFileComboBox$p(PredictionEventsPanel $this) {
        return $this.fileComboBox;
    }

    public static final /* synthetic */ void access$updateFileComboBox(PredictionEventsPanel $this) {
        $this.updateFileComboBox();
    }
}

