/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices.debug;

import com.android.studio.ml.util.CoroutineScopesKt;
import com.google.tools.aiplugin.editor.prediction.Differ;
import com.google.tools.aiplugin.editor.prediction.EditScript;
import com.google.tools.aiplugin.editor.predictionservices.NextEditPredictionController;
import com.google.tools.aiplugin.editor.predictionservices.configuration.NextEditPredictionSettings;
import com.google.tools.aiplugin.editor.predictionservices.controls.ControlCreator;
import com.google.tools.aiplugin.editor.predictionservices.controls.ControlWithChunks;
import com.google.tools.aiplugin.editor.predictionservices.session.NextEditPredictionControlSession;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/ControlPlaygroundPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "controlPlaygroundEditor", "Lcom/intellij/openapi/editor/Editor;", "aggregationPolicyComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/google/tools/aiplugin/editor/predictionservices/controls/ControlCreator$AggregationPolicy;", "languageComboBox", "", "playgroundFile", "Lcom/intellij/testFramework/LightVirtualFile;", "currentBeforeText", "", "currentAfterText", "popularLanguages", "", "value", "selectedLanguageId", "getSelectedLanguageId", "()Ljava/lang/String;", "setSelectedLanguageId", "(Ljava/lang/String;)V", "setLanguage", "", "languageId", "updateEditorLanguage", "language", "Lcom/intellij/lang/Language;", "setText", "before", "after", "SectionHeader", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nControlPlaygroundPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlPlaygroundPanel.kt\ncom/google/tools/aiplugin/editor/predictionservices/debug/ControlPlaygroundPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,254:1\n774#2:255\n865#2,2:256\n1056#2:258\n3301#2,10:259\n37#3:269\n36#3,3:270\n37#3:273\n36#3,3:274\n*S KotlinDebug\n*F\n+ 1 ControlPlaygroundPanel.kt\ncom/google/tools/aiplugin/editor/predictionservices/debug/ControlPlaygroundPanel\n*L\n100#1:255\n100#1:256,2\n101#1:258\n103#1:259,10\n115#1:269\n115#1:270,3\n171#1:273\n171#1:274,3\n*E\n"})
public final class ControlPlaygroundPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor controlPlaygroundEditor;
    @NotNull
    private final ComboBox<ControlCreator.AggregationPolicy> aggregationPolicyComboBox;
    @NotNull
    private final ComboBox<Object> languageComboBox;
    @NotNull
    private final LightVirtualFile playgroundFile;
    @NotNull
    private String currentBeforeText;
    @NotNull
    private String currentAfterText;
    @NotNull
    private final Set<String> popularLanguages;

    /*
     * WARNING - void declaration
     */
    public ControlPlaygroundPanel(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        JButton jButton;
        void $this$_init__u24lambda_u245;
        void $this$_init__u24lambda_u244;
        void $this$sortedBy$iv;
        Language it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$_init__u24lambda_u240;
        Editor editor2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(new BorderLayout());
        this.project = project2;
        this.currentBeforeText = "";
        this.currentAfterText = "";
        Object[] objectArray = new String[]{"Java", "Kotlin", "Python", "XML", "JSON", "Plain text"};
        this.popularLanguages = SetsKt.setOf((Object[])objectArray);
        this.playgroundFile = new LightVirtualFile("control-playground.txt", (Language)PlainTextLanguage.INSTANCE, (CharSequence)this.currentBeforeText);
        Document document2 = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)this.playgroundFile));
        Intrinsics.checkNotNull((Object)document2);
        Document document3 = document2;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor editor3 = editor2 = editorFactory.createEditor(document3, this.project, (VirtualFile)this.playgroundFile, true);
        ControlPlaygroundPanel controlPlaygroundPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.getSettings().setLineNumbersShown(true);
        Disposer.register((Disposable)parentDisposable, () -> ControlPlaygroundPanel.lambda$0$0(editorFactory, (Editor)$this$_init__u24lambda_u240));
        Editor editor4 = editor2;
        Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"apply(...)");
        controlPlaygroundPanel.controlPlaygroundEditor = editor4;
        this.add((Component)this.controlPlaygroundEditor.getComponent(), "Center");
        JPanel playgroundControls = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.add((Component)playgroundControls, "West");
        playgroundControls.add((Component)new JBLabel("Language:"));
        Collection collection = Language.getRegisteredLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
        $this$_init__u24lambda_u240 = collection;
        boolean $i$f$filter = false;
        void var9_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Language)element$iv$iv;
            boolean bl2 = false;
            String string = it.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            boolean bl3 = ((CharSequence)string).length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List allLanguages = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Language it = (Language)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getDisplayName());
                it = (Language)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
            }
        });
        Iterable $this$partition$iv = allLanguages;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (Language)element$iv;
            boolean bl4 = false;
            boolean bl5 = this.popularLanguages.contains(it.getDisplayName()) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        editor3 = new Pair(first$iv, second$iv);
        List popular = (List)editor3.component1();
        List others = (List)editor3.component2();
        List comboItems = new ArrayList();
        if (!((Collection)popular).isEmpty()) {
            comboItems.add(new SectionHeader("Popular"));
            comboItems.addAll(popular);
        }
        if (!((Collection)others).isEmpty()) {
            comboItems.add(new SectionHeader("All Languages"));
            comboItems.addAll(others);
        }
        Collection $this$toTypedArray$iv = comboItems;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DefaultComboBoxModel<Object> languageModel = new DefaultComboBoxModel<Object>(thisCollection$iv.toArray(new Object[0]));
        Collection $i$f$toTypedArray22 = $this$toTypedArray$iv = new ComboBox((ComboBoxModel)languageModel);
        controlPlaygroundPanel = this;
        boolean bl6 = false;
        $this$_init__u24lambda_u244.setRenderer((ListCellRenderer)new SimpleListCellRenderer<Object>(){

            public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof SectionHeader) {
                    TitledSeparator titledSeparator;
                    TitledSeparator $this$getListCellRendererComponent_u24lambda_u240 = titledSeparator = new TitledSeparator(((SectionHeader)value).getTitle());
                    boolean bl = false;
                    $this$getListCellRendererComponent_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)2, (int)2));
                    return (Component)titledSeparator;
                }
                Component component2 = super.getListCellRendererComponent(list, value, index, selected, hasFocus);
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getListCellRendererComponent(...)");
                return component2;
            }

            public void customize(JList<? extends Object> list, Object value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                if (value instanceof Language) {
                    this.setText(((Language)value).getDisplayName());
                }
            }
        });
        $this$_init__u24lambda_u244.addItemListener(arg_0 -> ControlPlaygroundPanel.lambda$4$0((ComboBox)$this$_init__u24lambda_u244, this, arg_0));
        $this$_init__u24lambda_u244.setPrototypeDisplayValue((Object)"XXXXXXXXXX");
        $this$_init__u24lambda_u244.setSelectedItem((Object)PlainTextLanguage.INSTANCE);
        controlPlaygroundPanel.languageComboBox = $this$toTypedArray$iv;
        playgroundControls.add((Component)this.languageComboBox);
        playgroundControls.add((Component)new JBLabel("Aggregation policy:"));
        Collection $this$toTypedArray$iv2 = (Collection)ControlCreator.AggregationPolicy.getEntries();
        boolean $i$f$toTypedArray32 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        DefaultComboBoxModel<ControlCreator.AggregationPolicy> policyModel = new DefaultComboBoxModel<ControlCreator.AggregationPolicy>(thisCollection$iv2.toArray(new ControlCreator.AggregationPolicy[0]));
        Collection $i$f$toTypedArray32 = $this$toTypedArray$iv2 = new ComboBox((ComboBoxModel)policyModel);
        controlPlaygroundPanel = this;
        boolean bl7 = false;
        $this$_init__u24lambda_u245.setRenderer((ListCellRenderer)ControlCreator.AggregationPolicy.Companion.getLIST_CELL_RENDERER());
        $this$_init__u24lambda_u245.setSelectedItem((Object)NextEditPredictionSettings.Companion.getInstance().getAggregationPolicy());
        controlPlaygroundPanel.aggregationPolicyComboBox = $this$toTypedArray$iv2;
        playgroundControls.add((Component)this.aggregationPolicyComboBox);
        JButton injectControlsButton = new JButton("Inject Controls");
        injectControlsButton.addActionListener(arg_0 -> ControlPlaygroundPanel._init_$lambda$6(this, parentDisposable, arg_0));
        playgroundControls.add(injectControlsButton);
        JButton $this$_init__u24lambda_u247 = jButton = new JButton("Reset");
        boolean bl8 = false;
        $this$_init__u24lambda_u247.addActionListener(arg_0 -> ControlPlaygroundPanel.lambda$7$0(this, arg_0));
        JButton resetButton = jButton;
        playgroundControls.add(resetButton);
    }

    @Nullable
    public final String getSelectedLanguageId() {
        Object object = this.languageComboBox.getSelectedItem();
        Language language2 = object instanceof Language ? (Language)object : null;
        return language2 != null ? language2.getID() : null;
    }

    public final void setSelectedLanguageId(@Nullable String value) {
        if (value != null) {
            Language language2 = Language.findLanguageByID((String)value);
            if (language2 == null) {
                return;
            }
            Language language3 = language2;
            Object object = this.languageComboBox.getSelectedItem();
            Language language4 = object instanceof Language ? (Language)object : null;
            if (Intrinsics.areEqual((Object)(language4 != null ? language4.getID() : null), (Object)value)) {
                return;
            }
            this.languageComboBox.setSelectedItem((Object)language3);
        }
    }

    public final void setLanguage(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Language language2 = Language.findLanguageByID((String)languageId);
        if (language2 == null) {
            return;
        }
        Language language3 = language2;
        Object object = this.languageComboBox.getSelectedItem();
        Language language4 = object instanceof Language ? (Language)object : null;
        if (Intrinsics.areEqual((Object)(language4 != null ? language4.getID() : null), (Object)languageId)) {
            return;
        }
        this.languageComboBox.setSelectedItem((Object)language3);
    }

    private final void updateEditorLanguage(Language language2) {
        this.playgroundFile.setLanguage(language2);
        FileContentUtil.reparseFiles((Project)this.project, (Collection)CollectionsKt.listOf((Object)this.playgroundFile), (boolean)true);
        if (this.controlPlaygroundEditor instanceof EditorEx) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
            EditorColorsScheme scheme = editorColorsScheme;
            EditorHighlighter highlighter2 = EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter((VirtualFile)this.playgroundFile, scheme, this.project);
            ((EditorEx)this.controlPlaygroundEditor).setHighlighter(highlighter2);
        }
        this.controlPlaygroundEditor.getContentComponent().repaint();
    }

    public final void setText(@NotNull String before, @NotNull String after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        this.currentBeforeText = before;
        this.currentAfterText = after;
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> ControlPlaygroundPanel.setText$lambda$0(this, before));
    }

    private static final void lambda$0$0(EditorFactory $editorFactory, Editor $this_apply) {
        $editorFactory.releaseEditor($this_apply);
    }

    private static final void lambda$4$0(ComboBox $this_apply, ControlPlaygroundPanel this$0, ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getItem() instanceof SectionHeader) {
                int idx = $this_apply.getSelectedIndex();
                if (idx < $this_apply.getItemCount() - 1) {
                    $this_apply.setSelectedIndex(idx + 1);
                }
                return;
            }
            Object object = e.getItem();
            Language language2 = object instanceof Language ? (Language)object : null;
            if (language2 == null) {
                return;
            }
            Language selectedLanguage = language2;
            this$0.updateEditorLanguage(selectedLanguage);
        }
    }

    private static final void _init_$lambda$6(ControlPlaygroundPanel this$0, Disposable $parentDisposable, ActionEvent it) {
        EditScript editScript = Differ.INSTANCE.bestEditScript(this$0.currentBeforeText, this$0.currentAfterText);
        Object object = this$0.aggregationPolicyComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.tools.aiplugin.editor.predictionservices.controls.ControlCreator.AggregationPolicy");
        ControlCreator.AggregationPolicy selectedPolicy = (ControlCreator.AggregationPolicy)((Object)object);
        List<ControlWithChunks> controlsWithChunks = ControlCreator.Companion.getInstance(this$0.project).createControlsFromEditScript(editScript, this$0.controlPlaygroundEditor, selectedPolicy);
        if (controlsWithChunks.isEmpty()) {
            return;
        }
        CoroutineScope coroutineScope = CoroutineScopesKt.createCoroutineScope$default($parentDisposable, null, null, 3, null);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, controlsWithChunks, coroutineScope, null){
            int label;
            final /* synthetic */ ControlPlaygroundPanel this$0;
            final /* synthetic */ List<ControlWithChunks> $controlsWithChunks;
            final /* synthetic */ CoroutineScope $coroutineScope;
            {
                this.this$0 = $receiver;
                this.$controlsWithChunks = $controlsWithChunks;
                this.$coroutineScope = $coroutineScope;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = NextEditPredictionController.Companion.configureAndStartSession(ControlPlaygroundPanel.access$getProject$p(this.this$0), ControlPlaygroundPanel.access$getControlPlaygroundEditor$p(this.this$0), this.$controlsWithChunks, this.$coroutineScope, (Continuation<? super NextEditPredictionControlSession>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        ControlPlaygroundPanel.access$getControlPlaygroundEditor$p(this.this$0).getComponent().requestFocusInWindow();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void lambda$7$0(ControlPlaygroundPanel this$0, ActionEvent it) {
        WriteCommandAction.runWriteCommandAction((Project)this$0.project, () -> ControlPlaygroundPanel.lambda$7$0$0(this$0));
        this$0.controlPlaygroundEditor.getComponent().requestFocusInWindow();
    }

    private static final void lambda$7$0$0(ControlPlaygroundPanel this$0) {
        this$0.controlPlaygroundEditor.getDocument().setText((CharSequence)this$0.currentBeforeText);
    }

    private static final void setText$lambda$0(ControlPlaygroundPanel this$0, String $before) {
        if (!Intrinsics.areEqual((Object)this$0.controlPlaygroundEditor.getDocument().getText(), (Object)$before)) {
            this$0.controlPlaygroundEditor.getDocument().setText((CharSequence)$before);
        }
    }

    public static final /* synthetic */ Project access$getProject$p(ControlPlaygroundPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ Editor access$getControlPlaygroundEditor$p(ControlPlaygroundPanel $this) {
        return $this.controlPlaygroundEditor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/ControlPlaygroundPanel$SectionHeader;", "", "title", "", "<init>", "(Ljava/lang/String;)V", "getTitle", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.editor.prediction-services"})
    private static final class SectionHeader {
        @NotNull
        private final String title;

        public SectionHeader(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            this.title = title;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String component1() {
            return this.title;
        }

        @NotNull
        public final SectionHeader copy(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            return new SectionHeader(title);
        }

        public static /* synthetic */ SectionHeader copy$default(SectionHeader sectionHeader, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = sectionHeader.title;
            }
            return sectionHeader.copy(string);
        }

        @NotNull
        public String toString() {
            return "SectionHeader(title=" + this.title + ")";
        }

        public int hashCode() {
            return this.title.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SectionHeader)) {
                return false;
            }
            SectionHeader sectionHeader = (SectionHeader)other;
            return Intrinsics.areEqual((Object)this.title, (Object)sectionHeader.title);
        }
    }
}

