/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction.grouping;

import com.google.tools.aiplugin.editor.prediction.grouping.DeltaWithMetadata;
import com.google.tools.aiplugin.editor.prediction.grouping.GroupedChange;
import com.google.tools.aiplugin.editor.prediction.grouping.GroupingJustification;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0005*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/grouping/IntraPsiGravity;", "Lcom/google/tools/aiplugin/editor/prediction/grouping/GroupingJustification;", "<init>", "()V", "LINE_BREAK_COST", "", "BASE_REACH", "GRAVITY_COEFFICIENT", "", "tryGroup", "Lcom/google/tools/aiplugin/editor/prediction/grouping/GroupedChange;", "deltas", "", "Lcom/google/tools/aiplugin/editor/prediction/grouping/DeltaWithMetadata;", "startIndex", "mass", "getMass", "(Lcom/google/tools/aiplugin/editor/prediction/grouping/DeltaWithMetadata;)I", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nGroupingJustification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupingJustification.kt\ncom/google/tools/aiplugin/editor/prediction/grouping/IntraPsiGravity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1#2:327\n*E\n"})
public final class IntraPsiGravity
implements GroupingJustification {
    @NotNull
    public static final IntraPsiGravity INSTANCE = new IntraPsiGravity();
    private static final int LINE_BREAK_COST = 5;
    private static final int BASE_REACH = 5;
    private static final double GRAVITY_COEFFICIENT = 1.25;

    private IntraPsiGravity() {
    }

    @Override
    @Nullable
    public GroupedChange tryGroup(@NotNull List<DeltaWithMetadata> deltas, int startIndex) {
        DeltaWithMetadata.PsiGroupingData psiGroupingData;
        Intrinsics.checkNotNullParameter(deltas, (String)"deltas");
        DeltaWithMetadata first = deltas.get(startIndex);
        DeltaWithMetadata.PsiGroupingData it = psiGroupingData = first.getPsiGroupingData();
        boolean bl = false;
        DeltaWithMetadata.PsiGroupingData psiGroupingData2 = !Intrinsics.areEqual((Object)it, (Object)DeltaWithMetadata.PsiGroupingData.Companion.getEMPTY()) ? psiGroupingData : null;
        if (psiGroupingData2 == null) {
            return null;
        }
        DeltaWithMetadata.PsiGroupingData psiGroupingData3 = psiGroupingData2;
        int accumulatedMass = this.getMass(first);
        int endIndex = startIndex;
        int i2 = startIndex + 1;
        int n = deltas.size();
        while (i2 < n) {
            double maxReach;
            int lineBreakCost;
            int charDistanceCost;
            int gapCost;
            DeltaWithMetadata prev = deltas.get(i2 - 1);
            DeltaWithMetadata curr = deltas.get(i2);
            if (!Intrinsics.areEqual((Object)curr.getPsiGroupingData(), (Object)psiGroupingData3) || !((double)(gapCost = (charDistanceCost = curr.getLineNumber() == prev.getLineNumber() ? curr.getDistanceFromPrevious() : curr.getDelta().getOffset()) + (lineBreakCost = (curr.getLineNumber() - prev.getLineNumber()) * 5)) <= (maxReach = (double)5 + Math.sqrt((double)(accumulatedMass * this.getMass(curr)) * 1.25)))) break;
            accumulatedMass += this.getMass(curr) + gapCost;
            endIndex = i2++;
        }
        if (endIndex == startIndex) {
            return null;
        }
        return new GroupedChange.MultiDeltaGroup(deltas.subList(startIndex, endIndex + 1), this);
    }

    private final int getMass(DeltaWithMetadata $this$mass) {
        return Math.max($this$mass.getDelta().getBefore().length(), $this$mass.getDelta().getAfter().length());
    }
}

