/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.Delta;
import com.google.tools.aiplugin.editor.prediction.Differ;
import com.google.tools.aiplugin.editor.prediction.EditScriptKt;
import com.google.tools.aiplugin.editor.prediction.LineAction;
import com.google.tools.aiplugin.editor.prediction.LineEdit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/EditScript;", "", "edits", "", "Lcom/google/tools/aiplugin/editor/prediction/LineEdit;", "<init>", "(Ljava/util/List;)V", "getEdits", "()Ljava/util/List;", "toString", "", "apply", "document", "invert", "isEmpty", "", "distance", "", "aiplugin.editor.prediction"})
@SourceDebugExtension(value={"SMAP\nEditScript.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditScript.kt\ncom/google/tools/aiplugin/editor/prediction/EditScript\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1869#2,2:236\n1#3:238\n*S KotlinDebug\n*F\n+ 1 EditScript.kt\ncom/google/tools/aiplugin/editor/prediction/EditScript\n*L\n76#1:236,2\n*E\n"})
public final class EditScript {
    @NotNull
    private final List<LineEdit> edits;

    public EditScript(@NotNull List<LineEdit> edits) {
        Intrinsics.checkNotNullParameter(edits, (String)"edits");
        this.edits = edits;
    }

    @NotNull
    public final List<LineEdit> getEdits() {
        return this.edits;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.edits, (CharSequence)"\n", null, null, (int)0, null, EditScript::toString$lambda$0, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String apply(@NotNull String document2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        List<String> lines = Differ.INSTANCE.splitWithNewLines(document2);
        List newLines = new ArrayList();
        int last = 0;
        Iterable $this$forEach$iv = this.edits;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            LineEdit it = (LineEdit)element$iv;
            boolean bl = false;
            newLines.addAll((Collection)lines.subList(last, it.getLine() - 1));
            last = it.getLine() - 1;
            LineAction lineAction = it.getAction();
            if (lineAction instanceof LineAction.Add) {
                newLines.add(((LineAction.Add)it.getAction()).getAfter());
                continue;
            }
            if (lineAction instanceof LineAction.Delete) {
                if (last >= lines.size()) {
                    throw new IllegalStateException("Trying to delete a line past the end of the document.");
                }
                if (!Intrinsics.areEqual((Object)((LineAction.Delete)it.getAction()).getBefore(), (Object)lines.get(last))) {
                    throw new IllegalStateException("Unexpected line #" + (last + 1) + ":\n" + ((LineAction.Delete)it.getAction()).getBefore() + "\nFound:\n" + lines.get(last));
                }
                n = last;
                last = n + 1;
                continue;
            }
            if (lineAction instanceof LineAction.Edit) {
                void $this$apply_u24lambda_u240_u240;
                StringBuilder stringBuilder;
                if (!Intrinsics.areEqual((Object)((LineAction.Edit)it.getAction()).getBefore(), (Object)lines.get(last))) {
                    throw new IllegalStateException("Unexpected line #" + (last + 1) + ":\n" + ((LineAction.Edit)it.getAction()).getBefore() + "\nFound:\n" + lines.get(last));
                }
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                List list = newLines;
                boolean bl2 = false;
                int offset2 = 0;
                for (Delta delta : ((LineAction.Edit)it.getAction()).getDeltas()) {
                    String string = ((LineAction.Edit)it.getAction()).getBefore().substring(offset2, delta.getOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$apply_u24lambda_u240_u240.append(string);
                    $this$apply_u24lambda_u240_u240.append(delta.getAfter());
                    offset2 = delta.getOffset() + delta.getBefore().length();
                }
                String string = ((LineAction.Edit)it.getAction()).getBefore().substring(offset2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$apply_u24lambda_u240_u240.append(string);
                list.add(stringBuilder.toString());
                n = last;
                last = n + 1;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        newLines.addAll((Collection)lines.subList(last, lines.size()));
        return CollectionsKt.joinToString$default((Iterable)newLines, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final EditScript invert() {
        List reversed = new ArrayList();
        for (LineEdit edit : this.edits) {
            LineAction lineAction;
            LineAction lineAction2 = edit.getAction();
            if (lineAction2 instanceof LineAction.Add) {
                lineAction = new LineAction.Delete(((LineAction.Add)edit.getAction()).getAfter());
            } else if (lineAction2 instanceof LineAction.Delete) {
                lineAction = new LineAction.Add(((LineAction.Delete)edit.getAction()).getBefore());
            } else if (lineAction2 instanceof LineAction.Edit) {
                lineAction = new LineAction.Edit(((LineAction.Edit)edit.getAction()).getAfter(), ((LineAction.Edit)edit.getAction()).getBefore(), EditScriptKt.access$invert(((LineAction.Edit)edit.getAction()).getDeltas()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            LineAction action = lineAction;
            reversed.add(new LineEdit(edit.getTarget(), action, edit.getLine()));
        }
        return new EditScript(reversed);
    }

    public final boolean isEmpty() {
        return this.edits.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final int distance() {
        Iterable iterable = this.edits;
        int n = 0;
        for (Object t : iterable) {
            void it;
            LineEdit lineEdit = (LineEdit)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getAction().distance();
            n = n2 + n3;
        }
        return n;
    }

    private static final CharSequence toString$lambda$0(LineEdit edit) {
        Intrinsics.checkNotNullParameter((Object)edit, (String)"edit");
        return edit.getLine() + ">" + edit.getTarget() + ": " + edit.getAction();
    }
}

