/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.ui.components;

import com.google.cloud.tools.intellij.IntellijPluginCoreMessageBundle;
import com.intellij.ui.table.JBTable;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a&\u0010\u0004\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"resizeColumnWidths", "", "table", "Lcom/intellij/ui/table/JBTable;", "configureEmptyText", "isLoading", "", "loadingText", "", "defaultEmptyText", "aiplugin.cloudcode-core"})
public final class TableUtilKt {
    public static final void resizeColumnWidths(@NotNull JBTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        int totalWidth = 0;
        int paddingWidth = 10;
        int n = table.getColumnCount();
        for (int columnIndex = 0; columnIndex < n; ++columnIndex) {
            boolean isLastColumn;
            TableColumn column = table.getColumnModel().getColumn(columnIndex);
            int width = table.getExpandedColumnWidth(columnIndex) + paddingWidth;
            boolean bl = isLastColumn = columnIndex == table.getColumnCount() - 1;
            if (isLastColumn) {
                column.setPreferredWidth(table.getParent().getSize().width - totalWidth);
                continue;
            }
            column.setPreferredWidth(width);
            totalWidth += width;
        }
    }

    public static final void configureEmptyText(@NotNull JBTable $this$configureEmptyText, boolean isLoading, @NotNull String loadingText, @NotNull String defaultEmptyText) {
        Intrinsics.checkNotNullParameter((Object)$this$configureEmptyText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)loadingText, (String)"loadingText");
        Intrinsics.checkNotNullParameter((Object)defaultEmptyText, (String)"defaultEmptyText");
        if (isLoading) {
            $this$configureEmptyText.getEmptyText().setText(loadingText);
        } else {
            $this$configureEmptyText.getEmptyText().setText(defaultEmptyText);
        }
    }

    public static /* synthetic */ void configureEmptyText$default(JBTable jBTable, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            String string3 = IntellijPluginCoreMessageBundle.message("table.default.loading", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            string = string3;
        }
        if ((n & 4) != 0) {
            String string4 = IntellijPluginCoreMessageBundle.message("table.default.empty", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            string2 = string4;
        }
        TableUtilKt.configureEmptyText(jBTable, bl, string, string2);
    }
}

