/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.service;

import androidx.annotation.OpenForTesting;
import com.google.cloud.tools.intellij.service.IEndpointOverrideUrl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import java.net.InetAddress;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\bH\u0017R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/cloud/tools/intellij/service/ApiEndpointOverride;", "", "<init>", "()V", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "getRootUrl", "", "endpointOverrideUrl", "Lcom/google/cloud/tools/intellij/service/IEndpointOverrideUrl;", "setRootUrlOverride", "", "url", "isValidUrl", "", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nApiEndpointOverride.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiEndpointOverride.kt\ncom/google/cloud/tools/intellij/service/ApiEndpointOverride\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n24#2:70\n*S KotlinDebug\n*F\n+ 1 ApiEndpointOverride.kt\ncom/google/cloud/tools/intellij/service/ApiEndpointOverride\n*L\n48#1:70\n*E\n"})
public class ApiEndpointOverride {
    private final PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();

    @OpenForTesting
    @NotNull
    public String getRootUrl(@NotNull IEndpointOverrideUrl endpointOverrideUrl) {
        Intrinsics.checkNotNullParameter((Object)endpointOverrideUrl, (String)"endpointOverrideUrl");
        String string = this.propertiesComponent.getValue(endpointOverrideUrl.getPropertyKey(), endpointOverrideUrl.getDefaultUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String url = string;
        return this.isValidUrl(url) ? url : endpointOverrideUrl.getDefaultUrl();
    }

    @OpenForTesting
    public void setRootUrlOverride(@NotNull IEndpointOverrideUrl endpointOverrideUrl, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)endpointOverrideUrl, (String)"endpointOverrideUrl");
        CharSequence charSequence = url;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.propertiesComponent.setValue(endpointOverrideUrl.getPropertyKey(), null);
        } else {
            this.propertiesComponent.setValue(endpointOverrideUrl.getPropertyKey(), url);
        }
    }

    @OpenForTesting
    public boolean isValidUrl(@NotNull String url) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            String host = new URI(url).getHost();
            InetAddress.getByName(host);
            bl = true;
        }
        catch (Exception exp) {
            ApiEndpointOverride $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ApiEndpointOverride.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to connect to " + url, (Throwable)exp);
            bl = false;
        }
        return bl;
    }
}

