/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.project;

import com.google.cloud.tools.intellij.IntellijPluginCoreMessageBundle;
import com.google.cloud.tools.intellij.login.ui.BaseGoogleLoginUi;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.miginfocom.swing.MigLayout;

public class ProjectSelectorSignInPanel
extends BaseGoogleLoginUi {
    private JBLabel errorMessageLabel;
    private JProgressBar progressBar;
    private JPanel contentPanel;

    ProjectSelectorSignInPanel(String dialogMessage) {
        super(dialogMessage);
        this.init();
    }

    private void init() {
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("insets 0, fill"));
        this.errorMessageLabel = new JBLabel();
        this.errorMessageLabel.setForeground((Color)JBColor.RED);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString(IntellijPluginCoreMessageBundle.getString("login.progress.title", new Object[0]));
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        this.contentPanel.add((Component)this.progressBar, "hidemode 3, growx, wrap");
        this.contentPanel.add((Component)this.errorMessageLabel, "hidemode 3, grow, gapy 10");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.anchor = 18;
        this.add((Component)this.contentPanel, constraints);
    }

    public void showProgressBar() {
        this.progressBar.setVisible(true);
    }

    public void showProgressBar(String message) {
        this.progressBar.setString(message);
        this.progressBar.setVisible(true);
    }

    public void hideProgressBar() {
        this.progressBar.setVisible(false);
    }

    public void hideProgressBar(String message) {
        this.progressBar.setVisible(false);
        this.progressBar.setString(message);
    }

    public void showErrorMessage(String message) {
        this.errorMessageLabel.setText(message);
        this.errorMessageLabel.setVisible(true);
    }

    public void hideErrorMessage() {
        this.errorMessageLabel.setVisible(false);
    }
}

