/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.experimentation;

import androidx.annotation.OpenForTesting;
import com.google.api.services.cloudcode_pa.v1internal.model.Flag;
import com.google.api.services.cloudcode_pa.v1internal.model.ListExperimentsResponse;
import com.google.cloud.tools.intellij.experimentation.ExperimentFlag;
import com.google.cloud.tools.intellij.experimentation.FlagType;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0017J\u0014\u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0017J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0017J\u001f\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a\u00a2\u0006\u0002\u0010\u001bJ-\u0010\u001c\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0002\u00a2\u0006\u0002\u0010\u001eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/google/cloud/tools/intellij/experimentation/ExperimentationCache;", "", "<init>", "()V", "currentResponse", "Lcom/google/api/services/cloudcode_pa/v1internal/model/ListExperimentsResponse;", "getCurrentResponse", "()Lcom/google/api/services/cloudcode_pa/v1internal/model/ListExperimentsResponse;", "setCurrentResponse", "(Lcom/google/api/services/cloudcode_pa/v1internal/model/ListExperimentsResponse;)V", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "updateCurrentExperiment", "", "start", "runScheduledSync", "reschedule", "future", "getExperimentIds", "", "", "getFlags", "Lcom/google/api/services/cloudcode_pa/v1internal/model/Flag;", "getValue", "T", "flag", "Lcom/google/cloud/tools/intellij/experimentation/ExperimentFlag;", "(Lcom/google/cloud/tools/intellij/experimentation/ExperimentFlag;)Ljava/lang/Object;", "getValueFromFlag", "flagValue", "(Lcom/google/api/services/cloudcode_pa/v1internal/model/Flag;Lcom/google/cloud/tools/intellij/experimentation/ExperimentFlag;)Ljava/lang/Object;", "Companion", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nExperimentationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExperimentationCache.kt\ncom/google/cloud/tools/intellij/experimentation/ExperimentationCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1208#2,2:85\n1236#2,4:87\n*S KotlinDebug\n*F\n+ 1 ExperimentationCache.kt\ncom/google/cloud/tools/intellij/experimentation/ExperimentationCache\n*L\n62#1:85,2\n62#1:87,4\n*E\n"})
public abstract class ExperimentationCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile ListExperimentsResponse currentResponse = new ListExperimentsResponse();
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    private static final long EXPERIMENT_SYNC_DELAY_MILLIS = TimeUnit.HOURS.toMillis(1L);

    @NotNull
    public final ListExperimentsResponse getCurrentResponse() {
        return this.currentResponse;
    }

    public final void setCurrentResponse(@NotNull ListExperimentsResponse listExperimentsResponse) {
        Intrinsics.checkNotNullParameter((Object)listExperimentsResponse, (String)"<set-?>");
        this.currentResponse = listExperimentsResponse;
    }

    public abstract void updateCurrentExperiment();

    public void start() {
        this.runScheduledSync();
    }

    @OpenForTesting
    public void runScheduledSync() {
        ScheduledFuture<?> scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> ExperimentationCache.runScheduledSync$lambda$0(this), 0L, EXPERIMENT_SYNC_DELAY_MILLIS, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
        this.reschedule(scheduledFuture);
    }

    private final void reschedule(ScheduledFuture<?> future) {
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.scheduledFuture = future;
    }

    @OpenForTesting
    @NotNull
    public List<Integer> getExperimentIds() {
        List list = this.currentResponse.getExperimentIds();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @OpenForTesting
    @NotNull
    public List<Flag> getFlags() {
        List list = this.currentResponse.getFlags();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T getValue(@NotNull ExperimentFlag<T> flag) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        Iterable $this$associateBy$iv = this.getFlags();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Flag flag2 = (Flag)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getName(), element$iv$iv);
        }
        Flag flagValue = (Flag)destination$iv$iv.get(flag.getName());
        T t = this.getValueFromFlag(flagValue, flag);
        if (t == null) {
            t = flag.getDefaultValue();
        }
        return t;
    }

    private final <T> T getValueFromFlag(Flag flagValue, ExperimentFlag<T> flag) {
        Object object;
        FlagType<T> flagType = flag.getFlagType();
        if (Intrinsics.areEqual(flagType, (Object)FlagType.BOOLEAN.INSTANCE)) {
            Flag flag2 = flagValue;
            object = flag2 != null ? flag2.getBoolValue() : null;
        } else if (Intrinsics.areEqual(flagType, (Object)FlagType.STRING.INSTANCE)) {
            Flag flag3 = flagValue;
            object = flag3 != null ? flag3.getStringValue() : null;
        } else if (Intrinsics.areEqual(flagType, (Object)FlagType.DOUBLE.INSTANCE)) {
            Flag flag4 = flagValue;
            object = flag4 != null ? flag4.getFloatValue() : null;
        } else if (Intrinsics.areEqual(flagType, (Object)FlagType.LONG.INSTANCE)) {
            Flag flag5 = flagValue;
            object = flag5 != null ? flag5.getIntValue() : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Boolean bl = object;
        if (object == null) {
            bl = null;
        }
        return (T)bl;
    }

    private static final void runScheduledSync$lambda$0(ExperimentationCache this$0) {
        this$0.updateCurrentExperiment();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/google/cloud/tools/intellij/experimentation/ExperimentationCache$Companion;", "", "<init>", "()V", "EXPERIMENT_SYNC_DELAY_MILLIS", "", "aiplugin.cloudcode-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

