/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics.firelog;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class HatsResponse {
    private final List<RatingResponse> rating_response;
    private final List<OpenTextResponse> open_text_response;
    private final HatsMetadata hats_metadata;

    public HatsResponse(@Nullable List<RatingResponse> rating_response, @Nullable List<OpenTextResponse> open_text_response, @NotNull HatsResponseType responseType, String siteName, @NotNull String currentHatsSurveyInstanceId) {
        this.rating_response = rating_response;
        this.open_text_response = open_text_response;
        this.hats_metadata = new HatsMetadata(siteName, responseType.get(), currentHatsSurveyInstanceId);
    }

    @VisibleForTesting
    public List<RatingResponse> getRatingResponse() {
        return this.rating_response;
    }

    @VisibleForTesting
    public List<OpenTextResponse> getOpenTextResponse() {
        return this.open_text_response;
    }

    @VisibleForTesting
    public HatsMetadata getHatsMetadata() {
        return this.hats_metadata;
    }

    public String toString() {
        return "HatsResponse{rating_response=" + String.valueOf(this.rating_response) + ",\n open_text_response=" + String.valueOf(this.open_text_response) + ",\n hats_metadata=" + String.valueOf(this.hats_metadata) + "}";
    }

    public static class HatsMetadata {
        private final String site_name;
        private final String response_type;
        @SerializedName(value="survey_instance_id")
        private final String surveyInstanceId;

        HatsMetadata(@NotNull String siteName, @NotNull String responseType, @NotNull String currentHatsSurveyInstanceId) {
            this.site_name = siteName;
            this.response_type = responseType;
            this.surveyInstanceId = currentHatsSurveyInstanceId;
        }

        @VisibleForTesting
        public String getResponseType() {
            return this.response_type;
        }

        public String toString() {
            return "HatsMetadata{response_type='" + this.response_type + "', surveyInstanceId=" + this.surveyInstanceId + "}";
        }
    }

    public static enum HatsResponseType {
        NO_RESPONSE("NO_RESPONSE"),
        PARTIAL_RESPONSE("PARTIAL_RESPONSE"),
        UNKNOWN_TYPE("UNKNOWN_TYPE"),
        FULL_RESPONSE("FULL_RESPONSE");

        private final String responseType;

        public String get() {
            return this.responseType;
        }

        private HatsResponseType(String responseType) {
            this.responseType = responseType;
        }
    }

    public static class OpenTextResponse {
        private final int question_number;
        private final String answer_text;

        public OpenTextResponse(int question_number, @NotNull String answer_text) {
            this.question_number = question_number;
            this.answer_text = answer_text;
        }

        @VisibleForTesting
        public int getQuestionNumber() {
            return this.question_number;
        }

        @VisibleForTesting
        public String getAnswerText() {
            return this.answer_text;
        }

        public String toString() {
            return "OpenTextResponse{question_number=" + this.question_number + ", answer_text='" + this.answer_text + "}";
        }
    }

    public static class RatingResponse {
        private final int question_number;
        private final int rating;

        public RatingResponse(int question_number, int rating) {
            this.question_number = question_number;
            this.rating = rating;
        }

        @VisibleForTesting
        public int getQuestionNumber() {
            return this.question_number;
        }

        @VisibleForTesting
        public int getRating() {
            return this.rating;
        }

        public String toString() {
            return "RatingResponse{question_number=" + this.question_number + ", rating=" + this.rating + "}";
        }
    }
}

