/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.doc;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolCallMetadata;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.rag.doc.KbIndexerService;
import com.google.aiplugin.rag.doc.KbIndexerUtilsKt;
import com.google.aiplugin.rag.doc.KbSearchTool;
import com.google.aiplugin.rag.doc.KbSearchTool$Args$;
import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Searches authoritative, high-quality Android developer documentation in the Android Knowledge base.", description="\nBy providing a few keywords, this tool will return high quality articles that\ncontain examples or guidance on how to use Android APIs or libraries.\nUse this tool to obtain additional information on how to achieve Android-specific tasks\nor to know more about Android APIs, surfaces, libraries or devices.\n\nAlways use this tool to get the most up-to-date information about Android concepts. Typical\ngood use cases are:\n  - Finding migration guides for APIs.\n  - Finding examples for APIs.\n  - Finding up-to-date information about Android APIs.\n  - Finding best practices for Android concepts.\n", instructions="After calling this tool, use the `fetch_android_docs` tool to fetch the contents passing one of more `relative_url`s.", examples={"search_android_docs(\"Android XR\")", "search_android_docs(\"Animations \\\"Jetpack Compose\\\"\")"})
@ToolResult(description="Returns search results containing title, keywords, description and relative_url")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J*\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/google/aiplugin/rag/doc/KbSearchTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/rag/doc/KbSearchTool$Args;", "<init>", "()V", "indexerService", "Lcom/google/aiplugin/rag/doc/KbIndexerService;", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "restoreHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/google/aiplugin/agents/Response;", "metadata", "Lcom/google/aiplugin/agents/ToolCallMetadata;", "createHandler", "Lcom/google/aiplugin/rag/doc/KbSearchTool$Handler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Args", "Handler", "aiplugin.rag.kb"})
public class KbSearchTool
implements Tool<Args> {
    @Nullable
    private final KbIndexerService indexerService = KbIndexerService.Companion.getInstance();
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon = BasicToolIcon.KNOWLEDGE;

    public KbSearchTool() {
        this.name = "search_android_docs";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searching documentation";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searched documentation";
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull Args args, @NotNull Response response2, @NotNull ToolCallMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        return null;
    }

    @NotNull
    public Handler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(this.indexerService, args);
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/google/aiplugin/rag/doc/KbSearchTool$Args;", "", "query", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getQuery", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_rag_kb", "$serializer", "Companion", "aiplugin.rag.kb"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String query;

        public Args(@ToolArgument(description="Keywords to search for to find documentation.") @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.query = query;
        }

        @NotNull
        public final String getQuery() {
            return this.query;
        }

        @NotNull
        public final String component1() {
            return this.query;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="Keywords to search for to find documentation.") @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new Args(query);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.query;
            }
            return args.copy(string);
        }

        @NotNull
        public String toString() {
            return "Args(query=" + this.query + ")";
        }

        public int hashCode() {
            return this.query.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual((Object)this.query, (Object)args.query);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_rag_kb(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.query);
        }

        public /* synthetic */ Args(int seen0, String query, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.query = query;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/rag/doc/KbSearchTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/rag/doc/KbSearchTool$Args;", "aiplugin.rag.kb"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/aiplugin/rag/doc/KbSearchTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "indexerService", "Lcom/google/aiplugin/rag/doc/KbIndexerService;", "args", "Lcom/google/aiplugin/rag/doc/KbSearchTool$Args;", "<init>", "(Lcom/google/aiplugin/rag/doc/KbIndexerService;Lcom/google/aiplugin/rag/doc/KbSearchTool$Args;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.rag.kb"})
    @SourceDebugExtension(value={"SMAP\nKbSearchTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KbSearchTool.kt\ncom/google/aiplugin/rag/doc/KbSearchTool$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n24#2:116\n*S KotlinDebug\n*F\n+ 1 KbSearchTool.kt\ncom/google/aiplugin/rag/doc/KbSearchTool$Handler\n*L\n98#1:116\n*E\n"})
    public static final class Handler
    implements ToolHandler {
        @Nullable
        private final KbIndexerService indexerService;
        @NotNull
        private final Args args;
        @NotNull
        private final Logger log;

        public Handler(@Nullable KbIndexerService indexerService, @NotNull Args args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.indexerService = indexerService;
            this.args = args;
            Handler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Handler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            this.log = logger;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var6_2 = $completion;
            if ((var6_2.label & -2147483648) != 0) {
                var6_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ Handler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (this.indexerService == null) {
                        return new Response(null, "KB Indexer service is not available.", null, null, null, 29, null);
                    }
                    var2_5 = new Object[]{this.args.getQuery()};
                    this.log.debug("Searching for docs: {}", var2_5);
                    $continuation.label = 1;
                    v0 = KbIndexerUtilsKt.checkIndexerStatusIssue(this.indexerService, (Continuation<? super Response>)$continuation);
                    if (v0 == var7_4) {
                        return var7_4;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    v1 = (Response)v0;
                    if (v1 != null) {
                        error = v1;
                        $i$a$-let-KbSearchTool$Handler$handle$2 = false;
                        return error;
                    }
                    searchResults = KbIndexerService.search$default(this.indexerService, this.args.getQuery(), 0, 2, null);
                    return new Response(new Gson().toJson((Object)searchResults), null, null, null, null, 30, null);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

