/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.codemap;

import com.google.aiplugin.rag.codemap.CodeMapUastVisitor;
import com.google.aiplugin.rag.internal.RagIndexerUtilsKt;
import com.google.aiplugin.rag.processing.FileProcessor;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u0004\u0018\u00010\b*\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/aiplugin/rag/codemap/CodeMapProcessor;", "Lcom/google/aiplugin/rag/processing/FileProcessor;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getIndexableTexts", "Lkotlin/sequences/Sequence;", "", "file", "Lcom/intellij/util/indexing/FileContent;", "toDeclarationSignatures", "getDeclarationSignatures", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nCodeMapProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeMapProcessor.kt\ncom/google/aiplugin/rag/codemap/CodeMapProcessor\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,51:1\n171#2:52\n1#3:53\n24#4:54\n*S KotlinDebug\n*F\n+ 1 CodeMapProcessor.kt\ncom/google/aiplugin/rag/codemap/CodeMapProcessor\n*L\n40#1:52\n29#1:54\n*E\n"})
public final class CodeMapProcessor
implements FileProcessor {
    @NotNull
    public static final CodeMapProcessor INSTANCE;
    @NotNull
    private static final Logger logger;

    private CodeMapProcessor() {
    }

    @Override
    @NotNull
    public Sequence<CharSequence> getIndexableTexts(@NotNull FileContent file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object[] objectArray = new CharSequence[]{this.toDeclarationSignatures(file)};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    @NotNull
    public final CharSequence toDeclarationSignatures(@NotNull FileContent file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CharSequence charSequence = this.getDeclarationSignatures(file);
        if (charSequence == null) {
            CharSequence charSequence2 = file.getContentAsText();
            charSequence = charSequence2;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getContentAsText(...)");
        }
        return charSequence;
    }

    private final CharSequence getDeclarationSignatures(FileContent $this$getDeclarationSignatures) {
        if (!(FileContentImpl.getFileTypeWithoutSubstitution((IndexedFile)((IndexedFile)$this$getDeclarationSignatures)) instanceof LanguageFileType)) {
            return null;
        }
        return (CharSequence)ActionsKt.runReadAction(() -> CodeMapProcessor.getDeclarationSignatures$lambda$0($this$getDeclarationSignatures));
    }

    private static final CharSequence getDeclarationSignatures$lambda$0(FileContent $this_getDeclarationSignatures) {
        CharSequence charSequence;
        PsiElement $this$toUElementOfType$iv = (PsiElement)RagIndexerUtilsKt.getPsiFileForAnalysis($this_getDeclarationSignatures);
        boolean $i$f$toUElementOfType = false;
        UFile uFile = (UFile)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UFile.class);
        if (uFile == null) {
            logger.debug("Can't convert to UFile for " + $this_getDeclarationSignatures.getFile().getPath());
            return null;
        }
        CodeMapUastVisitor generator = new CodeMapUastVisitor(null, 1, null);
        uFile.accept((UastVisitor)generator);
        CharSequence it = charSequence = StringsKt.trim((CharSequence)generator.getBuilder());
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? charSequence : null;
    }

    static {
        CodeMapProcessor $this$thisLogger$iv = INSTANCE = new CodeMapProcessor();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CodeMapProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CodeMapProcessor.logger = logger;
    }
}

