/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.mcp.auth;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.aiplugin.mcp.auth.AuthorizationServerMetadata;
import com.google.aiplugin.mcp.auth.AuthorizationServerMetadataInternal;
import com.google.aiplugin.mcp.auth.McpApplicationSettings;
import com.google.aiplugin.mcp.auth.McpServerAuthData;
import com.google.aiplugin.mcp.auth.McpServerAuthDataInternal;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@State(name="McpApplicationSettings", storages={@Storage(value="mcp_auth.xml")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u0000H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/google/aiplugin/mcp/auth/McpApplicationSettingsImpl;", "Lcom/google/aiplugin/mcp/auth/McpApplicationSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "serverAuthData", "", "", "Lcom/google/aiplugin/mcp/auth/McpServerAuthDataInternal;", "getServerAuthData", "()Ljava/util/Map;", "setServerAuthData", "(Ljava/util/Map;)V", "getState", "loadState", "", "state", "Lcom/google/aiplugin/mcp/auth/McpServerAuthData;", "serverName", "networkData", "clearServerAuthData", "aiplugin.mcp.client.sdkcompat"})
@StabilityInferred(parameters=0)
public final class McpApplicationSettingsImpl
implements McpApplicationSettings,
PersistentStateComponent<McpApplicationSettingsImpl> {
    @NotNull
    private Map<String, McpServerAuthDataInternal> serverAuthData = new LinkedHashMap();
    public static final int $stable = 8;

    @NotNull
    public final Map<String, McpServerAuthDataInternal> getServerAuthData() {
        return this.serverAuthData;
    }

    public final void setServerAuthData(@NotNull Map<String, McpServerAuthDataInternal> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.serverAuthData = map2;
    }

    @NotNull
    public McpApplicationSettingsImpl getState() {
        return this;
    }

    public void loadState(@NotNull McpApplicationSettingsImpl state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    @Override
    @Nullable
    public McpServerAuthData getServerAuthData(@NotNull String serverName) {
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        McpServerAuthDataInternal mcpServerAuthDataInternal = this.serverAuthData.get(serverName);
        if (mcpServerAuthDataInternal == null) {
            return null;
        }
        McpServerAuthDataInternal internalData = mcpServerAuthDataInternal;
        AuthorizationServerMetadataInternal authorizationServerMetadataInternal = internalData.getAuthServerMetadata();
        return new McpServerAuthData(internalData.getClientName(), internalData.getClientId(), internalData.getScope(), authorizationServerMetadataInternal != null ? authorizationServerMetadataInternal.toNetworkModel() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setServerAuthData(@NotNull String serverName, @NotNull McpServerAuthData networkData) {
        AuthorizationServerMetadataInternal authorizationServerMetadataInternal;
        McpServerAuthDataInternal mcpServerAuthDataInternal;
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        Intrinsics.checkNotNullParameter((Object)networkData, (String)"networkData");
        Map<String, McpServerAuthDataInternal> map2 = this.serverAuthData;
        McpServerAuthDataInternal $this$setServerAuthData_u24lambda_u240 = mcpServerAuthDataInternal = new McpServerAuthDataInternal(null, null, null, null, 15, null);
        boolean bl = false;
        $this$setServerAuthData_u24lambda_u240.setClientName(networkData.getClientName());
        $this$setServerAuthData_u24lambda_u240.setClientId(networkData.getClientId());
        $this$setServerAuthData_u24lambda_u240.setScope(networkData.getScope());
        McpServerAuthDataInternal mcpServerAuthDataInternal2 = $this$setServerAuthData_u24lambda_u240;
        AuthorizationServerMetadata authorizationServerMetadata = networkData.getAuthServerMetadata();
        if (authorizationServerMetadata != null) {
            void it;
            AuthorizationServerMetadataInternal authorizationServerMetadataInternal2;
            AuthorizationServerMetadata authorizationServerMetadata2 = authorizationServerMetadata;
            McpServerAuthDataInternal mcpServerAuthDataInternal3 = mcpServerAuthDataInternal2;
            boolean bl2 = false;
            AuthorizationServerMetadataInternal $this$setServerAuthData_u24lambda_u240_u240_u240 = authorizationServerMetadataInternal2 = new AuthorizationServerMetadataInternal(null, null, null, null, null, null, null, null, null, 511, null);
            boolean bl3 = false;
            $this$setServerAuthData_u24lambda_u240_u240_u240.setIssuer(it.getIssuer());
            $this$setServerAuthData_u24lambda_u240_u240_u240.setAuthorizationEndpoint(it.getAuthorizationEndpoint());
            $this$setServerAuthData_u24lambda_u240_u240_u240.setTokenEndpoint(it.getTokenEndpoint());
            $this$setServerAuthData_u24lambda_u240_u240_u240.setGrantTypesSupported(it.getGrantTypesSupported());
            $this$setServerAuthData_u24lambda_u240_u240_u240.setResponseTypesSupported(it.getResponseTypesSupported());
            $this$setServerAuthData_u24lambda_u240_u240_u240.setRegistrationEndpoint(it.getRegistrationEndpoint());
            $this$setServerAuthData_u24lambda_u240_u240_u240.setCodeChallengeMethodsSupported(it.getCodeChallengeMethodsSupported());
            $this$setServerAuthData_u24lambda_u240_u240_u240.setScopesSupported(it.getScopesSupported());
            $this$setServerAuthData_u24lambda_u240_u240_u240.setRequireStateParameter(it.getRequireStateParameter());
            authorizationServerMetadataInternal = authorizationServerMetadataInternal2;
            mcpServerAuthDataInternal2 = mcpServerAuthDataInternal3;
        } else {
            authorizationServerMetadataInternal = null;
        }
        mcpServerAuthDataInternal2.setAuthServerMetadata(authorizationServerMetadataInternal);
        map2.put(serverName, mcpServerAuthDataInternal);
    }

    @Override
    public void clearServerAuthData(@NotNull String serverName) {
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        this.serverAuthData.remove(serverName);
    }
}

