/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.write;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolCallMetadata;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.write.ActiveWriteFileHandler;
import com.google.aiplugin.agents.tools.write.RestoredWriteFileHandler;
import com.google.aiplugin.agents.tools.write.WriteFileHandler;
import com.google.aiplugin.agents.tools.write.WriteFileToolArgs;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Writes the given text to the specified file, creating the file if it doesn't exist", instructions="Use this tool to modify the entire contents of a file using an absolute path. Use replace_text instead for smaller or more targeted changes. Files can only be created if they reside within the project.", examples={})
@ToolResult(description="Returns one of these responses:\n- \"file was written\" if the file was successfully updated\n- error \"could not create file\" if the file didn't exist and it could not be created \n- error \"file not in project\" if the file is not part of the project\n- error \"file blocked by aiexclude\" if the file is blocked by a .aiexclude file in the project")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0002H\u0016J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/google/aiplugin/agents/tools/write/WriteFileTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/write/WriteFileToolArgs;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;)V", "name", "", "getName", "()Ljava/lang/String;", "getRunningDisplayText", "args", "getCompletedDisplayText", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "createHandler", "Lcom/google/aiplugin/agents/tools/write/WriteFileHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "restoreHandler", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/google/aiplugin/agents/Response;", "metadata", "Lcom/google/aiplugin/agents/ToolCallMetadata;", "aiplugin.agents.agents-core"})
public final class WriteFileTool
implements Tool<WriteFileToolArgs> {
    @NotNull
    private final VirtualFileSystem fileSystem;
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon;

    public WriteFileTool(@NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.name = "write_file";
        this.icon = BasicToolIcon.EDIT;
    }

    public /* synthetic */ WriteFileTool(VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(virtualFileSystem);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull WriteFileToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Editing " + new File(args.getAbsolutePath()).getName();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull WriteFileToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Edited " + new File(args.getAbsolutePath()).getName();
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @NotNull
    public WriteFileHandler createHandler(@NotNull ToolContext context2, @NotNull WriteFileToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ActiveWriteFileHandler(this, context2, this.fileSystem, args);
    }

    @NotNull
    public WriteFileHandler restoreHandler(@NotNull Project project2, @NotNull WriteFileToolArgs args, @NotNull Response response2, @NotNull ToolCallMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        return new RestoredWriteFileHandler(this, project2, args, response2, metadata);
    }

    public WriteFileTool() {
        this(null, 1, null);
    }
}

