/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.ui;

import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolCallMetadata;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ui.AskUserTool$Args$;
import com.google.aiplugin.agents.tools.ui.AskUserToolHandlerImpl;
import com.google.aiplugin.agents.tools.ui.AskUserToolState;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ToolDescription(summary="Asks the user a question with a set of predefined options and returns the answer.", description="This tool is useful when you need to gather specific information from the user, and you can provide a set of predefined options for them to choose from.Prefer this tool over asking the user directly questions when there is a limited set of possible answers. Using this tool is easier for the user to answer.", instructions="Prefer this tool to asking open ended questions. When possible, just come up with a few options to give to the user.", examples={"ask_user(question = \"What do you want to call the new file name?\", answer_type = \"single_choice\", options = [\"ic_home\", \"ic_start\", \"ic_main\"])", "ask_user(question = \"Which styles would you like to apply?\", answer_type = \"multi_choice\", options = [\"Italic\", \"Bold\", \"Larger font\"])"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB#\b\u0002\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J*\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/google/aiplugin/agents/tools/ui/AskUserTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/ui/AskUserTool$Args;", "askUserToolHandlerProvider", "Lkotlin/Function2;", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Lcom/google/aiplugin/agents/ToolHandler;", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "context", "args", "restoreHandler", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/google/aiplugin/agents/Response;", "metadata", "Lcom/google/aiplugin/agents/ToolCallMetadata;", "getStatusMessage", "Args", "Companion", "aiplugin.agents.agents-core"})
@SourceDebugExtension(value={"SMAP\nAskUserTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AskUserTool.kt\ncom/google/aiplugin/agents/tools/ui/AskUserTool\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n24#2:184\n1#3:185\n*S KotlinDebug\n*F\n+ 1 AskUserTool.kt\ncom/google/aiplugin/agents/tools/ui/AskUserTool\n*L\n166#1:184\n*E\n"})
public final class AskUserTool
implements Tool<Args> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<ToolContext, Args, ToolHandler> askUserToolHandlerProvider;
    @NotNull
    private final String name;

    private AskUserTool(Function2<? super ToolContext, ? super Args, ? extends ToolHandler> askUserToolHandlerProvider) {
        this.askUserToolHandlerProvider = askUserToolHandlerProvider;
        this.name = "ask_user";
    }

    public AskUserTool() {
        this((Function2<? super ToolContext, ? super Args, ? extends ToolHandler>)((Function2)AskUserTool::_init_$lambda$0));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return (ToolHandler)this.askUserToolHandlerProvider.invoke((Object)context2, (Object)args);
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull Args args, @NotNull Response response2, @NotNull ToolCallMetadata metadata) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        try {
            object = (AskUserToolState.Answered)new Gson().fromJson(response2.getStatus(), AskUserToolState.Answered.class);
        }
        catch (JsonSyntaxException t) {
            AskUserTool $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AskUserTool.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)t);
            return null;
        }
        AskUserToolState.Answered result2 = object;
        Object $this$restoreHandler_u24lambda_u240 = object = new AskUserToolHandlerImpl(args);
        boolean bl = false;
        ((AskUserToolHandlerImpl)$this$restoreHandler_u24lambda_u240).onOptionsSubmit(result2.getAnswers());
        return (ToolHandler)object;
    }

    @Override
    @NotNull
    public String getStatusMessage() {
        return "Waiting for your answer...";
    }

    private static final ToolHandler _init_$lambda$0(ToolContext toolContext, Args args) {
        Intrinsics.checkNotNullParameter((Object)toolContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new AskUserToolHandlerImpl(args);
    }

    public /* synthetic */ AskUserTool(Function2 askUserToolHandlerProvider, DefaultConstructorMarker $constructor_marker) {
        this((Function2<? super ToolContext, ? super Args, ? extends ToolHandler>)askUserToolHandlerProvider);
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 %2\u00020\u0001:\u0002$%B+\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB?\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J-\u0010\u0016\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0001\u00a2\u0006\u0002\b#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lcom/google/aiplugin/agents/tools/ui/AskUserTool$Args;", "", "question", "", "answer_type", "options", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getQuestion", "()Ljava/lang/String;", "getAnswer_type", "getOptions", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_agents_agents_core", "$serializer", "Companion", "aiplugin.agents.agents-core"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String question;
        @NotNull
        private final String answer_type;
        @NotNull
        private final List<String> options;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public Args(@ToolArgument(description="The question to ask the user.") @NotNull String question, @ToolArgument(description="The type of answer expected from the user. Can be 'single_choice' or 'multi_choice'.") @NotNull String answer_type, @ToolArgument(description="A list of options for the user to choose from.") @NotNull List<String> options) {
            Intrinsics.checkNotNullParameter((Object)question, (String)"question");
            Intrinsics.checkNotNullParameter((Object)answer_type, (String)"answer_type");
            Intrinsics.checkNotNullParameter(options, (String)"options");
            this.question = question;
            this.answer_type = answer_type;
            this.options = options;
        }

        @NotNull
        public final String getQuestion() {
            return this.question;
        }

        @NotNull
        public final String getAnswer_type() {
            return this.answer_type;
        }

        @NotNull
        public final List<String> getOptions() {
            return this.options;
        }

        @NotNull
        public final String component1() {
            return this.question;
        }

        @NotNull
        public final String component2() {
            return this.answer_type;
        }

        @NotNull
        public final List<String> component3() {
            return this.options;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="The question to ask the user.") @NotNull String question, @ToolArgument(description="The type of answer expected from the user. Can be 'single_choice' or 'multi_choice'.") @NotNull String answer_type, @ToolArgument(description="A list of options for the user to choose from.") @NotNull List<String> options) {
            Intrinsics.checkNotNullParameter((Object)question, (String)"question");
            Intrinsics.checkNotNullParameter((Object)answer_type, (String)"answer_type");
            Intrinsics.checkNotNullParameter(options, (String)"options");
            return new Args(question, answer_type, options);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, String string2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.question;
            }
            if ((n & 2) != 0) {
                string2 = args.answer_type;
            }
            if ((n & 4) != 0) {
                list = args.options;
            }
            return args.copy(string, string2, list);
        }

        @NotNull
        public String toString() {
            return "Args(question=" + this.question + ", answer_type=" + this.answer_type + ", options=" + this.options + ")";
        }

        public int hashCode() {
            int result2 = this.question.hashCode();
            result2 = result2 * 31 + this.answer_type.hashCode();
            result2 = result2 * 31 + ((Object)this.options).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.question, (Object)args.question)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.answer_type, (Object)args.answer_type)) {
                return false;
            }
            return Intrinsics.areEqual(this.options, args.options);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_agents_agents_core(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.question);
            output.encodeStringElement(serialDesc, 1, self.answer_type);
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.options);
        }

        public /* synthetic */ Args(int seen0, String question, String answer_type, List options, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.question = question;
            this.answer_type = answer_type;
            this.options = options;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/agents/tools/ui/AskUserTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/agents/tools/ui/AskUserTool$Args;", "aiplugin.agents.agents-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/google/aiplugin/agents/tools/ui/AskUserTool$Companion;", "", "<init>", "()V", "createAskUserToolForTest", "Lcom/google/aiplugin/agents/tools/ui/AskUserTool;", "askUserToolHandlerProvider", "Lkotlin/Function2;", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Lcom/google/aiplugin/agents/tools/ui/AskUserTool$Args;", "Lcom/google/aiplugin/agents/ToolHandler;", "aiplugin.agents.agents-core"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @NotNull
        public final AskUserTool createAskUserToolForTest(@NotNull Function2<? super ToolContext, ? super Args, ? extends ToolHandler> askUserToolHandlerProvider) {
            Intrinsics.checkNotNullParameter(askUserToolHandlerProvider, (String)"askUserToolHandlerProvider");
            return new AskUserTool(askUserToolHandlerProvider, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

