/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.search;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.search.ListDeclarationsArgs;
import com.google.aiplugin.agents.tools.search.ListDeclarationsInDirectoryHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Returns a list of all public declared symbols in all the files in the given directory", description="This uses IntelliJ's PSI to identify named symbols. Note that this tool does not recurse into subdirectories.", examples={})
@ToolResult(description="A json document containing a list of symbols for each file in the directory.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/google/aiplugin/agents/tools/search/ListDeclarationsInDirectoryTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/search/ListDeclarationsArgs;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;)V", "maxResults", "", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.agents.agents-core"})
public final class ListDeclarationsInDirectoryTool
implements Tool<ListDeclarationsArgs> {
    @NotNull
    private final VirtualFileSystem fileSystem;
    private final int maxResults;
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon;

    public ListDeclarationsInDirectoryTool(@NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.maxResults = 200;
        this.name = "list_definitions_in_directory";
        this.icon = BasicToolIcon.SEARCH;
    }

    public /* synthetic */ ListDeclarationsInDirectoryTool(VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(virtualFileSystem);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ListDeclarationsArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searching for declarations";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ListDeclarationsArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searched for declarations";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ListDeclarationsArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ListDeclarationsInDirectoryHandler(context2, this.fileSystem, args, this.maxResults);
    }

    public ListDeclarationsInDirectoryTool() {
        this(null, 1, null);
    }
}

