/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.search;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.search.FindUsagesTool;
import com.google.aiplugin.agents.tools.search.FindUsagesTool$Args$;
import com.google.gson.Gson;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Searches the project for references to a given declaration", instructions="General tip: use this tool before editing any declaration names or type signatures, as the usages may need to be edited first.", examples={"find_usages(symbol = \"foo\", contextSnippet = \"fun foo() {\", contextFile = \"/path/to/src/File.kt\")"})
@ToolResult(description="For each reference found, the tool provides the containing file path. At most 10 usages are returned.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindUsagesTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Args;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Companion", "Args", "Result", "Usage", "Handler", "aiplugin.agents.agents-core"})
public final class FindUsagesTool
implements Tool<Args> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon = BasicToolIcon.SEARCH;
    public static final int MAX_NUM_USAGES = 10;

    public FindUsagesTool() {
        this.name = "find_usages";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Finding usages of '" + args.getSymbol() + "'";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Found usages of '" + args.getSymbol() + "'";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B9\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Args;", "", "symbol", "", "contextSnippet", "contextFile", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSymbol", "()Ljava/lang/String;", "getContextSnippet", "getContextFile", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_agents_agents_core", "$serializer", "Companion", "aiplugin.agents.agents-core"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String symbol;
        @NotNull
        private final String contextSnippet;
        @NotNull
        private final String contextFile;

        public Args(@ToolArgument(description="The target declaration name") @NotNull String symbol, @ToolArgument(description="A small snippet of surrounding text to help identify a specific declaration within a file") @NotNull String contextSnippet, @ToolArgument(description="The absolute path of the file in which the declaration resides") @NotNull String contextFile) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)contextSnippet, (String)"contextSnippet");
            Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
            this.symbol = symbol;
            this.contextSnippet = contextSnippet;
            this.contextFile = contextFile;
        }

        @NotNull
        public final String getSymbol() {
            return this.symbol;
        }

        @NotNull
        public final String getContextSnippet() {
            return this.contextSnippet;
        }

        @NotNull
        public final String getContextFile() {
            return this.contextFile;
        }

        @NotNull
        public final String component1() {
            return this.symbol;
        }

        @NotNull
        public final String component2() {
            return this.contextSnippet;
        }

        @NotNull
        public final String component3() {
            return this.contextFile;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="The target declaration name") @NotNull String symbol, @ToolArgument(description="A small snippet of surrounding text to help identify a specific declaration within a file") @NotNull String contextSnippet, @ToolArgument(description="The absolute path of the file in which the declaration resides") @NotNull String contextFile) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)contextSnippet, (String)"contextSnippet");
            Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
            return new Args(symbol, contextSnippet, contextFile);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.symbol;
            }
            if ((n & 2) != 0) {
                string2 = args.contextSnippet;
            }
            if ((n & 4) != 0) {
                string3 = args.contextFile;
            }
            return args.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Args(symbol=" + this.symbol + ", contextSnippet=" + this.contextSnippet + ", contextFile=" + this.contextFile + ")";
        }

        public int hashCode() {
            int result2 = this.symbol.hashCode();
            result2 = result2 * 31 + this.contextSnippet.hashCode();
            result2 = result2 * 31 + this.contextFile.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.symbol, (Object)args.symbol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contextSnippet, (Object)args.contextSnippet)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.contextFile, (Object)args.contextFile);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_agents_agents_core(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.symbol);
            output.encodeStringElement(serialDesc, 1, self.contextSnippet);
            output.encodeStringElement(serialDesc, 2, self.contextFile);
        }

        public /* synthetic */ Args(int seen0, String symbol, String contextSnippet, String contextFile, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.symbol = symbol;
            this.contextSnippet = contextSnippet;
            this.contextFile = contextFile;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Args;", "aiplugin.agents.agents-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Companion;", "", "<init>", "()V", "MAX_NUM_USAGES", "", "aiplugin.agents.agents-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Args;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Args;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Args;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findTargetDeclaration", "Lcom/intellij/psi/PsiElement;", "processUsage", "Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Usage;", "usage", "Lcom/intellij/psi/PsiReference;", "ErrorResponse", "aiplugin.agents.agents-core"})
    public static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final Args args;

        public Handler(@NotNull ToolContext context2, @NotNull Args args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
        }

        @NotNull
        public final ToolContext getContext() {
            return this.context;
        }

        @NotNull
        public final Args getArgs() {
            return this.args;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var8_2 = $completion;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ Handler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    inSmartMode = ReadConstraint.Companion.inSmartMode(this.context.getProject());
                    withDocumentsCommitted = ReadConstraint.Companion.withDocumentsCommitted(this.context.getProject());
                    var5_8 = new ReadConstraint[]{inSmartMode, withDocumentsCommitted};
                    $continuation.label = 1;
                    v0 = CoroutinesKt.constrainedReadAction((ReadConstraint[])var5_8, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handle$lambda$0(com.google.aiplugin.agents.tools.search.FindUsagesTool$Handler ), ()Lcom/intellij/psi/PsiElement;)((Handler)this), (Continuation)$continuation);
                    ** if (v0 != var9_4) goto lbl21
lbl20:
                    // 1 sources

                    return var9_4;
lbl21:
                    // 1 sources

                    ** GOTO lbl27
                }
                case 1: {
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl27:
                        // 2 sources

                        declaration = (PsiElement)v0;
                        usages = new ArrayList<E>();
                        allProcessed = ReferencesSearch.search((PsiElement)declaration).forEach((Processor)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, handle$lambda$1(java.util.List com.google.aiplugin.agents.tools.search.FindUsagesTool$Handler com.intellij.psi.PsiReference ), (Lcom/intellij/psi/PsiReference;)Z)((List)usages, (Handler)this));
                        return new Response(new Gson().toJson((Object)new Result(usages, allProcessed == false)), null, null, null, null, 30, null);
                    }
                    catch (ErrorResponse e) {
                        return new Response(null, e.getReason(), null, null, null, 29, null);
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @RequiresReadLock
        @NotNull
        public final PsiElement findTargetDeclaration() {
            PsiElement resolved;
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(this.args.getContextFile());
            if (vFile == null) {
                throw new ErrorResponse("context file not found");
            }
            AiExcludeService aiExcludeService2 = AiExcludeService.Companion.getInstance(this.context.getProject());
            if (aiExcludeService2.isFileExcluded(vFile)) {
                throw new ErrorResponse("context file blocked by aiexclude");
            }
            if (!GlobalSearchScope.allScope((Project)this.context.getProject()).contains(vFile)) {
                throw new ErrorResponse("context file is outside the project");
            }
            PsiFile psiFile2 = VirtualFileUtil.findPsiFile((VirtualFile)vFile, (Project)this.context.getProject());
            if (psiFile2 == null) {
                throw new ErrorResponse("context file AST not found");
            }
            Document document2 = psiFile2.getFileDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getFileDocument(...)");
            Document document3 = document2;
            CharSequence charSequence = document3.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            int snippetOffset = StringsKt.indexOf$default((CharSequence)charSequence, (String)this.args.getContextSnippet(), (int)0, (boolean)false, (int)6, null);
            if (snippetOffset < 0) {
                throw new ErrorResponse("context snippet not found in file");
            }
            int offsetInSnippet = StringsKt.indexOf$default((CharSequence)this.args.getContextSnippet(), (String)this.args.getSymbol(), (int)0, (boolean)false, (int)6, null);
            if (offsetInSnippet < 0) {
                throw new ErrorResponse("declaration identifier not found in context snippet");
            }
            int offset2 = snippetOffset + offsetInSnippet;
            PsiElement leafElement = psiFile2.findElementAt(offset2);
            PsiNameIdentifierOwner declaration = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)leafElement, PsiNameIdentifierOwner.class);
            if (declaration != null && Intrinsics.areEqual((Object)declaration.getNameIdentifier(), (Object)leafElement)) {
                return (PsiElement)declaration;
            }
            PsiReference psiReference = psiFile2.findReferenceAt(offset2);
            Object object = resolved = psiReference != null ? psiReference.resolve() : null;
            if (resolved != null) {
                return resolved;
            }
            throw new ErrorResponse("failed to identify the target declaration");
        }

        @RequiresReadLock
        @NotNull
        public final Usage processUsage(@NotNull PsiReference usage) {
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            PsiFile psiFile2 = usage.getElement().getContainingFile();
            if (psiFile2 == null) {
                return new Usage("<unknown_file_path>");
            }
            PsiFile containingFile = psiFile2;
            String string = containingFile.getViewProvider().getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return new Usage(string);
        }

        private static final PsiElement handle$lambda$0(Handler this$0) {
            return this$0.findTargetDeclaration();
        }

        private static final boolean handle$lambda$1(List $usages, Handler this$0, PsiReference usage) {
            if ($usages.size() >= 10) {
                return false;
            }
            ThreadingAssertions.assertReadAccess();
            Intrinsics.checkNotNull((Object)usage);
            $usages.add(this$0.processUsage(usage));
            return $usages.size() < 10;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Handler$ErrorResponse;", "", "reason", "", "<init>", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "aiplugin.agents.agents-core"})
        public static final class ErrorResponse
        extends Throwable {
            @NotNull
            private final String reason;

            public ErrorResponse(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Result;", "", "usages", "", "Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Usage;", "resultsMightBeIncomplete", "", "<init>", "(Ljava/util/List;Z)V", "getUsages", "()Ljava/util/List;", "getResultsMightBeIncomplete", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "aiplugin.agents.agents-core"})
    public static final class Result {
        @NotNull
        private final List<Usage> usages;
        private final boolean resultsMightBeIncomplete;

        public Result(@NotNull List<Usage> usages, boolean resultsMightBeIncomplete) {
            Intrinsics.checkNotNullParameter(usages, (String)"usages");
            this.usages = usages;
            this.resultsMightBeIncomplete = resultsMightBeIncomplete;
        }

        @NotNull
        public final List<Usage> getUsages() {
            return this.usages;
        }

        public final boolean getResultsMightBeIncomplete() {
            return this.resultsMightBeIncomplete;
        }

        @NotNull
        public final List<Usage> component1() {
            return this.usages;
        }

        public final boolean component2() {
            return this.resultsMightBeIncomplete;
        }

        @NotNull
        public final Result copy(@NotNull List<Usage> usages, boolean resultsMightBeIncomplete) {
            Intrinsics.checkNotNullParameter(usages, (String)"usages");
            return new Result(usages, resultsMightBeIncomplete);
        }

        public static /* synthetic */ Result copy$default(Result result2, List list, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                list = result2.usages;
            }
            if ((n & 2) != 0) {
                bl = result2.resultsMightBeIncomplete;
            }
            return result2.copy(list, bl);
        }

        @NotNull
        public String toString() {
            return "Result(usages=" + this.usages + ", resultsMightBeIncomplete=" + this.resultsMightBeIncomplete + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.usages).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.resultsMightBeIncomplete);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.usages, result2.usages)) {
                return false;
            }
            return this.resultsMightBeIncomplete == result2.resultsMightBeIncomplete;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindUsagesTool$Usage;", "", "file", "", "<init>", "(Ljava/lang/String;)V", "getFile", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.agents.agents-core"})
    public static final class Usage {
        @NotNull
        private final String file;

        public Usage(@NotNull String file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        @NotNull
        public final String component1() {
            return this.file;
        }

        @NotNull
        public final Usage copy(@NotNull String file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new Usage(file);
        }

        public static /* synthetic */ Usage copy$default(Usage usage, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = usage.file;
            }
            return usage.copy(string);
        }

        @NotNull
        public String toString() {
            return "Usage(file=" + this.file + ")";
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Usage)) {
                return false;
            }
            Usage usage = (Usage)other;
            return Intrinsics.areEqual((Object)this.file, (Object)usage.file);
        }
    }
}

