/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.read;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolCallMetadata;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.read.ReadUrlArgs;
import com.google.aiplugin.agents.tools.read.ReadUrlHandlerImpl;
import com.google.aiplugin.agents.tools.read.RestoredReadUrlHandler;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Retrieves the contents of the given URL", instructions="Each time you request to read a URL, the user has to approve it. The user may deny a request, in which case you should not try reading the same URL again.", examples={})
@ToolResult(description="The contents of the URL, or an error message if the URL could not be read or if the user did not approve the request.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J(\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/google/aiplugin/agents/tools/read/ReadUrlTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/read/ReadUrlArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "restoreHandler", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/google/aiplugin/agents/Response;", "metadata", "Lcom/google/aiplugin/agents/ToolCallMetadata;", "aiplugin.agents.agents-core"})
public final class ReadUrlTool
implements Tool<ReadUrlArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon = BasicToolIcon.WEB;

    public ReadUrlTool() {
        this.name = "read_url";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ReadUrlArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Reading URL: " + args.getUrl();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ReadUrlArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Read URL: " + args.getUrl();
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ReadUrlArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ReadUrlHandlerImpl(context2, args);
    }

    @Override
    @NotNull
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull ReadUrlArgs args, @NotNull Response response2, @NotNull ToolCallMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        boolean approved = response2.getStatus() != null && !StringsKt.startsWith$default((String)response2.getStatus(), (String)"Error: ", (boolean)false, (int)2, null);
        return new RestoredReadUrlHandler(args, null, approved);
    }
}

