/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.read;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.read.ReadFileArgs;
import com.google.aiplugin.agents.tools.read.ReadFileToolHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Retrieves the text content of a file using its absolute path", description="Use this tool to read file contents when you have the file's absolute path. Do not attempt to read a path that hasn't been previously mentioned.", examples={})
@ToolResult(description="Returns one of these responses:\n- The file's content if the file exists and belongs to the project\n- error \"file not found\" if the file doesn't exist\n- error \"file blocked by aiexclude\" if the file is blocked by a .aiexclude file in the project- error \"could not get document\" if the file is a directory or binary or too large- error \"user did not allow reading the file\" if the user did not allow reading the file")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/google/aiplugin/agents/tools/read/ReadFileTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/read/ReadFileArgs;", "localFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;)V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/tools/read/ReadFileToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.agents.agents-core"})
public final class ReadFileTool
implements Tool<ReadFileArgs> {
    @NotNull
    private final VirtualFileSystem localFileSystem;
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon;

    public ReadFileTool(@NotNull VirtualFileSystem localFileSystem) {
        Intrinsics.checkNotNullParameter((Object)localFileSystem, (String)"localFileSystem");
        this.localFileSystem = localFileSystem;
        this.name = "read_file";
        this.icon = BasicToolIcon.READ;
    }

    public /* synthetic */ ReadFileTool(VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(virtualFileSystem);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ReadFileArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Reading " + new File(args.getAbsolutePath()).getName();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ReadFileArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Read " + new File(args.getAbsolutePath()).getName();
    }

    @NotNull
    public ReadFileToolHandler createHandler(@NotNull ToolContext context2, @NotNull ReadFileArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ReadFileToolHandler(context2, this.localFileSystem, args, null, 8, null);
    }

    public ReadFileTool() {
        this(null, 1, null);
    }
}

