/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.settings;

import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.templates.BuiltInPromptsProvider;
import com.android.studio.ml.templates.PromptTemplate;
import com.android.studio.ml.templates.PromptTemplateImpl;
import com.android.studio.ml.templates.PromptTemplateScheme;
import com.android.studio.ml.templates.Templates;
import com.android.studio.ml.templates.TemplatesKt;
import com.android.studio.ml.templates.ValidationError;
import com.android.studio.ml.templates.settings.PromptTemplateEditor;
import com.android.studio.ml.templates.settings.PromptTemplatesList;
import com.android.studio.ml.templates.settings.PromptTemplatesSchemePanel;
import com.android.studio.ml.util.TruncateKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class PromptTemplatesSettingsComponent {
    private final JPanel myMainPanel;
    private final PromptTemplatesSchemePanel mySchemesPanel;
    private final PromptTemplatesList myTemplatesList;
    private final PromptTemplateEditor editor;
    private final boolean addSinglePromptMode;
    private final Splitter centralSplitter;
    private final JComponent editorComponent;
    private final JComponent groupComponent;
    private Templates state;
    private PromptTemplateImpl newUserPrompt;
    public static int MAX_SUGGESTED_NAME_LENGTH = 60;
    public static int MIN_SUGGESTED_NAME_LENGTH = 5;

    public PromptTemplatesSettingsComponent(Project project2, Disposable parentDisposable, boolean addSinglePromptMode) {
        this.addSinglePromptMode = addSinglePromptMode;
        this.myTemplatesList = new PromptTemplatesList(this::updateEditorWithSelectedTemplate, project2);
        this.mySchemesPanel = new PromptTemplatesSchemePanel(this::onSchemeChanged);
        this.mySchemesPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)0, (int)10));
        this.mySchemesPanel.resetSchemes((Collection)PromptTemplateScheme.getEntries());
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)((Object)this.mySchemesPanel), "North");
        JPanel leftPanel = new JPanel(new CardLayout());
        leftPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTemplatesList.getComponent(), (int)20, (int)31), "Prompt Templates");
        this.editor = new PromptTemplateEditor(project2);
        this.editor.addChangeListener(e -> this.onEditorChanged());
        Disposer.register((Disposable)parentDisposable, (Disposable)this.editor);
        this.editorComponent = this.editor.createComponent();
        this.editorComponent.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)10, (int)10));
        RemoveAction removeAction2 = new RemoveAction();
        CloneAction cloneAction = new CloneAction();
        AddAction addAction = new AddAction();
        RevertToDefaultAction revertAction = new RevertToDefaultAction();
        cloneAction.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), this.myTemplatesList.getComponent());
        addAction.registerCustomShortcutSet(CommonShortcuts.getInsert(), this.myTemplatesList.getComponent());
        removeAction2.registerCustomShortcutSet(CommonShortcuts.getDelete(), this.myTemplatesList.getComponent());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("FileTemplatesConfigurable", (ActionGroup)new DefaultActionGroup(new AnAction[]{addAction, removeAction2, cloneAction, revertAction}), true);
        toolbar.setTargetComponent((JComponent)leftPanel);
        JComponent toolBar = toolbar.getComponent();
        toolBar.setBorder((Border)new CustomLineBorder(1, 1, 0, 1));
        JPanel leftPanelWrapper = new JPanel(new BorderLayout());
        leftPanelWrapper.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)10, (int)0));
        leftPanelWrapper.add("North", toolBar);
        leftPanelWrapper.add("Center", leftPanel);
        this.groupComponent = new JLabel(SmlBundle.message("sml.studiobot.settings.prompt.templates.group.hint", new Object[0]), 0);
        if (addSinglePromptMode) {
            this.myMainPanel.add((Component)this.editorComponent, "Center");
            this.centralSplitter = null;
        } else {
            JPanel centerPanel = new JPanel(new BorderLayout());
            this.centralSplitter = new Splitter(false, 0.3f);
            this.centralSplitter.setDividerWidth(JBUIScale.scale((int)10));
            this.centralSplitter.setFirstComponent((JComponent)leftPanelWrapper);
            this.centralSplitter.setSecondComponent(this.groupComponent);
            centerPanel.add((Component)this.centralSplitter, "Center");
            this.myMainPanel.add((Component)centerPanel, "Center");
        }
    }

    public static String suggestName(String text2) {
        try {
            int truncateAt;
            text2 = text2.split("\n")[0].trim();
            if (text2.length() > MAX_SUGGESTED_NAME_LENGTH && (truncateAt = text2.lastIndexOf(32, MAX_SUGGESTED_NAME_LENGTH)) > MIN_SUGGESTED_NAME_LENGTH) {
                text2 = text2.substring(0, truncateAt).trim();
            }
            if (text2.length() > MAX_SUGGESTED_NAME_LENGTH) {
                text2 = TruncateKt.truncate(text2, MAX_SUGGESTED_NAME_LENGTH, '\u2026');
            }
            return text2 + "{0}";
        }
        catch (Exception exception) {
            return "Unnamed{0}";
        }
    }

    public PromptTemplateScheme selectedScheme() {
        return (PromptTemplateScheme)this.mySchemesPanel.getSelectedScheme();
    }

    public void addNewFromTimeline(String text2) {
        this.newUserPrompt = this.createTemplate(PromptTemplatesSettingsComponent.suggestName(text2), this.selectedScheme());
        this.newUserPrompt.setText(text2);
        this.editor.setTemplate(this.newUserPrompt);
        this.editor.focusToNameField();
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    public void reset(Templates state2) {
        this.state = state2;
        this.editor.setTemplate(null);
        this.mySchemesPanel.selectScheme(PromptTemplateScheme.IDE);
        this.onStateChanged();
    }

    SettingsUIState getState() {
        return new SettingsUIState(this.state, this.newUserPrompt, this.newUserPrompt == null ? null : this.selectedScheme());
    }

    private void onStateChanged() {
        this.onSchemeChanged(this.selectedScheme());
    }

    @VisibleForTesting
    public void onSchemeChanged(@NotNull PromptTemplateScheme newScheme) {
        if (this.state == null || this.addSinglePromptMode) {
            return;
        }
        this.myTemplatesList.onSchemeChanged(this.state, newScheme);
    }

    private void onEditorChanged() {
        this.myTemplatesList.onStateChange();
    }

    private void updateEditorWithSelectedTemplate() {
        if (this.editor == null) {
            return;
        }
        PromptTemplateImpl selectedValue = this.getSelectedTemplate();
        if (selectedValue != null && selectedValue == this.editor.getTemplate()) {
            return;
        }
        if (selectedValue != null) {
            this.editor.setTemplate(selectedValue);
            this.centralSplitter.setSecondComponent(this.editorComponent);
            IJSwingUtilities.updateComponentTreeUI((Component)this.editorComponent);
        } else {
            this.editor.setTemplate(null);
            this.centralSplitter.setSecondComponent(this.groupComponent);
            IJSwingUtilities.updateComponentTreeUI((Component)this.groupComponent);
        }
    }

    void focusOnFieldWithError(PromptTemplateScheme scheme, PromptTemplate template, ValidationError reason) {
        if (!this.addSinglePromptMode) {
            this.mySchemesPanel.selectScheme(scheme);
            this.myTemplatesList.selectTemplate(template);
        }
        if (reason == ValidationError.EmptyPrompt) {
            ApplicationManager.getApplication().invokeLater(this.editor::focusToTextField);
        } else {
            ApplicationManager.getApplication().invokeLater(this.editor::focusToNameField);
        }
    }

    private PromptTemplateImpl createTemplate(String nameTemplate, PromptTemplateScheme scheme) {
        Set<String> existingNames = this.state.getTemplates(scheme).stream().map(PromptTemplate::getName).collect(Collectors.toSet());
        String nameCandidate = PromptTemplatesSettingsComponent.uniqueNameCandidate(nameTemplate, existingNames);
        return this.state.newPromptTemplate(nameCandidate, true);
    }

    public static String uniqueNameCandidate(String nameTemplate, Set<String> existingNames) {
        String nameCandidate = nameTemplate.replace("{0}", "");
        if (!existingNames.contains(nameCandidate)) {
            return nameCandidate;
        }
        for (int i2 = 1; i2 < 100; ++i2) {
            nameCandidate = nameTemplate.replace("{0}", " " + i2);
            if (existingNames.contains(nameCandidate)) continue;
            return nameCandidate;
        }
        return nameTemplate.replace("{0}", "");
    }

    @VisibleForTesting
    @Nullable
    public PromptTemplateImpl getSelectedTemplate() {
        return this.myTemplatesList == null ? null : this.myTemplatesList.getSelectedTemplate();
    }

    public class RemoveAction
    extends DumbAwareAction {
        public RemoveAction() {
            super(IdeBundle.message((String)"default.icons.remove.text", (Object[])new Object[0]), null, AllIcons.General.Remove);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PromptTemplateImpl selectedTemplate = PromptTemplatesSettingsComponent.this.getSelectedTemplate();
            if (selectedTemplate == null) {
                return;
            }
            int selectedIndex = PromptTemplatesSettingsComponent.this.myTemplatesList.getSelectedIndex();
            PromptTemplatesSettingsComponent.this.state.remove(PromptTemplatesSettingsComponent.this.selectedScheme(), selectedTemplate);
            PromptTemplatesSettingsComponent.this.onStateChanged();
            int rowCount = PromptTemplatesSettingsComponent.this.myTemplatesList.getRowCount();
            int newIndexToSelect = rowCount <= selectedIndex ? selectedIndex - 1 : selectedIndex;
            PromptTemplatesSettingsComponent.this.myTemplatesList.setSelectedIndex(newIndexToSelect);
        }

        public void update(@NotNull AnActionEvent e) {
            PromptTemplateImpl selectedTemplate = PromptTemplatesSettingsComponent.this.getSelectedTemplate();
            e.getPresentation().setEnabled(selectedTemplate != null && TemplatesKt.isUserManaged(selectedTemplate));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    private class CloneAction
    extends DumbAwareAction {
        public CloneAction() {
            super(SmlBundle.message("sml.studiobot.settings.prompt.templates.duplicate.template", new Object[0]), null, PlatformIcons.COPY_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PromptTemplateImpl selected = PromptTemplatesSettingsComponent.this.getSelectedTemplate();
            if (selected == null) {
                return;
            }
            PromptTemplateImpl newTemplate = PromptTemplatesSettingsComponent.this.createTemplate("Copy{0} of " + selected.getName(), PromptTemplatesSettingsComponent.this.selectedScheme());
            newTemplate.setText(selected.getText());
            newTemplate.setEnabled(selected.getEnabled());
            newTemplate.setShowInSlashCommands(selected.getShowInSlashCommands());
            PromptTemplatesSettingsComponent.this.state.add(PromptTemplatesSettingsComponent.this.selectedScheme(), newTemplate);
            PromptTemplatesSettingsComponent.this.onStateChanged();
            PromptTemplatesSettingsComponent.this.myTemplatesList.selectTemplate(newTemplate);
            PromptTemplatesSettingsComponent.this.editor.focusToNameField();
        }

        public void update(@NotNull AnActionEvent e) {
            PromptTemplateImpl selectedTemplate = PromptTemplatesSettingsComponent.this.getSelectedTemplate();
            e.getPresentation().setEnabled(selectedTemplate != null && TemplatesKt.isUserManaged(selectedTemplate));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @VisibleForTesting
    public class AddAction
    extends DumbAwareAction {
        public AddAction() {
            super(IdeBundle.message((String)"default.icons.add.text", (Object[])new Object[0]), null, AllIcons.General.Add);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PromptTemplateImpl newTemplate = PromptTemplatesSettingsComponent.this.createTemplate("Unnamed{0}", PromptTemplatesSettingsComponent.this.selectedScheme());
            PromptTemplatesSettingsComponent.this.state.add(PromptTemplatesSettingsComponent.this.selectedScheme(), newTemplate);
            PromptTemplatesSettingsComponent.this.onStateChanged();
            PromptTemplatesSettingsComponent.this.myTemplatesList.selectTemplate(newTemplate);
            PromptTemplatesSettingsComponent.this.editor.focusToNameField();
        }
    }

    private class RevertToDefaultAction
    extends DumbAwareAction {
        public RevertToDefaultAction() {
            super(SmlBundle.message("sml.studiobot.settings.prompt.templates.revert.template", new Object[0]), null, AllIcons.Actions.Undo);
        }

        public String defaultText(PromptTemplateImpl template) {
            if (template == null) {
                return null;
            }
            BuiltInPromptsProvider.PromptDefinition definition = template.getPromptDefinition();
            if (definition == null) {
                return null;
            }
            return definition.getDefaultText();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PromptTemplateImpl selected = PromptTemplatesSettingsComponent.this.getSelectedTemplate();
            String defaultText = this.defaultText(selected);
            if (selected == null || defaultText == null) {
                return;
            }
            selected.setText(defaultText);
            PromptTemplatesSettingsComponent.this.onStateChanged();
            PromptTemplatesSettingsComponent.this.editor.focusToTextField();
        }

        public void update(@NotNull AnActionEvent e) {
            PromptTemplateImpl selectedTemplate = PromptTemplatesSettingsComponent.this.getSelectedTemplate();
            String defaultText = this.defaultText(selectedTemplate);
            e.getPresentation().setEnabled(selectedTemplate != null && defaultText != null && !defaultText.isEmpty() && !defaultText.equals(selectedTemplate.getText()));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    record SettingsUIState(@NotNull Templates templates, PromptTemplateImpl newPrompt, PromptTemplateScheme newPromptScheme) {
    }
}

